/* eslint-disable */
import { RevisionStatus, InstanceRevision } from '../../../../../yp_proto/yp/client/hq/proto/types';

/**
 * HARDLINK -  На одинаковые файлы будут создаваться жесткие ссылки. Режим по умолчанию.
 *
 * NO -  Не дедуплицировать.
 *
 * SYMLINK -  На одинаковые файлы будут создаваться символьные ссылки.
 *
 */
export enum DeduplicationMode {
   HARDLINK = 0,
   NO = 1,
   SYMLINK = 2,
}

export enum InstanceType {
   ENTITY = 0,
   INSTANCE = 1,
   JOB = 2,
}

/**
 * Состояние инстанса
 * PREEMPTED_ON_AGENT -  this value will never be set by agent due to ISS-3921
 *  but it was kept for backward compatibility
 *
 */
export enum MasterState {
   INIT = 0,
   DOWNLOADING = 1,
   DOWNLOADED = 2,
   PREPARING = 3,
   VALIDATING = 4,
   PREPARED = 5,
   ACTIVATING = 6,
   ACTIVE = 7,
   IN_PROGRESS = 8,
   DONE = 9,
   FAILED = 10,
   DEACTIVATING = 11,
   REMOVING = 12,
   REMOVED = 13,
   INVALID = 14,
   PREEMPTED_ON_AGENT = 15,
}

/**
 *  Имена хуков
 */
export enum HookName {
   HOOK_UNKNOWN = 0,
   HOOK_INSTALL = 1,
   HOOK_VALIDATE = 2,
   HOOK_START = 3,
   HOOK_STATUS = 4,
   HOOK_STOP = 5,
   HOOK_NOTIFY = 6,
   HOOK_UNINSTALL = 7,
   HOOK_META = 8,
   HOOK_SHARD_INSTALL = 9,
   HOOK_SHARD_UNINSTALL = 10,
   HOOK_SHARD_SHARE = 11,
   SERVICE_META = 12,
}

export enum ContainerEventName {
   CONTAINER_EVENT_UNKNOWN = 0,
   PROPERTIES_CHANGED_WITHOUT_RESTART = 1,
   DESTROYED_TO_CHANGE_PROPERTIES = 2,
   PROPERTIES_CHANGE_SYSTEM_FAILURE = 3,
}

/**
 *  Имя стадии подготовки ресурса
 * PREPARE_STAGE_DOWNLOAD -  Ресурс скачивается
 *
 * PREPARE_STAGE_BLOCKED -  Ресурс в очереди
 *
 * PREPARE_STAGE_VALIDATE -  Ресурс валидируется
 *
 * PREPARE_STAGE_SHARE -  Ресурс расшаривается (только шарды)
 *
 * PREPARE_STAGE_INSTALL -  Ресурс инсталлируется (только шарды)
 *
 * PREPARE_STAGE_UNINSTALL -  Ресурс удаляется (только шарды)
 *
 */
export enum ResourcePrepareStageName {
   PREPARE_STAGE_UNKNOWN = 0,
   PREPARE_STAGE_DOWNLOAD = 1,
   PREPARE_STAGE_BLOCKED = 2,
   PREPARE_STAGE_VALIDATE = 3,
   PREPARE_STAGE_SHARE = 4,
   PREPARE_STAGE_INSTALL = 5,
   PREPARE_STAGE_UNINSTALL = 6,
}

/**
 *  Описание результата выполнения хука
 * SUCCESS -  Процесс завершился с нулевым кодом возврата
 *
 * NON_ZERO_RETCODE -  Процесс завершился с ненулевым кодом возврата
 *
 * OUT_OF_MEMORY -  Процесс убили из-за превышения памяти
 *
 * TIMEOUT -  Произошел таймаут выполенния
 *
 * KILLED_EXTERNALLY -  Процесс был убит из вне (кто-то вызвал kill или destroy)
 *
 * SYSTEM_FAILURE -  Произошла системная ошибка (например ошибка от порто или т.п.)
 *
 * SEMI_FAILED - Подробнее о semi_failed хуках можно почитать здесь
 * https://wiki.yandex-team.ru/iss3/specifications/configuration/instance/
 * Засчитывается в FinishedProcessExecutions::nonZeroRetcodesCount
 *
 */
export enum ProcessExecutionResultName {
   UNKNOWN = 0,
   SUCCESS = 1,
   NON_ZERO_RETCODE = 2,
   OUT_OF_MEMORY = 3,
   HOOK_NOT_EXISTS = 4,
   TIMEOUT = 5,
   KILLED_EXTERNALLY = 6,
   SYSTEM_FAILURE = 7,
   SEMI_FAILED = 8,
}

export interface Entity {
   instance: Instance | undefined;
   job: Job | undefined;
}

export interface ExtendedGroupId {
   id: string;
   capiId: string;
}

/**
 *  Демон, он же инстанс - после завершения сущность перезапускается каждый раз, пока не будет удалена с кластера
 *  Подробнее здесь - https://wiki.yandex-team.ru/iss3/Specifications/configuration/instance/
 */
export interface Instance {
   /**
    *  Ограничения для всех хуков
    */
   container: Container | undefined;
   volumes: Volume[];
   /**
    *  <имя ресурса> -> <описание ресурса>
    */
   resources: { [key: string]: Resourcelike };
   /**
    *  <имя хука> -> <временные лимиты>
    *  Имена хуков см https://wiki.yandex-team.ru/iss3/Specifications/configuration/instance/#naznacheniexukov
    */
   timeLimits: { [key: string]: TimeLimit };
   /**
    *  Точка монтирования, в которой создается рабочая директория инстанса.
    *  По умолчанию - "/".
    */
   storage: string;
   /**
    *  ACL-идентификатор владельца шаред-вольюмов
    *  Нужно для data locality ISS-3660
    */
   project: string;
   /**
    *  ссылки на внешние шаред-вольюмы
    *  Нужно для data locality ISS-3660
    */
   volumeRefs: VolumeRef[];
   /**
    *  Слои, из которых собирается корневой раздел
    */
   layers: Resource[];
   /**
    *  Хостовые директории или файлы, смонтированные в mount namespace инстанса
    */
   host_mounts: HostMount[];
   /**
    *  Отдельно включаемые и выключаемые изменения в поведении агента,
    *  например: "монтировать ли ресурсы в режиме read-only"
    *  Использование этих опций полезно в двух случаях:
    *  1. Если для изменения в поведении не нужны дополнительные настройки (например, bind_ro_resources)
    *  2. Если схематизировать настройки нового поведения не выгодно по каким-то причинам, например:
    *     - мы ещё не готовы фиксировать схему, т.к. не уверены в ней, и она будет многократно меняться;
    *     - чтобы не ждать выкладки релиза YP, когда нам достаточно потестить поведение на паре хостов,
    *       куда мы можем быстро доставить новую версию ISS-агента.
    */
   features: Feature[];
}

export interface Instance_ResourcesEntry {
   key: string;
   value: Resourcelike | undefined;
}

export interface Instance_TimeLimitsEntry {
   key: string;
   value: TimeLimit | undefined;
}

/**
 *  Хостовая директория, смонтированная в mount namespace инстанса
 */
export interface HostMount {
   /**
    *  Расположение директории на хосте
    */
   host_path: string;
   /**
    *  Точка монтирования директории в инстансе
    */
   mount_point: string;
   /**
    *  Опция монтирования, допустимые значения: "bind", "rbind"
    */
   mount_option: string;
   /**
    *  Нужно ли монтировать в режиме read only
    */
   read_only: boolean;
}

/**
 *  Опция поведения агента, например, "монтировать ли ресурсы в режиме read-only"
 */
export interface Feature {
   /**
    *  Имя опции, например, "bind_ro_resources"
    */
   name: string;
   /**
    *  Дополнительные настройки, связанные с включением опции
    */
   properties: { [key: string]: string };
}

export interface Feature_PropertiesEntry {
   key: string;
   value: string;
}

/**
 *  Задача, она же джоб - выполняется один раз и не перезапускается. Поля те же, что и у демона
 *  https://wiki.yandex-team.ru/iss3/specifications/configuration/job/
 *  Поля копируют содержимое Instance на случай будущих изменений, если эти классы разойдутся
 */
export interface Job {
   container: Container | undefined;
   volumes: Volume[];
   resources: { [key: string]: Resourcelike };
   timeLimits: { [key: string]: TimeLimit };
   storage: string;
   project: string;
   volumeRefs: VolumeRef[];
}

export interface Job_ResourcesEntry {
   key: string;
   value: Resourcelike | undefined;
}

export interface Job_TimeLimitsEntry {
   key: string;
   value: TimeLimit | undefined;
}

/**
 *  Ограничения на время исполнения и интервал между запусками хука. Все времена в миллисекундах.
 *  maxExecutionTimeMs - ограничение на время выполнения.
 *  Интервал между запусками рассчитывается по формуле
 *  min(maxRestartPeriodMs, minRestartPeriodMs + restartPeriodScaleMs * (restartPeriodBackoff ^ step))
 *  step считается с 0
 */
export interface TimeLimit {
   restartPeriodScaleMs: number;
   restartPeriodBackOff: number;
   maxRestartPeriodMs: number;
   minRestartPeriodMs: number;
   maxExecutionTimeMs: number;
}

/**
 *  Описание контейнера, в котором запускается хук.
 *  https://wiki.yandex-team.ru/iss3/specifications/configuration/container/
 */
export interface Container {
   /**
    *  Свойства porto-контейнеров хуков, задаваемые непосредственно.
    */
   constraints: { [key: string]: string };
   /**
    *  Пытаться применять изменения в constraints без рестарта контейнера (аналогично portoctl set на запущенный контейнер)
    *  https://wiki.yandex-team.ru/iss3/specifications/configuration/container/#dinamicheskoeizmeneniesvojjstvkontejjnera
    */
   withDynamicProperties: boolean;
}

export interface Container_ConstraintsEntry {
   key: string;
   value: string;
}

/**
 *  Уникальный идентификатор задачи
 */
export interface WorkloadId {
   slot: Slot | undefined;
   /**
    *  Название конфигурации в формате <семейство>#<имя конфигурации в семействе>
    */
   configuration: ConfigurationId | undefined;
}

/**
 *  Место под сервис на хосте
 *  Если две сущности используют один слот, то только одна из них может быть активной в каждый момент времени
 */
export interface Slot {
   /**
    *  Идентификатор сервиса на хосте, например (но не обязательно), порт
    */
   service: string;
   /**
    *  FQDN хоста
    */
   host: string;
}

/**
 *  Идентификатор конфигурации - описания целевого состояния группы задач.
 */
export interface ConfigurationId {
   /**
    *  Группа, в которую входит задача - берется из GroupTransition.
    *  ConfigurationId.family в кешере
    */
   groupId: string;
   /**
    *  вариант id для meta-clusterapi
    */
   extendedGroupId: ExtendedGroupId | undefined;
   /**
    *  Идентификатор целевого состояния группы. Произвольная строка.
    *  ConfigurationId.id в кешере
    */
   groupStateFingerprint: string;
}

/**
 *  Раздел porto
 *  Подробное описание здесь https://wiki.yandex-team.ru/iss3/specifications/configuration/instance/volumes/
 */
export interface Volume {
   /**
    *  Квота на размер корневого раздела
    */
   quotaBytes: number;
   /**
    *  Квота на размер рабочей директории
    */
   quotaCwdBytes: number;
   /**
    *  точка монтирования
    */
   mountPoint: string;
   /**
    *  Сейчас определено только свойство bind
    *  https://wiki.yandex-team.ru/iss3/specifications/configuration/instance/volumes/#polzovatelskijjbind
    */
   properties: { [key: string]: string };
   /**
    *  Слои, из которых собирается корневой раздел
    */
   layers: Resource[];
   /**
    *  Указывается при создании shared-volume
    */
   uuid: string;
   /**
    *  Точка монтирования, в которой будет создан volume, будут храниться его данные и распаковываться слои.
    *  По умолчанию создается под "/", данные хранятся в стандартных директориях porto.
    */
   storage: string;
}

export interface Volume_PropertiesEntry {
   key: string;
   value: string;
}

/**
 *  Ссылка на шаред-вольюм
 */
export interface VolumeRef {
   /**
    *  идентификатор шаред-вольюма
    */
   uuid: string;
}

/**
 *  Базовый класс ресурса
 */
export interface Resourcelike {
   resource: Resource | undefined;
   dynamicResource: DynamicResource | undefined;
}

/**
 *  Обычный ресурс - набор данных
 */
export interface Resource {
   /**
    *  Уникальный идентификатор (произвольная строка)
    */
   uuid: string;
   /**
    *  Имя очереди закачки (пустое - качается без очереди)
    *  https://wiki.yandex-team.ru/iss3/specifications/agent/downloadqueues/
    */
   queue: string;
   verification: Verification | undefined;
   /**
    *  Ссылки на ресурс, например, "rbtorrent:2f83ff0f5b98b315ce356e129ce1e00d7b67ec7d", "http://cmsearch.yandex.ru/res"
    */
   urls: string[];
   /**
    *  Размер ресурса в байтах
    */
   sizeBytes: number;
   /**
    *  Является ли ресурс закешированным
    *  https://wiki.yandex-team.ru/iss3/Specifications/ShardTracker/#upravleniesvobodnymmestom
    */
   cached: boolean;
   /**
    *  Точка монтирования, в которой будет скачан ресурс (см. Instance.storage)
    */
   storage: string;
   /**
    *  Ограничение скорости закачки
    */
   trafficClass: TrafficClass | undefined;
}

/**
 *  Динамический ресурс
 *  Может обновляться без перезапуска демона, при обновлении запускается iss_hook_notify
 *  https://wiki.yandex-team.ru/iss3/specifications/configuration/resource/#dinamicheskijjresurs
 *  Поля те же, что и у ресурса
 */
export interface DynamicResource {
   uuid: string;
   queue: string;
   verification: Verification | undefined;
   urls: string[];
   sizeBytes: number;
   cached: boolean;
   storage: string;
   /**
    *  Ограничение скорости закачки
    */
   trafficClass: TrafficClass | undefined;
}

/**
 *  Проверки целостности ресурса
 */
export interface Verification {
   /**
    *  Контрольная сумма, формат <схема>:<значение> Поддерживаемые схемы "MD5:", "EMPTY:" - case sensitive
    */
   checksum: string;
   /**
    *  Периодичность проверки контрольной суммы. При значении 0d0h0m проверка будет выполнена только 1 раз.
    */
   checkPeriod: string;
}

/**
 *  Шард - данные + специальный сценарий подготовки
 *  Подробности https://wiki.yandex-team.ru/iss3/specifications/shardtracker/
 */
export interface Shard {
   /**
    *  Уникальный идентификатор шарда
    */
   shardId: string;
   /**
    *  Является ли шард закешированным (аналогично ресурсу)
    */
   cached: boolean;
   /**
    *  Ограничения на хуки шарда. Отличаются от ограничений сущности правилами распределения между хуками
    *  TODO: актуализировать после ISS-3052
    */
   container: Container | undefined;
   /**
    *  Очередь, в которой выполняются закачка, инсталляция и расшаривание (при необходимости) шарда.
    */
   queue: string;
   /**
    *  Режим дедупликации скачиваемых данных скайнетом
    */
   deduplicationMode: DeduplicationMode;
   /**
    *  Точка монтирования, в которой будет скачан и инсталлирован шард (см. Instance.storage)
    */
   storage: string;
   /**
    *  Ограничение скорости закачки
    */
   trafficClass: TrafficClass | undefined;
}

export interface TrafficClass {
   downloadSpeedLimit: number;
   trafficTag: string;
}

/**
 *  Текущее состояние сущности
 */
export interface DetailedCurrentState {
   workloadId: WorkloadId | undefined;
   /**
    *  Строковое описание состояния, может принимать произвольные значения, в том числе весь список целевых состояний
    */
   currentState: string;
   feedback: CurrentStateFeedback | undefined;
   /**
    *  Момент отправки сообщения с агента
    */
   hostTimestamp: number;
   /**
    *  Момент сохранения сообщения сервером
    */
   serverTimestamp: number;
   /**
    *  Enum состояниe
    */
   masterState: MasterState;
   /**
    *  Внутренние поля iss для использования в веб-интерфейсе
    */
   targetState: string;
   instanceType: InstanceType;
   entityDir: string;
   /**
    *  Nanny HQ revision status
    */
   revisionStatus: RevisionStatus | undefined;
}

export interface CurrentStateFeedback {
   /**
    *  Поле для служебных сообщений в случае проблем с сохранением (например, слишком большое сообщение)
    */
   specialMessage: string;
   /**
    *  porto-метрики
    */
   metrics: FeedbackMessage[];
   /**
    *  сообщения о незавершенных операциях
    */
   pendingStateMessages: FeedbackMessage[];
   info: FeedbackMessage[];
   warnings: FeedbackMessage[];
   failures: FeedbackMessage[];
   /**
    *  --- состояние в обратной связи (ISS-3228) ---
    *  Счетчики метаконтейнера
    */
   counters: { [key: string]: string };
   /**
    *  Состояния хуков
    */
   hooks: HooksState | undefined;
   /**
    *  Состояния ресурсов.
    */
   resources: ResourceState[];
   /**
    *  Момент когда мы получили конфигурацию в первый раз
    */
   configurationReceivedTimestamp: number;
}

export interface CurrentStateFeedback_CountersEntry {
   key: string;
   value: string;
}

/**
 *  Отдельное сообщение обратной связи от агента
 */
export interface FeedbackMessage {
   countersFeedback: CountersFeedback | undefined;
   feedbackMergeMessage: FeedbackMergeMessage | undefined;
   feedbackOkMessage: FeedbackOkMessage | undefined;
   progress: Progress | undefined;
   lock: Lock | undefined;
   processFeedback: ProcessFeedback | undefined;
   selfHelp: SelfHelp | undefined;
   checksumVerificationFailure: ChecksumVerificationFailure | undefined;
   checksumProgress: ChecksumProgress | undefined;
   daemonFailure: DaemonFailure | undefined;
   downloadFailed: DownloadFailed | undefined;
   resourcesNotReady: ResourcesNotReady | undefined;
   validationFailed: ValidationFailed | undefined;
   directoryFailure: DirectoryFailure | undefined;
   cachedResourceNotRemoved: CachedResourceNotRemoved | undefined;
   waitingForFreeSpace: WaitingForFreeSpace | undefined;
   hookFailure: HookFailure | undefined;
   countLimit: CountLimit | undefined;
   frequencyLimit: FrequencyLimit | undefined;
   pendingRemove: PendingDriverRemove | undefined;
   timeLimitViolation: TimeLimitViolation | undefined;
   shardFailure: ShardFailure | undefined;
   failMessage: FeedbackFailMessage | undefined;
   hookInProgress: HookInProgress | undefined;
   networkNotReady: NetworkNotReady | undefined;
   portoValueHookFailure: PortoValueHookFailure | undefined;
   hookConstraintsFailure: HookConstraintsFailure | undefined;
   downloadFinished: DownloadFinished | undefined;
   portoValueDaemonFailure: PortoRelatedDaemonFailure | undefined;
}

/**
 *  Базовое сообщение для всех поломок
 */
export interface FeedbackFailMessage {
   /**
    *  Тип проблемы, например, HOOK_FAILED
    */
   state: string;
   /**
    *  Подробное описание
    */
   failReason: string;
}

export interface PortoValueHookFailure {
   hook: string;
   state: string;
   property: string;
   value: string;
   portoMessage: string;
}

export interface PortoRelatedDaemonFailure {
   state: string;
   failReason: string;
   property: string;
   value: string;
   portoMessage: string;
}

export interface HookConstraintsFailure {
   hook: string;
   state: string;
   property: string;
   value: string;
   portoMessage: string;
}

/**
 *  Хук в процессе выполнения
 */
export interface HookInProgress {
   state: string;
   /**
    *  Имя хука
    */
   hook: string;
   /**
    *  true сразу после запуска агента, false если агент рапортует об уже работающем хуке
    */
   justCreated: boolean;
}

/**
 *  Ip-адрес ещё не готов (не прописан в фаерволле)
 */
export interface NetworkNotReady {
   state: string;
   ip: string;
   /**
    *  дополнительное описание причины
    */
   message: string;
}

/**
 *  Счетчики от порто
 */
export interface CountersFeedback {
   state: string;
   counters: { [key: string]: string };
   timestamp: number;
   container: string;
}

export interface CountersFeedback_CountersEntry {
   key: string;
   value: string;
}

/**
 *  Информация о слиянии в агенте данных, полученных из разных кешеров
 */
export interface FeedbackMergeMessage {
   state: string;
}

export interface FeedbackOkMessage {
   state: string;
}

/**
 *  Идет скачивание данных
 */
export interface Progress {
   /**
    *  Ссылка, по которой качается
    */
   from: string;
   /**
    *  Целевая директория
    */
   to: string;
   bytesDone: number;
   bytesTotal: number;
   state: string;
   localname: string;
}

export interface DownloadFinished {
   /**
    *  Ссылка, по которой качается
    */
   from: string;
   /**
    *  Целевая директория
    */
   to: string;
   bytesDone: number;
   bytesTotal: number;
   state: string;
   localname: string;
}

/**
 *  Операция не смогла взять блокировку (например, для очереди закачки)
 */
export interface Lock {
   state: string;
   /**
    *  Имя блокировки
    */
   lock: string;
   /**
    *  Текущий владелец блокировки
    */
   lockedBy: string;
   /**
    *  Драйвер, который заблокировался
    */
   requestedBy: string;
}

/**
 *  Завершение процесса
 */
export interface ProcessFeedback {
   /**
    *  DAEMON_EXITED - старт-хук демона завершился с кодом 0
    *  DAEMON_WAS_TERMINATED_EXTERNALLY - старт-хук демона завершился с кодом не-0
    *  HOOK_CANCELLED - хук/задачу убили 9-кой
    *  HOOK_FAILED - хук/задача завершились самостоятельно с кодом 1-31
    *  HOOK_SEMI_FAILED - хук упал с кодом 32-63
    *  HOOK_EXITED - хук/задача завершились с кодом 0
    *  Подробности про коды https://wiki.yandex-team.ru/iss3/specifications/configuration/instance/#naznacheniexukov
    */
   state: string;
   /**
    *  Имя завершившегося хука
    */
   executableName: string;
   /**
    *  Код завершения процесса
    */
   exitCode: number;
   /**
    *  Номер сигнала, по которому завершился процесс.
    *  Темная магия агента старается обработать случай, когда процесс является шеллом
    *  и сигнализирует о завершении дочернего процесса по сигналу согласно http://www.tldp.org/LDP/abs/html/exitcodes.html
    */
   signalNumber: number;
   /**
    *  Был ли процесс завершен из-за нехватки памяти
    */
   outOfMemory: boolean;
}

/**
 *  Отладочное сообщение
 */
export interface SelfHelp {
   cause: string;
   /**
    *  Ссылка на ресурс, послуживший причиной
    */
   url: string;
   /**
    *  Локальное имя файла
    */
   localName: string;
   /**
    *  Затронутые сущности
    */
   affected: string[];
   customLines: string;
   state: string;
}

/**
 *  Контрольная сумма ресурса не совпала с ожидаемой
 */
export interface ChecksumVerificationFailure {
   state: string;
   expected: string;
   calculated: string;
   targetFile: string;
}

/**
 *  Идет вычисление контрольной суммы
 */
export interface ChecksumProgress {
   state: string;
   targetFile: string;
}

/**
 *  Прочие проблемы со старт-хуком
 */
export interface DaemonFailure {
   state: string;
   failReason: string;
   hook: string;
}

/**
 *  Скачивание ресурса завершилось с ошибкой
 */
export interface DownloadFailed {
   state: string;
   failReason: string;
   /**
    *  Ссылка на ресурс
    */
   from: string;
   /**
    *  Путь к результату скачивания
    */
   to: string;
}

/**
 *  Ресурсы сущности не готовы
 */
export interface ResourcesNotReady {
   state: string;
   /**
    *  <имя не готового ресурса> -> <текущее состояние>
    */
   states: { [key: string]: string };
   failReason: string;
}

export interface ResourcesNotReady_StatesEntry {
   key: string;
   value: string;
}

/**
 *  Не удалось проверить контрольную сумму ресурса
 */
export interface ValidationFailed {
   state: string;
   failReason: string;
   /**
    *  Отсутствующий файл ресурса
    */
   missingFile: string;
   /**
    *  Директория, в которой должен находиться файл
    */
   targetDir: string;
   /**
    *  Ссылка на ресурс
    */
   from: string;
   /**
    *  Путь к результату скачивания
    */
   to: string;
}

/**
 *  Ошибка в агенте при работе с директориями
 */
export interface DirectoryFailure {
   state: string;
   failReason: string;
   directory: string;
}

/**
 *  Ресурс не удален, т.к. выставлено свойство cached = true
 */
export interface CachedResourceNotRemoved {
   state: string;
   /**
    *  Свободное место в байтах
    */
   availableBytes: number;
   /**
    *  Нижняя граница свободного места в байтах
    */
   spaceToLeaveOnDiskBytes: number;
   /**
    *  Драйвер, владеющий резервацией
    */
   reserver: string;
}

/**
 *  Ресурс ожидает свободного места на диске
 */
export interface WaitingForFreeSpace {
   state: string;
   /**
    *  Драйвер, запрашивающий резервацию
    */
   reserver: string;
   /**
    *  Запрашиваемое место в байтах
    */
   requiredBytes: number;
   /**
    *  Уже занятое место в байтах (например, ресурс частично скачался, потом агент перезапустился)
    */
   consumedBytes: number;
   /**
    *  Размер дискового раздела в байтах
    */
   totalBytes: number;
   /**
    *  Доступное место в байтах
    */
   availableBytes: number;
   /**
    *  Нижняя граница свободного места в байтах
    */
   spaceToLeaveOnDiskBytes: number;
}

/**
 *  Ошибка операции над хуком (например, не найден файл хука, потерялся контейнер)
 */
export interface HookFailure {
   state: string;
   /**
    *  Имя хука
    */
   hook: string;
}

/**
 *  Внутренняя логика - нарушено ограничение на число повторений операции
 */
export interface CountLimit {
   state: string;
   /**
    *  Разрешенное число повторений
    */
   maxAttempts: number;
   /**
    *  Текущее число повторений
    */
   attempts: number;
}

/**
 *  Внутренняя логика - нарушено ограничение на частоту запуска операции
 */
export interface FrequencyLimit {
   state: string;
   /**
    *  Время последнего запуска
    */
   lastRun: string;
   /**
    *  Время возникновения ошибки
    */
   now: string;
   /**
    *  Разрешенный интервал между запусками
    */
   invocationGap: string;
}

/**
 *  Драйвер не может быть удален, так как на него еще есть ссылки
 */
export interface PendingDriverRemove {
   state: string;
   /**
    *  Удаляемый драйвер
    */
   id: string;
   /**
    *  Удаляющий драйвер
    */
   requesterId: string;
   /**
    *  Класс удаляемого драйвера
    */
   clazz: string;
   /**
    *  Строковое описание удаляемого драйвера
    */
   payload: string;
}

/**
 *  Внутренняя логика - нарушено ограничение на время выполнения операции
 */
export interface TimeLimitViolation {
   state: string;
   /**
    *  Время запуска
    */
   firstRun: string;
   /**
    *  Ограничение на время выполнения
    */
   duration: string;
   /**
    *  Время, прошедшее с момента запуска
    */
   durationFromFirstRun: string;
}

/**
 *  Ошибка при подготовке шарда
 */
export interface ShardFailure {
   state: string;
   failReason: string;
   shardId: string;
}

/**
 *  Состояние хуков
 */
export interface HooksState {
   /**
    *  Когда произошло последнее событие
    */
   updateTimestamp: number;
   /**
    *  Агрегированные данные про каждый хук.
    */
   finished: FinishedHookExecutions[];
   /**
    *  Данные о текущих запущенных хуках.
    */
   inProgress: HookInProcess[];
   /**
    *  Список истории выполняемых хуков. Хранится последние N запусков хуков, но не более чем 1 для каждого хука. Нужно для восстановления порядка.
    */
   history: HookHistoryEntry[];
   /**
    *  Операции над свойствами запущенных контейнеров хуков
    */
   events: HookContainerEvents[];
}

/**
 *  Агрегированая информация о предыдущих результатах работы хука
 */
export interface FinishedHookExecutions {
   name: HookName;
   executions: FinishedProcessExecutions | undefined;
}

export interface HookContainerEvents {
   name: HookName;
   events: ContainerEvent[];
}

/**
 *  Прогресс выполнения хука
 */
export interface HookInProcess {
   name: HookName;
   progress: ProcessProgress | undefined;
}

/**
 *  Запись истории выполнения хуков
 */
export interface HookHistoryEntry {
   /**
    *  Когда произошло событие
    */
   eventTimestamp: number;
   /**
    *  Какой хук запускался
    */
   hookName: HookName;
   /**
    *  Выполняется ли хук сейчас
    */
   inProgress: boolean;
   /**
    *  Успешно ли завершился
    */
   isSuccessful: boolean;
}

export interface ContainerEvent {
   name: ContainerEventName;
   description: string;
   timestamp: number;
}

export interface ResourceState {
   /**
    *  имя ресурса из конфигурации
    */
   id: string;
   /**
    * Текущий url. Может меняеться
    */
   url: string;
   name: string;
   /**
    *  Когда произошло последнее событие
    */
   updateTimestamp: number;
   /**
    *  готов ли ресурс
    */
   prepared: boolean;
   /**
    *  Завершенные стадии подготовки ресурса. Хранится информация о всех стадиях.
    */
   finishedStages: FinishedPrepareStage[];
   /**
    *  Стадия подготовки в процессе.
    */
   inProgressStage: ResourcePrepareStageInProgress | undefined;
   /**
    *  история запуска стадий
    */
   history: ResourcePrepareStageHistoryEntry[];
}

/**
 *  Агрегированное состояние выполненных стадий
 */
export interface FinishedPrepareStage {
   /**
    *  Имя стадии
    */
   stage: ResourcePrepareStageName;
   /**
    *  Человекочитаемая причина неудачного выполнения. Возможно, в будущем, стоит заменить на код ошибки
    */
   failReason: string;
   /**
    *  Счётчик успешных выполнений стадии: хуки + без хуков
    */
   successCount: number;
   /**
    *  Счётчик провалов стадии: хуки (общий счётчик провалов) + без хуков
    */
   failuresCount: number;
   /**
    *  Данные по завершенным запускам хуков
    */
   executions: FinishedProcessExecutions | undefined;
   /**
    *  Размер ресурса в байтах на момент успешного завершения скачивания. -1, если не применимо.
    */
   bytesTotal: number;
   /**
    *  Число скачaнных байт ресурса на момент успешного завершения скачивания. -1, если неприменимо.
    *  В идеальном мире пони и единорогов число скачанных байт и общее число байт должны совпадать.
    */
   bytesDone: number;
}

export interface ResourcePrepareStageInProgress {
   /**
    *  Какая идет стадия
    */
   stage: ResourcePrepareStageName;
   /**
    *  Когда произошло последнее событие
    */
   updateTimestamp: number;
   /**
    *  Время начала
    */
   startTimestamp: number;
   /**
    *  Размер ресурса в байтах. -1, если не применимо.
    */
   bytesTotal: number;
   /**
    *  Число скачанных байт ресурса. -1, если не применимо.
    */
   bytesDone: number;
   /**
    *  Данные о выполнении связанного процесса - sky run, инсталляция и т.д.
    */
   process: ProcessProgress | undefined;
}

/**
 *  Запись истории о текущих или завершенных стадиях подготовки ресурса
 */
export interface ResourcePrepareStageHistoryEntry {
   /**
    *  Когда произошло событие
    */
   eventTimestamp: number;
   /**
    *  Какая стадия запускалась
    */
   stage: ResourcePrepareStageName;
   /**
    *  Человекочитаемая причина неудачного выполнения. Возможно, в будущем, стоит заменить на код ошибки
    */
   failReason: string;
   /**
    *  В прогрессе ли хук сейчас
    */
   inProgress: boolean;
   /**
    *  true если стадия прошла успешно
    */
   success: boolean;
   /**
    *  Размер ресурса в байтах. -1, если не применимо.
    */
   bytesTotal: number;
   /**
    *  Число скачанных байт ресурса. -1, если не применимо.
    */
   bytesDone: number;
}

export interface FinishedProcessExecutions {
   /**
    *  история последних выполнений процесса. Содержит последние N записей.
    */
   history: ProcessExecutionResult[];
   /**
    *  Сколько раз выполнялся.
    */
   executionsCount: number;
   /**
    *  Сколько раз провалился = сумма всех причин падений
    */
   failuresCount: number;
   /**
    *  Сколько раз вернул ненулевой код возврата
    */
   nonZeroRetcodesCount: number;
   /**
    *  Сколько раз падал из-за OOM.
    */
   outOfMemoryCount: number;
   /**
    *  Сколько раз падал из-за превышения таймаута
    */
   timeoutsCount: number;
   /**
    *  Сколько раз падал из-за того, что его убили извне
    */
   externalKillsCount: number;
   /**
    *  Сколько раз падал из-за ошибки порто, агента и т.п.
    */
   systemFailuresCount: number;
   /**
    * флаг невозможности запуска хука из за его отсутствия
    */
   hookNotExistsCount: number;
}

/**
 *  Описание результата выполнения процесса. Используется для описания хуков, запусков закачки и т.п.
 */
export interface ProcessExecutionResult {
   /**
    *  Когда процесс завершился
    */
   finishTimestamp: number;
   /**
    *  Результат выполнения.
    */
   exitCode: number;
   /**
    *  Cчетчики порто
    */
   counters: { [key: string]: string };
   /**
    *  Номер сигнала, по которому завершился процесс.
    *  Темная магия агента старается обработать случай, когда процесс является шеллом
    *  и сигнализирует о завершении дочернего процесса по сигналу согласно http://www.tldp.org/LDP/abs/html/exitcodes.html
    *  если сигнала не было - 0
    */
   signalNumber: number;
   /**
    *  Как завершился процесс
    */
   result: ProcessExecutionResultName;
   /**
    *  Текстовое описание результата. Содержит текстовое представление result и опционально дополнительную информацию (например текст ошибки porto).
    */
   description: string;
}

export interface ProcessExecutionResult_CountersEntry {
   key: string;
   value: string;
}

/**
 *  Данные о прогрессе выполнения процесса. Используется для описания прогресса хуков, программ-закачки и т.п.
 */
export interface ProcessProgress {
   /**
    *  Когда произошло последнее событие
    */
   updateTimestamp: number;
   /**
    *  Время начала
    */
   startTimestamp: number;
   /**
    *  Текущие счетчики порто
    */
   counters: { [key: string]: string };
}

export interface ProcessProgress_CountersEntry {
   key: string;
   value: string;
}

export interface QueueControl {
   blockedDownload: boolean;
}

export interface ToAgent {
   keepAlive: KeepAlive | undefined;
   hostConfiguration: HostConfiguration | undefined;
}

export interface ToServer {
   handshake: AgentHandshake | undefined;
   keepAlive: KeepAlive | undefined;
   currentState: DetailedCurrentState | undefined;
}

/**
 *  Целевое состояние хоста и агента
 */
export interface HostConfiguration {
   instances: HostConfigurationInstance[];
   pod_volumes: Volume[];
}

/**
 *  Обертка для job/instance
 */
export interface HostConfigurationInstance {
   id: WorkloadId | undefined;
   entity: Entity | undefined;
   /**
    *  Пользовательские свойства
    *  Пробрасываются хукам через переменные среды
    */
   properties: { [key: string]: string };
   /**
    *  Целевое состояние - одно из "ACTIVE", "PREPARED", "REMOVED"
    */
   targetState: string;
   /**
    *  Момент задания целевого состояния в формате UNIX timestamp
    */
   transitionTimestamp: number;
   /**
    *  Свойства, изменения которых не приводят к перезапуску. ISS-4434
    *  Не должны пересекаться по ключам c properties
    */
   dynamicProperties: { [key: string]: string };
   instanceRevision: InstanceRevision | undefined;
}

export interface HostConfigurationInstance_PropertiesEntry {
   key: string;
   value: string;
}

export interface HostConfigurationInstance_DynamicPropertiesEntry {
   key: string;
   value: string;
}

/**
 *  Сообщение, отправляемое агентом при установлении соединения
 */
export interface AgentHandshake {
   fqdn: string;
}

/**
 *  Сообщение для поддержания живости соединения
 */
export interface KeepAlive {}

/**
 *  Текущее состояние хоста. Сообщение используется только в grpc.
 */
export interface HostCurrentState {
   currentStates: DetailedCurrentState[];
}
