/* eslint-disable */

export enum EConditionStatus {
   CS_UNKNOWN = 'unknown',
   CS_TRUE = 'true',
   CS_FALSE = 'false',
}

export interface TCondition {
   /**
    *  True, False, Unknown
    */
   status: EConditionStatus;
   /**
    *  One word (e.g. PROCESS_CRASH) for computers and short summary
    */
   reason: string;
   /**
    *  Some human readable message
    */
   message: string;
   last_transition_time: Date | { nanos: number; seconds: number } | undefined;
}

export interface TAggregatedCondition {
   /**
    *  Number of pods for which condition is true
    */
   pod_count: number;
   condition: TCondition | undefined;
}
