/* eslint-disable */
import { Any } from '../../../../../google/protobuf/any';
import { Duration } from '../../../../../google/protobuf/duration';
import { TAttributeDictionary } from '../../../../../yt_proto/yt/core/ytree/proto/attributes';
import {
   TAddDeployChild,
   TRemoveDeployChild,
   TAddSecretDelegation,
   TRemoveSecretDelegation,
} from '../../../../../yp_proto/yp/client/api/proto/deploy_control';
import {
   EResourceKind,
   EPodHostNameKind,
   EPodOutOfMemoryPolicy,
   ESchedulingState,
   ECpuSetJail,
} from '../../../../../yp_proto/yp/client/api/proto/enums';
import { HostConfiguration, HostCurrentState } from '../../../../../yp_proto/yp/client/api/proto/cluster_api';
import { THostInfraInfo } from '../../../../../yp_proto/yp/client/api/proto/host_infra';
import { TSidecarVolume } from '../../../../../yp_proto/yp/client/api/proto/sidecar_volume';
import {
   TPodAgentSpec,
   TPodAgentResourceCacheSpec,
   TPodAgentStatus,
} from '../../../../../yp_proto/yp/client/api/proto/pod_agent';
import { TCondition } from '../../../../../yp_proto/yp/client/api/proto/conditions';
import { TDynamicAttributes } from '../../../../../yp_proto/yp/client/api/proto/dynamic_attributes';
import { TError } from '../../../../../yt_proto/yt/core/misc/proto/error';
import { Condition } from '../../../../../yp_proto/yp/client/hq/proto/types';

/**
 * HS_SUSPECTED -  COMPAT(bidzilya): deprecated, use /node/status/alerts instead.
 *
 */
export enum EHfsmState {
   HS_UNKNOWN = 'unknown',
   HS_INITIAL = 'initial',
   HS_UP = 'up',
   HS_DOWN = 'down',
   HS_SUSPECTED = 'suspected',
   HS_PREPARE_MAINTENANCE = 'prepare_maintenance',
   HS_MAINTENANCE = 'maintenance',
   HS_PROBATION = 'probation',
}

export enum ENodeMaintenanceState {
   NMS_NONE = 'none',
   NMS_REQUESTED = 'requested',
   NMS_ACKNOWLEDGED = 'acknowledged',
   NMS_IN_PROGRESS = 'in_progress',
}

export enum EPodMaintenanceState {
   PMS_NONE = 'none',
   PMS_REQUESTED = 'requested',
   PMS_ACKNOWLEDGED = 'acknowledged',
   PMS_IN_PROGRESS = 'in_progress',
}

/**
 * MK_PREPARE -  adding host to cluster
 *
 * MK_DEACTIVATE -  removing host from cluster
 *
 */
export enum EMaintenanceKind {
   MK_NONE = 'none',
   MK_POWER_OFF = 'power-off',
   MK_REBOOT = 'reboot',
   MK_PROFILE = 'profile',
   MK_REDEPLOY = 'redeploy',
   MK_REPAIR_LINK = 'repair-link',
   MK_CHANGE_DISK = 'change-disk',
   MK_TEMPORARY_UNREACHABLE = 'temporary-unreachable',
   MK_PREPARE = 'prepare',
   MK_DEACTIVATE = 'deactivate',
}

export enum EMaintenancePriority {
   MP_NONE = 'none',
   MP_HIGH = 'high',
   MP_NORMAL = 'normal',
}

export enum EMaintenanceSource {
   MS_NONE = 'none',
   MS_MANUAL = 'manual',
   MS_AUTOHEALING = 'autohealing',
}

export enum EDiskVolumePolicy {
   DVP_QUOTA = 'quota',
   DVP_EXCLUSIVE = 'exclusive',
}

/**
 *  It is assumed that GPU device is just a generic PCIe device, it may operate
 *  in various mutably exclusive modes.
 *  See https://doc.yandex-team.ru/nvgpu_manager/design.html
 * GM_NONE -  Default, will be forbidden soon.
 *
 * GM_NVIDIA -  Device is controlled by dom0 nvidia driver and it can be used by host system.
 *  Device is visible for host tools such as nvidia-smi, nvml, etc.
 *
 * GM_VFIO -  Device is unbounded from host system, and controlled by vfio-pci kernel driver
 *  (see https://www.kernel.org/doc/Documentation/vfio.txt). This mode allows us
 *  to bind given PCIe device to KVM/qemu. In this case host system can not use
 *  GPU device, and device is invisible for host tools.
 *
 */
export enum EGpuMode {
   GM_NONE = 'none',
   GM_NVIDIA = 'nvidia',
   GM_VFIO = 'vfio',
}

/**
 * PCS_START_FAILED -  Pod could not be started (for example, the received spec was invalid).
 *
 */
export enum EPodCurrentState {
   PCS_UNKNOWN = 'unknown',
   PCS_START_PENDING = 'start_pending',
   PCS_STARTED = 'started',
   PCS_STOP_PENDING = 'stop_pending',
   PCS_STOPPED = 'stopped',
   PCS_START_FAILED = 'start_failed',
}

export enum EPodTargetState {
   PTS_UNKNOWN = 'unknown',
   PTS_REMOVED = 'removed',
   PTS_ACTIVE = 'active',
}

export enum EEvictionState {
   ES_NONE = 'none',
   ES_REQUESTED = 'requested',
   ES_ACKNOWLEDGED = 'acknowledged',
}

export enum EEvictionReason {
   ER_NONE = 'none',
   ER_HFSM = 'hfsm',
   ER_SCHEDULER = 'scheduler',
   ER_CLIENT = 'client',
   ER_HEALER = 'healer',
}

/**
 * DW_SUNDAY -  Numeric value for Sunday is chosen to be 0 instead of 7 for the sake of
 *  compatibility with C/C++ libraries such as std::chrono and ctime.
 *
 */
export enum EDayOfWeek {
   DW_SUNDAY = 'sunday',
   DW_MONDAY = 'monday',
   DW_TUESDAY = 'tuesday',
   DW_WEDNESDAY = 'wednesday',
   DW_THURSDAY = 'thursday',
   DW_FRIDAY = 'friday',
   DW_SATURDAY = 'saturday',
}

export interface TAntiaffinityConstraint {
   /**
    *  Topology zone key.
    *  Node zones are specified via /node/labels/topology/key=value labels.
    *  and are filled on node's import.
    *  Supported zone keys are: node, rack, dc.
    */
   key: string;
   /**
    *  Maximum number of pods that can be placed in the same zone.
    */
   max_pods: number;
   /**
    *  If given, the constraint is independently applied to each group of pods with equal
    *  group id at which this path points.
    *
    *  Path must be of the form /labels/<key>, where <key> represents a single path token.
    *  Otherwise scheduling will fail for the pod set with appropriate error.
    *
    *  A pod is not required to have specified group id. If group id is missing,
    *  the pod will not be affected by the constraint.
    *
    *  If pod group id is specified, it must be of the string type.
    *  Otherwise scheduling will fail for the pod with appropriate error.
    *
    *  Example: pod_group_id_path = "/labels/antiaffinity_group_id" and /pod/labels/antiaffinity_group_id = "42".
    */
   pod_group_id_path: string;
}

export interface TPerSegmentResourceTotals {
   memory: TPerSegmentResourceTotals_TMemoryTotals | undefined;
   cpu: TPerSegmentResourceTotals_TCpuTotals | undefined;
   disk_per_storage_class: { [key: string]: TPerSegmentResourceTotals_TDiskTotals };
   internet_address: TPerSegmentResourceTotals_TInternetAddressTotals | undefined;
   gpu_per_model: { [key: string]: TPerSegmentResourceTotals_TGpuTotals };
   network: TPerSegmentResourceTotals_TNetworkTotals | undefined;
}

export interface TPerSegmentResourceTotals_TMemoryTotals {
   /**
    *  In bytes.
    */
   capacity: number;
}

export interface TPerSegmentResourceTotals_TCpuTotals {
   /**
    *  In virtual millicores.
    */
   capacity: number;
}

export interface TPerSegmentResourceTotals_TNetworkTotals {
   /**
    *  In bytes per second.
    */
   bandwidth: number;
}

export interface TPerSegmentResourceTotals_TDiskTotals {
   /**
    *  In bytes.
    */
   capacity: number;
   /**
    *  In bytes per second.
    */
   bandwidth: number;
}

export interface TPerSegmentResourceTotals_TGpuTotals {
   /**
    *  In GPUs.
    */
   capacity: number;
}

export interface TPerSegmentResourceTotals_TInternetAddressTotals {
   capacity: number;
}

export interface TPerSegmentResourceTotals_DiskPerStorageClassEntry {
   key: string;
   value: TPerSegmentResourceTotals_TDiskTotals | undefined;
}

export interface TPerSegmentResourceTotals_GpuPerModelEntry {
   key: string;
   value: TPerSegmentResourceTotals_TGpuTotals | undefined;
}

export interface TResourceTotals {
   per_segment: { [key: string]: TPerSegmentResourceTotals };
}

export interface TResourceTotals_PerSegmentEntry {
   key: string;
   value: TPerSegmentResourceTotals | undefined;
}

/**
 *  Reference to a secret from another object.
 */
export interface TSecretRef {
   /**
    *  Object id of the secret (equals its vault id).
    */
   secret_id: string;
   /**
    *  Version to retrieve. If empty, retrieve the latest version.
    */
   secret_version: string;
}

export interface TAlertToleration {
   /**
    *  Corresponds to type of the node alert one wants to ignore.
    */
   type: string;
   /**
    *  Corresponds to effect of the node alert.
    *  In order for scheduler to ignore a node alert, both "key" and "effect"
    *  of respective toleration should coincide with those specified in the alert.
    *  If "effect" is not specified, scheduler will ignore all node alerts with
    *  a given type.
    */
   effect: string;
}

export interface TNodeSpec {
   /**
    *  MTN subnets.
    */
   ip6_subnets: TNodeSpec_TIP6Subnet[];
   /**
    *  Host (dom0) IP6 addresses.
    */
   ip6_addresses: TNodeSpec_TIP6Address[];
   /**
    *  Used to construct /pod/status/transient_fqdn.
    *  Typically this is the first part of the node's FQDN, i.e.
    *  "sas1-3329" for "sas1-3329.search.yandex.net".
    */
   short_name: string;
   /**
    *  HFSM controls.
    */
   hfsm: TNodeSpec_THfsm | undefined;
   /**
    *  NOC module in "physical" network topology.
    *  Deprecated in favor of ip4_address_pools YP-1828 YP-2195
    */
   network_module_id: string;
   /**
    *  If true then YP Master instructs node agents to drop all unknown pods.
    */
   force_remove_unknown_pods: boolean;
   /**
    *  If true then YP Master instructs node agents to drop all unknown persistent volumes.
    */
   force_remove_unknown_persistent_volumes: boolean;
   /**
    *  Currently this is an opaque data; cf. YP-809.
    */
   host_manager: Any | undefined;
   agent_config: TNodeSpec_TNodeAgentConfig | undefined;
   scheduling: TNodeSpec_TNodeScheduling | undefined;
}

export interface TNodeSpec_TIP6Subnet {
   /**
    *  IP6 /64-subnet, in textual form.
    */
   subnet: string;
   /**
    *  E.g. backbone or fastbone.
    */
   vlan_id: string;
}

export interface TNodeSpec_TIP6Address {
   /**
    *  IP6 address, in textual form.
    */
   address: string;
   /**
    *  E.g. backbone or fastbone.
    */
   vlan_id: string;
}

export interface TNodeSpec_THfsm {
   /**
    *  Setting this to false prevents automatic HFSM status updates.
    */
   enable_sync: boolean;
}

/**
 *  Parameters to be delivered to the agent running on this node (overrides global parameters
 *  in master config).
 */
export interface TNodeSpec_TNodeAgentConfig {
   /**
    *  Agent should not send heartbeats with interval shorter than this many milliseconds.
    */
   heartbeat_throttler_period: number;
   /**
    *  Agent should trigger hearbeats with interval of this many milliseconds.
    */
   regular_heartbeat_period: number;
}

/**
 *  Scheduling parameters of this node.
 */
export interface TNodeSpec_TNodeScheduling {
   /**
    *  Values: disabled, best_effort, guaranteed.
    *  Disabled by default.
    */
   numa_allocation_mode: string;
}

export interface TMaintenanceInfo {
   /**
    *  Randomly generated globally unique identifier.
    */
   uuid: string;
   /**
    *  User-defined identifier.
    *  Will be randomly generated if not provided.
    */
   id: string;
   /**
    *  Identifies maintenance type. Can be considered as urgency on the project's terms.
    */
   kind: EMaintenanceKind;
   /**
    *  Node set identifier, e.g. "switch-iva5-s32", which allows to group maintenances.
    */
   node_set_id: string;
   /**
    *  Human-readable description.
    */
   message: string;
   /**
    *  Indicates whether this maintenance can corrupt data.
    */
   disruptive: boolean;
   /**
    *  Estimated duration.
    */
   estimated_duration: Duration | undefined;
   /**
    *  Dynamically typed description.
    */
   labels: TAttributeDictionary | undefined;
   /**
    *  Priority.
    */
   priority: EMaintenancePriority;
   /**
    *  Maintenance source, e.g. manual operation vs autohealing
    */
   source: EMaintenanceSource;
}

export interface TNodeAlert {
   /**
    *  Arbitrary type. It is supposed to be used for grouping and selection.
    *  For example, "agent-heartbeat-timeout".
    */
   type: string;
   /**
    *  Globally-unique identifier generated by master.
    */
   uuid: string;
   /**
    *  Creation time.
    */
   creation_time: Date | { nanos: number; seconds: number } | undefined;
   /**
    *  Human-readable description.
    */
   description: string;
   /**
    *  Dynamically typed description.
    */
   labels: TAttributeDictionary | undefined;
   /**
    *  Supported effects:
    *      no_schedule (default) - light scheduler will not schedule pods without appropriate toleration
    *          on a node with such alert. However, if a pod is already scheduled on a node
    *          with such alert, it will not be evicted.
    *      no_execute - the same as no_schedule in terms of light scheduler, but heavy
    *          scheduler will request eviction for all pods without appropriate toleration
    *          scheduled on a node with such alert.
    */
   effect: string;
}

export interface TNodeStatus {
   /**
    *  Current epoch used for master-agent communication.
    */
   epoch_id: string;
   /**
    *  Timestamp of the last agent heartbeat.
    */
   last_seen_time: number;
   /**
    *  Timestamp of the last agent handshake.
    */
   last_handshake_time: number;
   /**
    *  Master address of the last agent handshake.
    */
   last_handshake_master_address: string;
   /**
    *  Used for properly sequencing master-agent communication.
    */
   heartbeat_sequence_number: number;
   /**
    *  Address of GPRC service at agent used for out-of-band notifications.
    */
   agent_address: string;
   /**
    *  Version of the agent running at this node (as reported during the last handshake).
    */
   agent_version: string;
   /**
    *  HFSM info.
    */
   hfsm: TNodeStatus_THfsm | undefined;
   /**
    *  Maintenance workflow.
    */
   maintenance: TNodeStatus_TMaintenance | undefined;
   /**
    *  Each alert indicates that node in some unxpected state.
    *  For example, it has no heartbeats for more than N minutes.
    *  Scheduler will not assign pod on node with an active alert.
    */
   alerts: TNodeAlert[];
   /**
    *  Contains ids of pods that are reported to be present at the node
    *  but are neither known to exist nor were recently removed.
    */
   unknown_pod_ids: string[];
   /**
    *  Contains ids of persistent volumes that are reported to be present at the disks
    *  attached to the node but are neither known to exist nor were recently removed.
    */
   unknown_persistent_volume_ids: string[];
   /**
    *  Currently this is an opaque data; cf. YP-809.
    */
   host_manager: Any | undefined;
   /**
    *  Ids of pods assigned to this node.
    */
   pod_ids: string[];
}

export interface TNodeStatus_THfsm {
   /**
    *  Current HFSM state.
    */
   state: EHfsmState;
   /**
    *  Timestamp of last change.
    */
   last_updated: number;
   /**
    *  Comment for the last change.
    */
   message: string;
}

export interface TNodeStatus_TMaintenance {
   /**
    *  Current maintenance state.
    */
   state: ENodeMaintenanceState;
   /**
    *  Timestamp of the last change.
    */
   last_updated: number;
   /**
    *  Comment about last maintenance state transition.
    */
   message: string;
   /**
    *  Comment about maintenance status within one state.
    */
   status_message: string;
   /**
    *  Describes the maintenance.
    */
   info: TMaintenanceInfo | undefined;
}

export interface TNodeControl {
   /**
    *  TODO(deep): extract nested messages and convert to ControlBase
    */
   add_deploy_child: TAddDeployChild | undefined;
   remove_deploy_child: TRemoveDeployChild | undefined;
   add_secret_delegation: TAddSecretDelegation | undefined;
   remove_secret_delegation: TRemoveSecretDelegation | undefined;
   /**
    *  Enables updating HFSM state.
    */
   update_hfsm_state: TNodeControl_TUpdateHfsmState | undefined;
   /**
    *  Adds node alert.
    */
   add_alert: TNodeControl_TAddAlert | undefined;
   /**
    *  Removes node alert.
    */
   remove_alert: TNodeControl_TRemoveAlert | undefined;
   /**
    *  Attaches disk to node. For debug use only.
    */
   attach_persistent_disk: TNodeControl_TAttachPersistentDisk | undefined;
   /**
    *  Detaches disk from node. For debug use only.
    */
   detach_persistent_disk: TNodeControl_TDetachPersistentDisk | undefined;
}

export interface TNodeControl_TUpdateHfsmState {
   /**
    *  New HFSM state.
    */
   state: EHfsmState;
   /**
    *  Comment for changing HFSM state.
    */
   message: string;
   /**
    *  Optional maintenance information.
    *  Can be passed only if state is equal to HS_PREPARE_MAINTENANCE.
    */
   maintenance_info: TMaintenanceInfo | undefined;
   /**
    *  Optional maintenance key.
    *  Can be passed only if state is equal to HS_PREPARE_MAINTENANCE.
    *  Can be passed instead of maintenance info.
    */
   maintenance_key: string;
}

export interface TNodeControl_TAddAlert {
   /**
    *  Type of the alert to add (see TNodeAlert).
    */
   type: string;
   /**
    *  Human-readable description of the alert to add (see TNodeAlert).
    */
   description: string;
   /**
    *  Effect of the alert to add (see TNodeAlert)
    */
   effect: string;
}

export interface TNodeControl_TRemoveAlert {
   /**
    *  UUID of the alert to remove (see TNodeAlert).
    */
   uuid: string;
   /**
    *  Comment for debug purposes.
    */
   message: string;
   /**
    *  Type of the alert to remove (see TNodeAlert).
    */
   type: string;
}

export interface TNodeControl_TAttachPersistentDisk {
   /**
    *  Id of disk to attach.
    */
   disk_id: string;
}

export interface TNodeControl_TDetachPersistentDisk {
   /**
    *  Id of disk to detach.
    */
   disk_id: string;
}

export interface TSchemaSpec {}

export interface TSchemaStatus {}

export interface TResourceMetaBase {
   node_id: string;
   kind: EResourceKind;
}

export interface TResourceSpec {
   cpu: TResourceSpec_TCpuSpec | undefined;
   memory: TResourceSpec_TMemorySpec | undefined;
   disk: TResourceSpec_TDiskSpec | undefined;
   slot: TResourceSpec_TSlotSpec | undefined;
   gpu: TResourceSpec_TGpuSpec | undefined;
   network: TResourceSpec_TNetworkSpec | undefined;
}

export interface TResourceSpec_TCpuSpec {
   /**
    *  In virtual millicores.
    */
   total_capacity: number;
   /**
    *  Calibrated compute power of a single "physical" CPU core.
    *  Typically "physical" CPU cores are, in fact, HT threads.
    */
   cpu_to_vcpu_factor: number;
   /**
    *  Percentage of total capacity that we try to keep busy by boosting the vcpu_limit of
    *  the pods that have it labeled scalable.
    */
   target_scaling_percentage: number;
   numa_nodes: TResourceSpec_TCpuSpec_TNumaNodeCpuSpec[];
}

/**
 *  NUMA-nodes of this CPU resoure.
 */
export interface TResourceSpec_TCpuSpec_TNumaNodeCpuSpec {
   id: number;
   cpu_ids: number[];
   /**
    *  NB: sum of total capacities over all the NUMA nodes does not necessarily
    *  match total_capacity of this resource. It is used purely as a hint.
    */
   total_capacity: number;
}

export interface TResourceSpec_TMemorySpec {
   /**
    *  In bytes.
    */
   total_capacity: number;
   numa_nodes: TResourceSpec_TMemorySpec_TNumaNodeMemorySpec[];
}

/**
 *  NUMA-nodes of this memory resource.
 */
export interface TResourceSpec_TMemorySpec_TNumaNodeMemorySpec {
   id: number;
   /**
    *  NB: sum of total capacities over all the NUMA nodes does not necessarily
    *  match total_capacity of this resource. It is used purely as a hint.
    */
   total_capacity: number;
}

export interface TResourceSpec_TNetworkSpec {
   /**
    *  In bytes per second.
    */
   total_bandwidth: number;
}

/**
 *  Cf. TPersistentDiskSpec.TManagedPolicy.
 */
export interface TResourceSpec_TDiskSpec {
   /**
    *  E.g. ssd, hdd etc.
    */
   storage_class: string;
   /**
    *  Describes disk configuration and available features.
    *  Supported non-empty values: "shared", "lvm".
    *  Empty value is implicitly considered as "shared".
    *  Not specified by default.
    *
    *  Shared:
    *  One file system is used for all volumes and all pods.
    *  IO write limit affects only writes with O_DIRECT.
    *  Volumes will be physically located on partitions /place and /ssd.
    *  Page cache is shared, https://clubs.at.yandex-team.ru/infra-cloud-dev/1054.
    *
    *  LVM:
    *  Separate file system is used per volume.
    *  IO write limit works as expected.
    *  Nothing is shared.
    */
   storage_provisioner: string;
   /**
    *  In bytes.
    */
   total_capacity: number;
   /**
    *  Each volume occupies a virtual "slot".
    *  This prevents assigning too many volumes to a single physical disk.
    */
   total_volume_slots: number;
   /**
    *  E.g. /dev/* path.
    */
   device: string;
   /**
    *  List of supported allocation policies.
    */
   supported_policies: EDiskVolumePolicy[];
   /**
    *  Total provided bandwidth in bytes per second.
    */
   total_bandwidth: number;
   /**
    *  Total provided read bandwidth is estimated
    *  using total_bandwidth and the following factor.
    */
   read_bandwidth_factor: number;
   /**
    *  Total provided write bandwidth is estimated
    *  using total_bandwidth and the following factor.
    */
   write_bandwidth_factor: number;
   /**
    *  Total provided read operations per second is estimated
    *  using total_bandwidth and the following divisor.
    */
   read_operation_rate_divisor: number;
   /**
    *  Total provided write operations per second is estimated
    *  using total_bandwidth and the following divisor.
    */
   write_operation_rate_divisor: number;
}

export interface TResourceSpec_TSlotSpec {
   total_capacity: number;
}

export interface TResourceSpec_TGpuSpec {
   /**
    *  Got from driver api.
    */
   uuid: string;
   /**
    *  E.g. v100, k100 etc.
    */
   model: string;
   /**
    *  In bytes.
    */
   total_memory: number;
   mode: EGpuMode;
}

export interface TResourceAlert {
   /**
    *  Arbitrary type. It is supposed to be used for grouping and selection.
    *  For example, "decommissioned".
    */
   type: string;
   /**
    *  Globally-unique identifier generated by master.
    */
   uuid: string;
   /**
    *  Creation time.
    */
   creation_time: Date | { nanos: number; seconds: number } | undefined;
   /**
    *  Human-readable description.
    */
   description: string;
   /**
    *  Dynamically typed description.
    */
   labels: TAttributeDictionary | undefined;
   /**
    *  Supported effects:
    *      no_schedule (default) - light scheduler will not schedule pods on a resources
    *          with such alert. However, if a pod is already scheduled on a resource
    *          with such alert, it will not be evicted.
    *      no_execute - the same as no_schedule in terms of light scheduler, but heavy
    *          scheduler will request eviction for all pods scheduled on a resource
    *          with such alert.
    */
   effect: string;
}

/**
 *  Scheduler ensures that:
 *  1. There is no guaranteed capacity overcommit in the scheduled allocations;
 *  2. There is no effective capacity overcommit in the combination of actual and scheduled allocations.
 *
 *  Pod can be allocated synchronously if these constraints are not violated.
 *  Note that this requires special permissions.
 *
 *  Pod can be allocated asynchronously if the first constraint is not violated,
 *  though it may possibly take some time to deallocate non-guaranteed resources.
 *
 *  Guaranteed capacity/bandwidth can be different from the effective one,
 *  but must be allocated on demand as soon as possible.
 */
export interface TResourceStatus {
   /**
    *  The process of resource allocation is asynchronous.
    *  Actual allocations correspond to the last state of resources actually allocated on the node.
    *  Scheduled allocations correspond to the scheduled state of resources.
    */
   scheduled_allocations: TResourceStatus_TAllocation[];
   actual_allocations: TResourceStatus_TAllocation[];
   /**
    *  Aggregate resource allocations into the free and used statistics.
    *
    *  Effective capacities within these statistics are calculated
    *  taking both scheduled and actual resource allocations.
    *
    *  Guaranteed capacities within these statistics are calculated
    *  taking only scheduled resource allocations, because
    *  actual guaranteed capacities do not make any difference.
    */
   free: TResourceStatus_TAllocationStatistics | undefined;
   used: TResourceStatus_TAllocationStatistics | undefined;
   alerts: TResourceAlert[];
}

export interface TResourceStatus_TCpuAllocation {
   /**
    *  Effective capacity in virtual millicores.
    */
   capacity: number;
   /**
    *  Optional guaranteed capacity in virtual millicores.
    *  Equals to the effective capacity if not present.
    */
   guaranteed_capacity: number;
   /**
    *  Optional NUMA node of this allocation.
    */
   numa_node_id: number;
}

export interface TResourceStatus_TMemoryAllocation {
   /**
    *  Effective capacity in bytes.
    */
   capacity: number;
   /**
    *  Optional guaranteed capacity in bytes.
    *  Equals to the effective capacity if not present.
    */
   guaranteed_capacity: number;
   /**
    *  Optional NUMA node of this allocation.
    */
   numa_node_id: number;
}

export interface TResourceStatus_TNetworkAllocation {
   /**
    *  Effective bandwidth in bytes per second.
    */
   bandwidth: number;
   /**
    *  Optional guaranteed bandwidth in bytes per second.
    *  Equals to the effective bandwidth if not present.
    */
   guaranteed_bandwidth: number;
}

export interface TResourceStatus_TDiskAllocation {
   /**
    *  In bytes.
    */
   capacity: number;
   exclusive: boolean;
   volume_id: string;
   /**
    *  In bytes per second.
    */
   bandwidth: number;
}

export interface TResourceStatus_TSlotAllocation {
   /**
    *  Effective capacity in slots.
    */
   capacity: number;
   /**
    *  Optional guaranteed capacity in slots.
    *  Equals to the effective capacity if not present.
    */
   guaranteed_capacity: number;
}

export interface TResourceStatus_TGpuAllocation {
   /**
    *  Copied from /pod/status/gpu_allocations/* /id
    */
   allocation_id: string;
   /**
    *  Effective capacity in GPUs.
    */
   capacity: number;
   /**
    *  Optional guaranteed capacity in GPUs.
    *  Equals to the effective capacity if not present.
    */
   guaranteed_capacity: number;
}

export interface TResourceStatus_TAllocation {
   pod_id: string;
   pod_uuid: string;
   cpu: TResourceStatus_TCpuAllocation | undefined;
   memory: TResourceStatus_TMemoryAllocation | undefined;
   disk: TResourceStatus_TDiskAllocation | undefined;
   slot: TResourceStatus_TSlotAllocation | undefined;
   gpu: TResourceStatus_TGpuAllocation | undefined;
   network: TResourceStatus_TNetworkAllocation | undefined;
}

export interface TResourceStatus_TCpuStatistics {
   /**
    *  Effective capacity in virtual millicores.
    */
   capacity: number;
   /**
    *  Guaranteed capacity in virtual millicores.
    */
   guaranteed_capacity: number;
}

export interface TResourceStatus_TMemoryStatistics {
   /**
    *  Effective capacity in bytes.
    */
   capacity: number;
   /**
    *  Guarateed capacity in bytes.
    */
   guaranteed_capacity: number;
}

export interface TResourceStatus_TNetworkStatistics {
   /**
    *  Effective bandwidth in bytes per second.
    */
   bandwidth: number;
   /**
    *  Guaranteed bandwidth in bytes per second.
    */
   guaranteed_bandwidth: number;
}

export interface TResourceStatus_TDiskStatistics {
   /**
    *  In bytes.
    */
   capacity: number;
   /**
    *  In bytes per second.
    */
   bandwidth: number;
   /**
    *  In slots.
    */
   volume_slots: number;
}

export interface TResourceStatus_TSlotStatistics {
   /**
    *  Effective capacity in slots.
    */
   capacity: number;
   /**
    *  Guaranteed capacity in slots.
    */
   guaranteed_capacity: number;
}

export interface TResourceStatus_TGpuStatistics {
   /**
    *  Effective capacity in GPUs.
    */
   capacity: number;
   /**
    *  Guarateed capacity in GPUs.
    */
   guaranteed_capacity: number;
}

export interface TResourceStatus_TAllocationStatistics {
   cpu: TResourceStatus_TCpuStatistics | undefined;
   memory: TResourceStatus_TMemoryStatistics | undefined;
   disk: TResourceStatus_TDiskStatistics | undefined;
   slot: TResourceStatus_TSlotStatistics | undefined;
   gpu: TResourceStatus_TGpuStatistics | undefined;
   network: TResourceStatus_TNetworkStatistics | undefined;
}

export interface TResourceControl {
   /**
    *  TODO(deep): extract nested messages and convert to ControlBase
    */
   add_deploy_child: TAddDeployChild | undefined;
   remove_deploy_child: TRemoveDeployChild | undefined;
   add_secret_delegation: TAddSecretDelegation | undefined;
   remove_secret_delegation: TRemoveSecretDelegation | undefined;
   /**
    *  Adds resource alert.
    */
   add_alert: TResourceControl_TAddAlert | undefined;
   /**
    *  Removes resource alert.
    */
   remove_alert: TResourceControl_TRemoveAlert | undefined;
}

export interface TResourceControl_TAddAlert {
   /**
    *  Type of the alert to add (see TResourceAlert).
    */
   type: string;
   /**
    *  Human-readable description of the alert to add (see TResourceAlert).
    */
   description: string;
   /**
    *  Effect of the alert to add (see TResourceAlert)
    */
   effect: string;
}

export interface TResourceControl_TRemoveAlert {
   /**
    *  UUID of the alert to remove (see TResourceAlert).
    */
   uuid: string;
   /**
    *  Comment for debug purposes.
    */
   message: string;
   /**
    *  Type of the alert to remove (see TResourceAlert).
    */
   type: string;
}

export interface TPodMetaBase {
   pod_set_id: string;
}

export interface TPodDynamicResourceSpec {
   /**
    *  Resource identifier.
    */
   id: string;
   /**
    *  Desired revision of the resource.
    */
   revision: number;
   /**
    *  Short label describing resource deploy group.
    */
   mark: string;
   storage_options: TPodDynamicResourceSpec_TStorageOptions | undefined;
   /**
    *  URLs where to download the resource from
    *  supported protocols: http, https, rbtorrent, raw
    *  (for raw resources use "raw:data").
    *  URLs are tried in order until successful download.
    */
   urls: string[];
}

export interface TPodDynamicResourceSpec_TStorageOptions {
   /**
    *  Name of the box to download resource into.
    */
   box_ref: string;
   /**
    *  Filesystem path where the application should see the resource.
    */
   destination: string;
   /**
    *  Filesystem path where resource versions should be downloaded.
    */
   storage_dir: string;
   http_action: TPodDynamicResourceSpec_TStorageOptions_THttpAction | undefined;
   exec_action: TPodDynamicResourceSpec_TStorageOptions_TExecAction | undefined;
   /**
    *  Rule how to check the resource.
    */
   verification: TPodDynamicResourceSpec_TStorageOptions_TVerification | undefined;
   /**
    *  How many copies including actual one should be kept. It's not recommended to use less than 2 (default).
    *  If you set 1, your resource will be fully removed before downloading new revision.
    */
   cached_revisions_count: number;
   /**
    *  Allow resource to be deduplicated via hardlinks if present.
    *  Supported only for rbtorrent URLs.
    *  Use only if you know what you are doing! Hardlinked data can be corrupted
    *  by other users of the resource on the same host.
    */
   allow_deduplication: boolean;
   /**
    *  Download speed limit in MBits per second.
    *  Supported only for rbtorrent URLs.
    */
   max_download_speed: number;
}

/**
 *  HTTP GET handle to notify.
 *  HTTP response codes from range 200-299 are considered to be success.
 */
export interface TPodDynamicResourceSpec_TStorageOptions_THttpAction {
   /**
    *  Url to call.
    */
   url: string;
   /**
    *  Expected HTTP response body.
    */
   expected_answer: string;
}

/**
 *  Shell command to exec to notify.
 */
export interface TPodDynamicResourceSpec_TStorageOptions_TExecAction {
   /**
    *  Shell command to execute.
    */
   command_line: string;
   /**
    *  Stdout to accept, if empty, stdout is ignored.
    */
   expected_answer: string;
}

export interface TPodDynamicResourceSpec_TStorageOptions_TVerification {
   /**
    *  Checksum in the form: <scheme>:<value> Supported schemes are "MD5:", "EMPTY:", "SHA256:", all case sensitive.
    */
   checksum: string;
   /**
    *  Period of checksum check. First check is done right after download.
    */
   check_period_ms: number;
}

/**
 *  Next field 30
 */
export interface TPodSpec {
   /**
    *  Raw ISS payload to be delivered to agent.
    *  COMPAT(babenko): will be deprecated after switching to pod agent.
    */
   iss_payload: Uint8Array;
   /**
    *  Structured ISS spec.
    *  COMPAT(babenko): will be deprecated after switching to pod agent.
    */
   iss: HostConfiguration | undefined;
   /**
    *  Pod agent deployment and its workload specs.
    *  COMPAT(babenko): Either this or iss_payload/iss should be present.
    */
   pod_agent_payload: TPodSpec_TPodAgentPayload | undefined;
   /**
    *  Node id this pod must be assigned to.
    *  XXX(babenko): WILL BE REMOVED SOON. DON'T USE.
    */
   node_id: string;
   scheduling: TPodSpec_TScheduling | undefined;
   /**
    *  CPU, memory and other resources to allocate and configure for this pod upon assignment.
    */
   resource_requests: TPodSpec_TResourceRequests | undefined;
   /**
    *  IP6 addresses to allocate for this pod upon assignment.
    */
   ip6_address_requests: TPodSpec_TIP6AddressRequest[];
   /**
    *  IP6 subnets to allocate for this pod upon assignment.
    */
   ip6_subnet_requests: TPodSpec_TIP6SubnetRequest[];
   /**
    *  Transient disk volumes to allocate for this pod upon assignment.
    */
   disk_volume_requests: TPodSpec_TDiskVolumeRequest[];
   /**
    *  Persistent disk volumes (indirectly represented by claims) to mount into this pod upon assignment.
    */
   disk_volume_claims: TPodSpec_TDiskVolumeClaim[];
   /**
    *  GPUs to allocate for this pod upon assignment.
    */
   gpu_requests: TPodSpec_TGpuRequest[];
   /**
    *  If false then YP will not be scheduling this pod.
    */
   enable_scheduling: boolean;
   /**
    *  If given, controls which nodes are eligible for this pod.
    *  Filter is a query language predicate; it can only refer to node labels, not other attributes.
    */
   node_filter: string;
   /**
    *  Host devices to configure.
    *  https://wiki.yandex-team.ru/porto/propertiesanddata/#resursy
    */
   host_devices: TPodSpec_THostDevice[];
   /**
    *  Sysctl properties to configure.
    */
   sysctl_properties: TPodSpec_TSysctlProperty[];
   virtual_service_options: TPodSpec_TVirtualServiceOptions | undefined;
   /**
    *  Determines the kind of "hostname" Porto property: either
    *  "persistent" or "transient" pod FQDN can be used.
    */
   host_name_kind: EPodHostNameKind;
   /**
    *  Defines secrets to be delivered to the pod.
    */
   secrets: { [key: string]: TPodSpec_TSecret };
   /**
    *  References secrets to be delivered to the pod.
    */
   secret_refs: { [key: string]: TSecretRef };
   /**
    *  If the following field is set, pod will be created without checking it secret references.
    */
   disable_secret_validation: boolean;
   /**
    *  If given, overrides the podset's account.
    */
   account_id: string;
   /**
    *  Provides means to deliver certain parts of pod's metadata to the node.
    */
   dynamic_attributes: TPodSpec_TDynamicAttributes | undefined;
   /**
    *  Dynamic resources for the pod.
    */
   dynamic_resources: TPodDynamicResourceSpec[];
   /**
    *  Resource cache for the pod
    */
   resource_cache: TPodSpec_TPodAgentResourceCache | undefined;
   /**
    *  Defines the behavior policy when OOM occurs on one of the containers.
    *  "oom_is_fatal: false" will be set if the OOMP_KILL_PROCESS parameter is passed.
    *  "oom_is_fatal: true" will be set if the OOMP_REBUILD_POD parameter is passed.
    *  Nothing will be set for "oom_is_fatal" property otherwise.
    */
   out_of_memory_policy: EPodOutOfMemoryPolicy;
   /**
    *  Host infrastructure settings.
    *  Available on host via node agent REST interface.
    */
   host_infra: THostInfraInfo | undefined;
   /**
    *  Host capability names as they will be forwarded to node agent.
    *  http://man7.org/linux/man-pages/man7/capabilities.7.html
    */
   capabilities: string[];
   network_settings: TPodSpec_TNetworkSettings | undefined;
}

export interface TPodSpec_TPodAgentDeploymentMeta {
   /**
    *  URL to download pod agent binary from.
    *  This might be unified with TLayer now, but they may diverge later, so leave it here.
    */
   url: string;
   /**
    *  <scheme>:<hex value>. Supported schemes are "MD5" and "EMPTY".
    */
   checksum: string;
   /**
    *  Arguments to be passed to pod agent via command line.
    */
   configuration: { [key: string]: string };
   /**
    *  List of layers to construct pod chroot fs from, from top to bottom (same order as used by porto).
    */
   layers: TPodSpec_TPodAgentDeploymentMeta_TLayer[];
   /**
    *  Disk volume settings for sidecar
    */
   sidecar_volume: TSidecarVolume | undefined;
   /**
    *  pod agent binary sandbox revision
    */
   binary_revision: number;
   /**
    *  It describe porto limits for pod agent container.
    */
   compute_resources: TPodSpec_TPodAgentContainerResources | undefined;
}

export interface TPodSpec_TPodAgentDeploymentMeta_ConfigurationEntry {
   key: string;
   value: string;
}

export interface TPodSpec_TPodAgentDeploymentMeta_TLayer {
   /**
    *  URL to download layer from.
    */
   url: string;
   /**
    *  <scheme>:<hex value>. Supported schemes are "MD5" and "EMPTY".
    */
   checksum: string;
}

/**
 *  It must be binary compatibility with TComputeResources from
 *  https://a.yandex-team.ru/arc/trunk/arcadia/yp/yp_proto/yp/client/api/proto/pod_agent.proto
 *  see https://bb.yandex-team.ru/projects/PORTO/repos/porto/browse/porto.md
 */
export interface TPodSpec_TPodAgentContainerResources {
   /**
    *  All CPU limits are need to set in milli CPU (vcpu). 1000 vcpu equals 1 real core.
    *  Desired CPU power.
    */
   vcpu_guarantee: number;
   /**
    *  CPU usage limit.
    */
   vcpu_limit: number;
   /**
    *  Guarantee for memory_usage.
    */
   memory_guarantee: number;
   /**
    *  Limit for memory_usage.
    */
   memory_limit: number;
   /**
    *  Limit for anon_usage (offstream kernel feature).
    */
   anonymous_memory_limit: number;
   /**
    *  If true immigrate cache on minor page fault, default: false (offstream kernel feature).
    */
   recharge_on_pgfault: boolean;
   /**
    *  Limit for thread_count.
    */
   thread_limit: number;
}

export interface TPodSpec_TPodAgentPayload {
   spec: TPodAgentSpec | undefined;
   meta: TPodSpec_TPodAgentDeploymentMeta | undefined;
}

export interface TPodSpec_TSchedulingHint {
   /**
    *  Pod-wise unique identifier.
    *  Will be randomly generated if not provided.
    */
   uuid: string;
   /**
    *  Creation time.
    *  Will be set to master current time if not provided.
    */
   creation_time: Date | { nanos: number; seconds: number } | undefined;
   /**
    *  Node id. Cannot be empty.
    *  Allowed to refer to nonexistent node, because it greatly simplifies
    *  hints management especially in case of pod copying with concurrent node removal.
    */
   node_id: string;
   /**
    *  If true, scheduler must satisfy hint.
    *  If false, node from hint is preferred, but not obligated.
    */
   strong: boolean;
   /**
    *  Identifier of the source of the hint, e.g. "heavy-scheduler".
    *  Empty by default. Can be used as a grouping key.
    */
   source: string;
   /**
    *  If true, hint will be removed after pod is assigned. Weak scheduling hints
    *  will be removed even if pod was assigned to a different node.
    */
   one_shot: boolean;
}

export interface TPodSpec_TScheduling {
   /**
    *  Hints, that scheduler will take into account during planning of pod allocation.
    */
   hints: TPodSpec_TSchedulingHint[];
   /**
    *  Similar to hints, but scheduler will try NOT to assign pod to the respective node.
    *  In contrast with hints, there can be multiple strong scheduling antihints.
    */
   antihints: TPodSpec_TSchedulingHint[];
   /**
    *  Scheduler will ignore node alerts with types and effects specified in node tolerations.
    */
   alert_tolerations: TAlertToleration[];
}

export interface TPodSpec_TResourceRequests {
   /**
    *  In virtual millicores.
    */
   vcpu_guarantee: number;
   vcpu_limit: number;
   /**
    *  Requests automatic increase of vcpu_limit when the node is underutilized.
    */
   vcpu_limit_scalable: boolean;
   /**
    *  In bytes.
    */
   memory_guarantee: number;
   memory_limit: number;
   anonymous_memory_limit: number;
   dirty_memory_limit: number;
   /**
    *  Number of slots to occupy on a node.
    *  Allows limiting total number of pods on a node.
    *  Requires special permission to overwrite default value of 1.
    */
   slot: number;
   /**
    *  In bytes per second.
    */
   network_bandwidth_guarantee: number;
   network_bandwidth_limit: number;
   /**
    *  Pod container thread limit.
    *  Requires use permission for pod set node segment attribute /access/scheduling/change_thread_limit.
    */
   thread_limit: number;
   /**
    *  anon_limit_policy controls gap between memory_limit and anonymous_memory_limit,
    *  it must be consistent with anonymous_memory_limit value. Currently anon_limit_policy
    *  is supported by YP-lite only and YP-lite users have no ability to change this
    *  field value directly with YP API.
    *  For details see: SWAT-3782
    */
   anon_limit_policy: string;
}

export interface TPodSpec_TIP6AddressRequest {
   /**
    *  Id of network_project.
    *  This attribute supports update without rescheduling.
    */
   network_id: string;
   /**
    *  Will be matched against /node/spec/ip6_subnets/* /vlan_id.
    */
   vlan_id: string;
   /**
    *  These labels get propagated to /pod/status/ip6_address_allocations/* /labels
    */
   labels: TAttributeDictionary | undefined;
   /**
    *  If true, this address is published to DNS.
    */
   enable_dns: boolean;
   /**
    *  If non-empty, full DNS name is prepended with this string (plus dot).
    */
   dns_prefix: string;
   /**
    *  If true, internet tunnels is configured (InternetAddress is allocated and assigned to pod). See st/YP-1213.
    */
   enable_internet: boolean;
   /**
    *  If given, virtual service tunnels are configured.
    */
   virtual_service_ids: string[];
   /**
    *  If given, InternetAddress is allocated in given pool.
    *  Otherwise InternetAddress is allocated in default pool if enable_internet is set.
    */
   ip4_address_pool_id: string;
   /**
    *  Determines sorting of addresses in porto properties. Higher comes later.
    *  Among equivalent addresses, the last one is selected as the default for outgoing packets.
    *  Suggested assignment is in increments of 100.
    */
   priority: number;
}

export interface TPodSpec_TIP6SubnetRequest {
   /**
    *  Id of network_project.
    *  If omitted, no network configuration is actually being applied at nodes;
    *  however the IP6 address nonce is still being reserved.
    */
   network_id: string;
   /**
    *  Will be matched against /node/spec/ip6_subnets/* /vlan_id.
    */
   vlan_id: string;
   /**
    *  These labels get propagated to /node/status/ip6_subnet_allocations/* /labels
    */
   labels: TAttributeDictionary | undefined;
}

export interface TPodSpec_TDiskVolumeRequest {
   /**
    *  Pod-wise unique id.
    *  TODO(babenko): rename to "name"
    */
   id: string;
   /**
    *  These labels get propagated to /pod/status/disk_volume_allocations/* /labels
    */
   labels: TAttributeDictionary | undefined;
   /**
    *  E.g. ssd, hdd.
    */
   storage_class: string;
   /**
    *  Volume will be allocated on the disk with specified provisioner.
    *  Supported values: "lvm", "shared".
    *  Empty value is implicitly considered as "shared".
    *  Not specified by default.
    */
   storage_provisioner: string;
   quota_policy: TPodSpec_TDiskVolumeRequest_TQuotaPolicy | undefined;
   exclusive_policy: TPodSpec_TDiskVolumeRequest_TExclusivePolicy | undefined;
}

export interface TPodSpec_TDiskVolumeRequest_TQuotaPolicy {
   /**
    *  Guaranteed volume capacity.
    */
   capacity: number;
   /**
    *  Guaranteed volume bandwidth in bytes per second.
    */
   bandwidth_guarantee: number;
   /**
    *  Volume bandwidth limit in bytes per second.
    */
   bandwidth_limit: number;
}

export interface TPodSpec_TDiskVolumeRequest_TExclusivePolicy {
   /**
    *  Minimum capacity the disk must have.
    *  The client, however, will be charged for the whole disk capacity.
    */
   min_capacity: number;
   /**
    *  Minimum bandwidth in bytes per second the disk must provide.
    *  The client, however, will be charged for the whole disk bandwidth.
    */
   min_bandwidth: number;
}

export interface TPodSpec_TDiskVolumeClaim {
   /**
    *  Altogether, TDiskVolumeRequest.id and TDiskVolumeClaim.name are pod-wise unique
    *  and enable addressing volumes (both transient and persistent) within a pod.
    */
   name: string;
   /**
    *  These labels get propagated to /pod/status/disk_volume_mounts/* /labels
    */
   labels: TAttributeDictionary | undefined;
   /**
    *  Persistent volume claim whose associated volume must be mounted into the pod.
    */
   claim_id: string;
}

export interface TPodSpec_TGpuRequest {
   /**
    *  Pod-wise unique id.
    */
   id: string;
   /**
    *  GPU model.
    */
   model: string;
   /**
    *  In bytes.
    */
   min_memory: number;
   /**
    *  In bytes.
    */
   max_memory: number;
   /**
    *  GPU mode.
    */
   mode: EGpuMode;
}

export interface TPodSpec_THostDevice {
   /**
    *  E.g. /dev/kvm
    */
   path: string;
   /**
    *  E.g. "r", "rw"
    */
   mode: string;
}

export interface TPodSpec_TSysctlProperty {
   name: string;
   value: string;
}

export interface TPodSpec_TVirtualServiceOptions {
   ip4_mtu: number;
   ip6_mtu: number;
   decapsulator_anycast_address: string;
}

export interface TPodSpec_TSecret {
   secret_id: string;
   secret_version: string;
   delegation_token: string;
}

export interface TPodSpec_SecretsEntry {
   key: string;
   value: TPodSpec_TSecret | undefined;
}

export interface TPodSpec_SecretRefsEntry {
   key: string;
   value: TSecretRef | undefined;
}

export interface TPodSpec_TDynamicAttributes {
   /**
    *  List of pod annotation keys to be delivered to the pod.
    */
   annotations: string[];
}

export interface TPodSpec_TPodAgentResourceCache {
   spec: TPodAgentResourceCacheSpec | undefined;
}

export interface TPodSpec_TNetworkSettings {
   /**
    *  Enables porto ip_limit.
    *  https://bb.yandex-team.ru/projects/PORTO/repos/porto/browse/porto.md
    */
   ip_limit: boolean;
   /**
    *  Enables additional router settings from /etc/default/portod.conf.
    */
   extra_routes: boolean;
}

export interface TPodDynamicResourceStatus {
   /**
    *  Resource identifier.
    */
   id: string;
   /**
    *  Current resource revision in pod.
    */
   revision: number;
   /**
    *  Short label describing deploy group.
    */
   mark: string;
   /**
    *  Resource is currently active.
    */
   ready: TCondition | undefined;
   /**
    *  Resource is currently being deployed.
    */
   in_progress: TCondition | undefined;
   /**
    *  Resource deploy failed with error.
    */
   error: TCondition | undefined;
}

export interface TPodStatus {
   /**
    *  Node where this pod currently belongs to.
    */
   node_id: string;
   agent: TPodStatus_TAgent | undefined;
   scheduled_resource_allocations: TPodStatus_TResourceAllocation[];
   cpu_allocation: TPodStatus_TCpuAllocation | undefined;
   ip6_address_allocations: TPodStatus_TIP6AddressAllocation[];
   ip6_subnet_allocations: TPodStatus_TIP6SubnetAllocation[];
   disk_volume_allocations: TPodStatus_TDiskVolumeAllocation[];
   disk_volume_mounts: TPodStatus_TDiskVolumeMount[];
   gpu_allocations: TPodStatus_TGpuAllocation[];
   dns: TPodStatus_TDns | undefined;
   eviction: TPodStatus_TEviction | undefined;
   maintenance: TPodStatus_TMaintenance | undefined;
   /**
    *  Node alerts which are periodically fetched from the /node/status/alerts.
    *  Empty if pod is not assigned to a node.
    */
   node_alerts: TNodeAlert[];
   scheduling: TPodStatus_TScheduling | undefined;
   /**
    *  Increased each time the pod is being assigned to another node.
    */
   generation_number: number;
   /**
    *  Timestamp of the last spec update.
    */
   master_spec_timestamp: number;
   /**
    *  Timestamp of the last known spec reported by the agent.
    */
   agent_spec_timestamp: number;
   /**
    *  Materialized view of dynamic attributes to be pushed to agent.
    */
   pod_dynamic_attributes: TDynamicAttributes | undefined;
   /**
    *  List of dynamic resources currently present in pod.
    */
   dynamic_resources: TPodDynamicResourceStatus[];
   /**
    *  Latest usage collected from the pod.
    */
   latest_resource_usage_snapshot: TPodStatus_TResourceUsageSnapshot | undefined;
   /**
    *  Data already collected by the aggregator; baseline for deltas.
    */
   aggregated_resource_usage_snapshot: TPodStatus_TResourceUsageSnapshot | undefined;
   resource_requests_scaling: TPodStatus_TResourceRequestsScaling | undefined;
   gpu_requests_scaling: TPodStatus_TGpuRequestsScaling | undefined;
   /**
    *  Contains ISS instance spec configuration summary per configuration id
    */
   iss_conf_summaries: { [key: string]: TPodStatus_TIssConfSummary };
   numa_allocation: TPodStatus_TNumaAllocation | undefined;
}

export interface TPodStatus_TAgent {
   /**
    *  ISS pod state.
    */
   state: EPodCurrentState;
   /**
    *  Raw ISS payload received from agent.
    *  COMPAT(babenko): will be deprecated after switching to pod agent.
    */
   iss_payload: Uint8Array;
   /**
    *  Structured ISS status.
    *  COMPAT(babenko): will be deprecated after switching to pod agent.
    */
   iss: HostCurrentState | undefined;
   /**
    *  Summary from ISS Status.
    */
   iss_summary: TPodStatus_TAgent_TIssSummary | undefined;
   /**
    *  Pod agent status.
    *  COMPAT(babenko): Either this or iss_payload/iss should be present.
    */
   pod_agent_payload: TPodStatus_TAgent_TPodAgentPayload | undefined;
   /**
    *  Error in pod execution passed from agent via heartbeat.
    */
   execution_error: TError | undefined;
   /**
    *  Error occurred while installing this pod to the node.
    */
   install_error: TError | undefined;
   /**
    *  Contains the spec timestamps for which install_error was observed.
    */
   failed_install_attempt_spec_timestamp: number;
   /**
    *  Errors in pod spec validation passed from agent via heartbeat.
    */
   validation_failures: string[];
   /**
    *  The instant the last heartbeat from agent containing the status of this pod was received.
    */
   last_heartbeat_time: number;
   /**
    *  Pod spec timestamp currently considered as a target by the agent.
    */
   current_spec_timestamp: number;
   /**
    *  Describes pod spec currently considered as a target by the agent.
    *  Indicates whether the spec is completely applied.
    */
   current_spec_applied: TCondition | undefined;
}

export interface TPodStatus_TAgent_TIssStateSummary {
   current_state: string;
   ready: Condition | undefined;
   installed: Condition | undefined;
}

export interface TPodStatus_TAgent_TIssSummary {
   state_summaries: { [key: string]: TPodStatus_TAgent_TIssStateSummary };
   /**
    *  At least one state is ready.
    */
   ready: Condition | undefined;
}

export interface TPodStatus_TAgent_TIssSummary_StateSummariesEntry {
   key: string;
   value: TPodStatus_TAgent_TIssStateSummary | undefined;
}

export interface TPodStatus_TAgent_TPodAgentPayload {
   status: TPodAgentStatus | undefined;
}

export interface TPodStatus_TResourceAllocation {
   resource_id: string;
}

export interface TPodStatus_TCpuAllocation {
   /**
    *  In virtual millicores.
    *  Actual limit sent to the node.
    */
   effective_vcpu_limit: number;
   /**
    *  Extra limit granted to the pod for vertical scaling.
    *  Included in effective_vcpu_limit.
    */
   vcpu_limit_scaling_boost: number;
}

export interface TPodStatus_TIP6AddressAllocation {
   /**
    *  IP6 address assigned by YP, in textual form.
    */
   address: string;
   /**
    *  Copied from /pod/spec/ip6_addresses/* /vlan_id.
    */
   vlan_id: string;
   /**
    *  Copied from /pod/spec/ip6_subnet_requests/* /labels
    */
   labels: TAttributeDictionary | undefined;
   /**
    *  Persistent DNS name assigned to this address (if any) of the form:
    *  [<dns_prefix>.]<pod-id>.<suffix>
    *  This FQDN never changes.
    */
   persistent_fqdn: string;
   /**
    *  Transient DNS name assigned to this address (if any) of the form:
    *  [<dns_prefix>.]<node-short-name>-<generation-number>.<pod-id>.<suffix>
    *  This FQDN changes each time pod gets reassigned to another node.
    */
   transient_fqdn: string;
   /**
    *  Internet address assigned to this allocation.
    */
   internet_address: TPodStatus_TIP6AddressAllocation_TInternetAddress | undefined;
   /**
    *  Virtual services assigned to this allocation.
    */
   virtual_services: TPodStatus_TIP6AddressAllocation_TVirtualService[];
   /**
    *  Copied from /pod/spec/ip6_address_requests/priority.
    */
   priority: number;
}

export interface TPodStatus_TIP6AddressAllocation_TInternetAddress {
   id: string;
   ip4_address: string;
}

export interface TPodStatus_TIP6AddressAllocation_TVirtualService {
   /**
    *  IP6 address, in textual form.
    */
   ip6_addresses: string[];
   /**
    *  IP4 address, in textual form.
    */
   ip4_addresses: string[];
}

export interface TPodStatus_TIP6SubnetAllocation {
   /**
    *  IP6 /112-subnet assigned by YP, in textual form.
    */
   subnet: string;
   /**
    *  Copied from /pod/spec/ip6_addresses/* /vlan_id.
    */
   vlan_id: string;
   /**
    *  Copied from /node/spec/ip6_address_requests/* /labels
    */
   labels: TAttributeDictionary | undefined;
}

export interface TPodStatus_TDiskVolumeAllocation {
   /**
    *  Copied from /pod/spec/disk_volume_requests/* /id.
    *  TODO(babenko): rename to "name"
    */
   id: string;
   /**
    *  Copied from /pod/spec/disk_volume_requests/* /labels.
    */
   labels: TAttributeDictionary | undefined;
   /**
    *  Total volume capacity in bytes.
    */
   capacity: number;
   /**
    *  Id of disk resource where this volume will reside.
    */
   resource_id: string;
   /**
    *  Globally-unique volume id.
    *  This is generated each time a "new" volume is assigned to the pod or an "old" volume is reallocated.
    *  "New" volumes are recognized based on /pod/spec/disk_volume_allocations/* /id.
    */
   volume_id: string;
   /**
    *  Copied from /resource/spec/disk/device.
    */
   device: string;
   /**
    *  Guaranteed volume read bandwidth in bytes per second.
    */
   read_bandwidth_guarantee: number;
   /**
    *  Volume read bandwidth limit in bytes per second.
    */
   read_bandwidth_limit: number;
   /**
    *  Guaranteed volume write bandwidth in bytes per second.
    */
   write_bandwidth_guarantee: number;
   /**
    *  Volume write bandwidth limit in bytes per second.
    */
   write_bandwidth_limit: number;
   /**
    *  Guaranteed volume read operation rate in operations per second.
    */
   read_operation_rate_guarantee: number;
   /**
    *  Volume read operation rate limit in operations per second.
    */
   read_operation_rate_limit: number;
   /**
    *  Guaranteed volume write operation rate in operations per second.
    */
   write_operation_rate_guarantee: number;
   /**
    *  Volume write operation rate limit in operations per second.
    */
   write_operation_rate_limit: number;
}

export interface TPodStatus_TDiskVolumeMount {
   /**
    *  Copied from /pod/spec/disk_volume_claims/* /name.
    */
   name: string;
   /**
    *  Copied from /pod/spec/disk_volume_claims/* /labels.
    */
   labels: TAttributeDictionary | undefined;
   /**
    *  Id of persistent volume satisfying the claim.
    */
   volume_id: string;
}

export interface TPodStatus_TGpuAllocation {
   /**
    *  Globally unique allocation identifier generated on master.
    */
   id: string;
   /**
    *  Copied from /pod/spec/gpu_requests/* /id
    */
   request_id: string;
   /**
    *  Corresponding GPU resource id.
    */
   resource_id: string;
   /**
    *  Copied from /resource/spec/gpu/uuid
    */
   device_uuid: string;
   /**
    *  Copied from /resource/spec/gpu/mode
    */
   mode: EGpuMode;
}

export interface TPodStatus_TDns {
   /**
    *  Persistent FQDN of the form:
    *  <pod-id>.<suffix>
    *  This FQDN never changes.
    */
   persistent_fqdn: string;
   /**
    *  Transient FQDN of the form:
    *  <node-short-name>-<generation-number>.<pod-id>.<suffix>
    *  This FQDN changes each time pod gets reassigned to another node.
    */
   transient_fqdn: string;
}

export interface TPodStatus_TEviction {
   state: EEvictionState;
   reason: EEvictionReason;
   last_updated: number;
   message: string;
}

export interface TPodStatus_TMaintenance {
   state: EPodMaintenanceState;
   last_updated: number;
   message: string;
   info: TMaintenanceInfo | undefined;
}

export interface TPodStatus_TScheduling {
   state: ESchedulingState;
   node_id: string;
   last_updated: number;
   message: string;
   error: TError | undefined;
   last_state_update_time: number;
   feasible: boolean;
}

export interface TPodStatus_TNetworkUsage {
   /**
    *  Id of network project.
    */
   network_id: string;
   /**
    *  Fastbone/Backbone or default for total usage.
    */
   vlan_id: string;
   /**
    *  Total bytes sent over net since pod container creation.
    */
   tx_bytes: number;
   rx_bytes: number;
}

export interface TPodStatus_TResourceUsage {
   /**
    *  Measurement timestamp.
    */
   timestamp: Date | { nanos: number; seconds: number } | undefined;
   /**
    *  CPU active time in nanoseconds since pod container creation.
    *  Raw porto value for host CPU without VCPU factor.
    */
   cpu: number;
   /**
    *  Memory usage in bytes.
    */
   memory: number;
   network: TPodStatus_TNetworkUsage[];
}

/**
 *  Usage received from the agent + additional computed data.
 */
export interface TPodStatus_TResourceUsageSnapshot {
   /**
    *  Report from the agent.
    */
   usage: TPodStatus_TResourceUsage | undefined;
   /**
    *  Capture of resource spec at the report time to bill allocations.
    */
   allocation: TPodSpec_TResourceRequests | undefined;
   /**
    *  CPU active time adjusted by the vcpu factor and converted to ms.
    */
   vcpu: number;
   /**
    *  Moving average of CPU load in virtual millicores.
    */
   average_vcpu_load: number;
}

/**
 *  CPU, memory and other resource scaling at the model level (as the opposite to the host-level scaling).
 *  Considered together with /spec/resource_requests during the allocation.
 */
export interface TPodStatus_TResourceRequestsScaling {
   override: TPodSpec_TResourceRequests | undefined;
}

/**
 *  GPU resource scaling at the model level (as the opposite to the host-level scaling).
 *  Considered together with /spec/gpu_requests during the allocation.
 */
export interface TPodStatus_TGpuRequestsScaling {
   override: TPodSpec_TGpuRequest[];
}

export interface TPodStatus_TIssConfSummary {
   target_state: string;
}

export interface TPodStatus_IssConfSummariesEntry {
   key: string;
   value: TPodStatus_TIssConfSummary | undefined;
}

export interface TPodStatus_TNumaAllocation {
   numa_node_id: number;
}

export interface TPodControl {
   /**
    *  TODO(deep): extract nested messages and convert to ControlBase
    */
   add_deploy_child: TAddDeployChild | undefined;
   remove_deploy_child: TRemoveDeployChild | undefined;
   add_secret_delegation: TAddSecretDelegation | undefined;
   remove_secret_delegation: TRemoveSecretDelegation | undefined;
   /**
    *  Acknowledges eviction of the pod.
    *  Pod must have /status/eviction/state == "requested" prior to this call and
    *  the latter changes it to "acknowledged".
    */
   acknowledge_eviction: TPodControl_TAcknowledgeEviction | undefined;
   /**
    *  Requests eviction of the pod.
    *  Pod must have /status/eviction/state == "none" prior to this call and
    *  the latter changes it to "requested".
    *  Successful request decrements pod disruption budget if any.
    */
   request_eviction: TPodControl_TRequestEviction | undefined;
   /**
    *  Aborts eviction of the pod.
    *  Pod must have /status/eviction/state == "requested" prior to this call and
    *  the latter changes it to "none".
    */
   abort_eviction: TPodControl_TAbortEviction | undefined;
   /**
    *  Requests and acknowledges eviction of the pod.
    */
   evict: TPodControl_TEvict | undefined;
   /**
    *  Updates master spec timestamp of the pod.
    */
   touch_master_spec_timestamp: TPodControl_TTouchMasterSpecTimestamp | undefined;
   /**
    *  Reallocates resources of the pod.
    *  The method just schedules reallocation;
    *  actual reallocation is deferred to the transaction commit.
    */
   reallocate_resources: TPodControl_TReallocateResources | undefined;
   /**
    *  Acknowledges maintenance of the pod.
    */
   acknowledge_maintenance: TPodControl_TAcknowledgeMaintenance | undefined;
   /**
    *  Renounces previously acknowledged maintenance of the pod.
    */
   renounce_maintenance: TPodControl_TRenounceMaintenance | undefined;
}

export interface TPodControl_TAcknowledgeEviction {
   /**
    *  Comment for the acknowledgement.
    */
   message: string;
}

export interface TPodControl_TRequestEviction {
   /**
    *  Comment for the request.
    */
   message: string;
   /**
    *  If true, eviction request fails with an error for the existent
    *  and empty pod disruption budget.
    *  If false, eviction can be successfully requested even for the existent
    *  and empty pod disruption budget.
    */
   validate_disruption_budget: boolean;
   /**
    *  Reason of the request.
    */
   reason: EEvictionReason;
}

export interface TPodControl_TAbortEviction {
   /**
    *  Comment for the abort.
    */
   message: string;
}

export interface TPodControl_TEvict {
   /**
    *  Comment for the request.
    */
   message: string;
   /**
    *  See TRequestEviction.
    */
   validate_disruption_budget: boolean;
}

export interface TPodControl_TTouchMasterSpecTimestamp {
   /**
    *  Comment for the touch.
    */
   message: string;
}

export interface TPodControl_TReallocateResources {
   /**
    *  Comment for the reallocation.
    */
   message: string;
}

export interface TPodControl_TAcknowledgeMaintenance {
   /**
    *  Comment for the acknowledgement.
    */
   message: string;
}

export interface TPodControl_TRenounceMaintenance {
   /**
    *  Comment for the renouncement.
    */
   message: string;
}

export interface TPodSetSpec {
   /**
    *  Limits placing pods of this pod set to the same topology zone (e.g. node, rack, DC).
    */
   antiaffinity_constraints: TAntiaffinityConstraint[];
   /**
    *  Specifies a node segment where all pods of this pod set must be scheduled to.
    */
   node_segment_id: string;
   /**
    *  Account that must be charged for this podset.
    */
   account_id: string;
   /**
    *  Pod disruption budget that limits this podset disruptions.
    *  Missing value corresponds to the zero budget, i.e. without disruptions at all.
    */
   pod_disruption_budget_id: string;
   /**
    *  If given, controls which nodes are eligible for pods of this pod set.
    *  This filter is only active for a pod of this pod set if this pod's own node_filter is empty.
    *  Filter is a query language predicate; it can only refer to node labels, not other attributes.
    */
   node_filter: string;
   /**
    *  Permissions to violate constraints applied to all pods of the pod set.
    */
   violate_node_segment_constraints: TPodSetSpec_TViolateNodeSegmentConstraints | undefined;
   /**
    *  Specifies allowed and forbidden levels of ISS isolation for pods within this pod set.
    *  Changing this requires use permission to /access/pod_set/change_iss_isolation_spec
    *  path of the pod set node segment.
    */
   iss_isolation: TPodSetSpec_TIssIsolation | undefined;
   /**
    *  All pods will inherit alert tolerations specified in a parent pod set.
    *  If a pod contains its own alert tolerations, they will be combined with alert tolerations
    *  of its parent pod set.
    */
   alert_tolerations: TAlertToleration[];
   /**
    *  If the following field is set, heavy scheduler will request evictions for child pods
    *  with violated node filter.
    */
   enable_node_filter_healing: boolean;
   /**
    *  Applied to pods of the pod set on a next pod spec timestamp change.
    */
   cpu_set_jail: ECpuSetJail;
   /**
    *  Scaling configuration for pod set.
    */
   scaling: TPodSetSpec_TScaling | undefined;
   /**
    *  Overrides /node/spec/scheduling/numa_allocation_mode.
    */
   numa_allocation_override: string;
   /**
    *  If true, pods of this pod set disable vcpu_limit scaling (vertical scaling) on nodes they are assigned to.
    *  May be useful for eliminating node isolation issues due to collocated vcpu_limit scalable pod
    *  with minimal impact on the vcpu_limit scaling infrastructure.
    */
   disable_node_vcpu_limit_scaling: boolean;
}

export interface TPodSetSpec_TViolateNodeSegmentConstraints {
   /**
    *  If true then pods of this pod set can violate pod vcpu guarantee to limit constraint.
    */
   vcpu_guarantee_to_limit_ratio: boolean;
}

export interface TPodSetSpec_TIssIsolation {
   /**
    *  Controls /pod/spec/iss_payload/instances/* /entity/instance/volumes/* if /properties/backend in ("bind", "rbind").
    *  Specifies allowed /properties/storage values.
    *  Implicitly allows /properties/read_only = "true" and /properties/storage = "/Berkanavt/supervisor".
    */
   bindable_volume_storages: string[];
   /**
    *  Specifies allowed values of /pod/spec/iss_payload/instances/* /entity/instance/container/constraints/meta.enable_porto.
    *  Implicitly allows "false", "none", "read-isolate" and "isolate".
    *  Missing /constraints/meta.enable_porto is considered as "full" mode.
    */
   allowed_meta_container_enable_porto_modes: string[];
}

export interface TPodSetSpec_TScaling {
   downscaling: TPodSetSpec_TScaling_TDownscaling | undefined;
   upscaling: TPodSetSpec_TScaling_TUpscaling | undefined;
}

export interface TPodSetSpec_TScaling_TThrottler {
   /**
    *  Maximum number of pods that can be scaled during a given period.
    */
   limit: number;
   /**
    *  Period over which the limit will be applied in milliseconds.
    */
   period: number;
}

export interface TPodSetSpec_TScaling_TDownscaling {
   /**
    *  Zero or more periods when pod set will be downscaled. Periods may overlap:
    *  at any point of time effective pod share is calculated as a maximum over pod shares
    *  of acting periods. Suppose, for example, that for some pod set the following
    *  active periods are configured:
    *  1) 50% of pods from 23:00 to 07:00
    *  2) 70% of pods from 01:00 to 04:00
    *  3) 60% of pods from 03:00 to 06:00
    *  In this case, scaling schedule for pod set will be the following:
    *  1) 23:00-01:00 - 50% of pods
    *  1) 01:00-04:00 - 70% of pods
    *  1) 04:00-06:00 - 60% of pods
    *  1) 06:00-07:00 - 50% of pods
    */
   periods: TPodSetSpec_TScaling_TDownscaling_TPeriod[];
   /**
    *  This throttler will only affect downscalings.
    */
   downscaling_throttler: TPodSetSpec_TScaling_TThrottler | undefined;
   /**
    *  This throttler will only affect resets.
    */
   reset_throttler: TPodSetSpec_TScaling_TThrottler | undefined;
   /**
    *  Minimal resources that should be left to pod while it's downscaled.
    */
   min_vcpu_guarantee: number;
   min_memory_limit: number;
}

export interface TPodSetSpec_TScaling_TDownscaling_TPeriod {
   /**
    *  Time range when pod set will be downscaled (in MSK format). If finish time
    *  is less then start_time, pod set will be reset the next day (e.g. if start_time
    *  is 19:23:54 and finish time is 05:42:17, pod set will be downscaled at 19:23:54,
    *  July, 10 (MSK) and reset at 05:42:17, July, 11 (MSK)).
    */
   start_time: TPodSetSpec_TScaling_TDownscaling_TPeriod_TTime | undefined;
   finish_time: TPodSetSpec_TScaling_TDownscaling_TPeriod_TTime | undefined;
   /**
    *  Share of pods that will be downscaled. Must be in the range [0, 1].
    */
   pod_share: number;
   /**
    *  Group of days when pod set will be downscaled. If start time is greater
    *  than finish time (e.g. pod set is reset the next day after it's downscaled),
    *  days_of_week will determine days when pod set downscaling is started.
    *  Empty days_of_week list will result in disabled downscaling for pod set.
    */
   days_of_week: EDayOfWeek[];
}

export interface TPodSetSpec_TScaling_TDownscaling_TPeriod_TTime {
   hours: number;
   minutes: number;
   seconds: number;
}

export interface TPodSetSpec_TScaling_TUpscaling {
   /**
    *  If the following option is set, pods will use non-allocated resources
    *  of their node, i.e. resources which are not allocated guaranteedly or effectively.
    */
   use_non_allocated: boolean;
   /**
    *  These throttlers will only affect upscalings on non-allocated resources.
    *  Regular upscalings and resets will be performed instantly.
    */
   non_allocated_upscaling_throttler: TPodSetSpec_TScaling_TThrottler | undefined;
   non_allocated_reset_throttler: TPodSetSpec_TScaling_TThrottler | undefined;
   /**
    *  If non-zero, pods will not use entire node leaving some resources unitilized.
    *  These options will be ignored if non-allocated resource usage is disabled.
    */
   vcpu_guarantee_margin: number;
   memory_limit_margin: number;
   gpu_margin: number;
}

export interface TPodSetStatus {
   accounting: TPodSetStatus_TAccounting | undefined;
   scheduling: TPodSetStatus_TScheduling | undefined;
   scaling: TPodSetStatus_TScaling | undefined;
   node_filter_healing: TPodSetStatus_TNodeFilterHealing | undefined;
}

export interface TPodSetStatus_TAccounting {
   resource_usage: TPerSegmentResourceTotals | undefined;
}

export interface TPodSetStatus_TScheduling {
   feasible: boolean;
}

export interface TPodSetStatus_TScaling {
   downscaling_statistics: TPodSetStatus_TScaling_TStatistics | undefined;
   upscaling_statistics: TPodSetStatus_TScaling_TStatistics | undefined;
}

export interface TPodSetStatus_TScaling_TStatistics {
   /**
    *  Scaled pod count.
    */
   pod_count: number;
   /**
    *  Difference between scaled and original resource requests (always non-negative).
    */
   resource_diff: TPerSegmentResourceTotals | undefined;
}

export interface TPodSetStatus_TNodeFilterHealing {
   /**
    *  How many pods from a given pod set violate their node filters.
    */
   violations: number;
   /**
    *  How many pods from a given pod set have broken node filter.
    */
   errors: number;
   /**
    *  When this statistics was calculated.
    */
   last_update_timestamp: number;
}

export interface TEndpointMetaBase {
   endpoint_set_id: string;
}

export interface TEndpointSpec {
   protocol: string;
   fqdn: string;
   ip4_address: string;
   ip6_address: string;
   port: number;
}

export interface TEndpointStatus {
   /**
    *  True, if pod relating to this endpoint is "ready".
    *  Conditions when pod is considered as "ready": @see TEndpointSetSpec.pod_filter comments.
    */
   ready: boolean;
}

export interface TEndpointSetSpec {
   /**
    *  If given, for each "ready" pod matching this filter, an endpoint will be created.
    *  Pod considers as "ready" (has endpoint) when all described below conditions are true:
    *      1. * For pods with Pod Agent: pod's state is ACTIVE and target_state not in [removed, suspended].
    *  For other pods: pod's state is ACTIVE or pod's target state is ACTIVE.
    *      2. Pod has backbone vlan in status.ip6_address_allocations.
    */
   pod_filter: string;
   /**
    *  If given, this value will be propagated to /endpoint/spec/protocol of each created endpoint.
    */
   protocol: string;
   /**
    *  If given, this value will be propagated to /endpoint/spec/port of each created endpoint.
    */
   port: number;
   /**
    *  If given, guarantees that endpoints_count >= ceil(liveness_limit_ratio * pods_count).
    *  Where endpoints_count - endpoints count within endpoint set, pods_count - pod count within endpoint set.
    *
    *  If "ready" pods count >= ceil(liveness_limit_ratio * pods_count) - liveness_limit_ratio has no affect.
    *
    *  In case when endpoints count is less than ceil(liveness_limit_ratio * pods_count),
    *  enpoints will be created one by one (in unspecified order, even for not ready pods)
    *  until number of endpoints reaches ceil(liveness_limit_ratio * pods_count).
    *
    *  In case when endpoints count is greater than ceil(liveness_limit_ratio * pods_count),
    *  endpoints, pointing to "unready" pods, will be deleted one by one (in unspecified order)
    *  until number of endpoints reaches ceil(liveness_limit_ratio * pods_count).
    */
   liveness_limit_ratio: number;
}

export interface TEndpointSetStatus {
   /**
    *  Timestamp of the last change of set of endpoints contained in the endpoint_set
    *  or change of meta, spec or labels of any endpoint in endpoint_set.
    */
   last_endpoints_update_timestamp: number;
   /**
    *  For service controller's report.
    */
   controller: TEndpointSetStatus_TController | undefined;
}

export interface TEndpointSetStatus_TController {
   /**
    *  Errors' codes are unused, they set only because it is required proto field.
    */
   error: TError | undefined;
}

export interface TNetworkProjectSpec {
   /**
    *  "Project id" part of IPv6 addresses.
    */
   project_id: number;
}

export interface TNetworkProjectStatus {}

export interface TNodeSegmentSpec {
   /**
    *  Describes nodes belonging to this segment.
    */
   node_filter: string;
   /**
    *  If enable_unsafe_porto is false,
    *  all pods in this segment must be conformant with pod set ISS isolation spec.
    *  Otherwise pod isolation is not restricted.
    */
   enable_unsafe_porto: boolean;
   /**
    *  Constraints that will be applied to all pods in this node segment.
    */
   pod_constraints: TNodeSegmentSpec_TPodConstraints | undefined;
}

export interface TNodeSegmentSpec_TPodConstraints {
   /**
    *  Vcpu guarantee to limit ratio (vcpu_limit <= multiplier * vcpu_guarantee + additive).
    */
   vcpu_guarantee_to_limit_ratio: TNodeSegmentSpec_TPodConstraints_TVcpuGuaranteeToLimitRatioConstraint | undefined;
}

export interface TNodeSegmentSpec_TPodConstraints_TVcpuGuaranteeToLimitRatioConstraint {
   multiplier: number;
   additive: number;
}

export interface TNodeSegmentStatus {
   /**
    *  Aggregates for all nodes belonging to this segment, regardless of their HFSM state.
    */
   total_resources: TPerSegmentResourceTotals | undefined;
   /**
    *  Aggregates for all nodes belonging to this segment and having "up" HFSM state.
    */
   schedulable_resources: TPerSegmentResourceTotals | undefined;
   /**
    *  Summary of all allocated resources (only guaranteed capacities are considered).
    */
   used_resources: TPerSegmentResourceTotals | undefined;
}

export interface TVirtualServiceSpec {
   /**
    *  IP6 address, in textual form.
    */
   ip6_addresses: string[];
   /**
    *  IP4 address, in textual form.
    */
   ip4_addresses: string[];
}

export interface TVirtualServiceStatus {}

export interface TUserSpec {
   /**
    *  If true, user is forbidden from accessing the cluster.
    */
   banned: boolean;
   /**
    *  0 - unlimited
    */
   request_weight_rate_limit: number;
   request_queue_size_limit: number;
}

export interface TUserStatus {}

export interface TGroupSpec {
   /**
    *  List of subjects (users and groups) that are members of this group.
    */
   members: string[];
}

export interface TGroupStatus {}

export interface TInternetAddressSpec {
   ip4_address: string;
   /**
    *  Deprecated in favor of ip4_address_pool_id YP-1828 YP-2195
    */
   network_module_id: string;
}

export interface TInternetAddressStatus {
   pod_id: string;
}

export interface TInternetAddressMetaBase {
   ip4_address_pool_id: string;
}

export interface TIP4AddressPoolSpec {}

export interface TIP4AddressPoolStatus {}

export interface TDnsRecordSetSpec {
   records: TDnsRecordSetSpec_TResourceRecord[];
}

export interface TDnsRecordSetSpec_TResourceRecord {
   ttl: number;
   class: string;
   type: TDnsRecordSetSpec_TResourceRecord_EType;
   data: string;
}

export enum TDnsRecordSetSpec_TResourceRecord_EType {
   A = 'A',
   NS = 'NS',
   CNAME = 'CNAME',
   SOA = 'SOA',
   PTR = 'PTR',
   MX = 'MX',
   TXT = 'TXT',
   AAAA = 'AAAA',
   SRV = 'SRV',
   RRSIG = 'RRSIG',
   NSEC = 'NSEC',
   DNSKEY = 'DNSKEY',
   CAA = 'CAA',
}

export interface TDnsRecordSetStatus {}

export interface TObjectCounts {
   per_type: { [key: string]: number };
}

export interface TObjectCounts_PerTypeEntry {
   key: string;
   value: number;
}

export interface TAccountSpec {
   parent_id: string;
   resource_limits: TResourceTotals | undefined;
   object_count_limits: TObjectCounts | undefined;
}

export interface TAccountStatus {
   resource_usage: TResourceTotals | undefined;
   immediate_resource_usage: TResourceTotals | undefined;
   object_count_usage: TObjectCounts | undefined;
   immediate_object_count_usage: TObjectCounts | undefined;
}

export interface TPodDisruptionBudgetSpec {
   /**
    *  Limit on the maximum number of unavailable pods.
    */
   max_pods_unavailable: number;
   /**
    *  Limit on the maximum number of pod disruptions between consecutive synchronizations.
    */
   max_pod_disruptions_between_syncs: number;
}

export interface TPodDisruptionBudgetStatus {
   /**
    *  Number of currently allowed pod disruptions.
    */
   allowed_pod_disruptions: number;
   /**
    *  Time of the last status update.
    */
   last_update_time: Date | { nanos: number; seconds: number } | undefined;
   /**
    *  Comment for the last status update.
    */
   last_update_message: string;
}

export interface TMaintenanceSpec {
   /**
    *  Maintenance info as received from Wall-E.
    */
   info: TMaintenanceInfo | undefined;
   /**
    *  Maintenance initiator.
    */
   issuer: string;
   /**
    *  Hosts involved in this maintenance.
    *  It is a list of node ids, but corresponding nodes might not exist.
    */
   hosts: string[];
   /**
    *  Human-readable comment.
    */
   comment: string;
   /**
    *  Type of failure.
    */
   failure_type: string;
   /**
    *  Whether this task has been removed, e.g. deleted by Wall-E through CMS API.
    *  When HFSM sees this flag, it performs some cleanup and then finally deletes
    *  the object for good.
    */
   is_removed: boolean;
}

export interface TMaintenanceStatus {
   /**
    *  Current state of this maintenance.
    *  Assumes one of: "initial", "pending", "requested", "in-progress", "rejected".
    *  Maintenance state is mapped into Wall-E task state as follows:
    *  * "initial", "pending", "requested" -> "in-process" (sic)
    *  * "in-progress" -> "ok"
    *  * "rejected" -> "rejected"
    */
   state: string;
   /**
    *  Human-readable message explaining the current state.
    */
   message: string;
}

export interface TWatchLogConsumerStatus {
   /**
    *  Next timestamp to be processed.
    *  Assumes that all timestamps before it were already processed.
    */
   timestamp: number | undefined;
   continuation_token: string | undefined;
}

export interface TWatchLogConsumerSpec {
   object_type: string;
}

/**
 *  NB! Takes read lock to `existence_lock` column, thus blocking concurrent object removal.
 */
export interface TObjectTouch {}

export interface TObjectTouchIndex {
   index_name: string;
}
