/* eslint-disable */
import { TCondition } from '../../../../../yp_proto/yp/client/api/proto/conditions';
import { TPodSpec } from '../../../../../yp_proto/yp/client/api/proto/data_model';
import { TAttributeDictionary } from '../../../../../yt_proto/yt/core/ytree/proto/attributes';

export interface TDeployProgress {
   /**
    *  Number of pods synced to up-to-date spec.
    */
   pods_ready: number;
   /**
    *  Number of pods currently updating.
    */
   pods_in_progress: number;
   /**
    *  Total number of pods.
    */
   pods_total: number;
   /**
    *  Number of failed pods.
    */
   pods_failed: number;
}

export interface TDeploySpeed {
   /**
    *  Number of pods to update at a time.
    */
   update_portion: number;
   /**
    *  Min delay in seconds between updates.
    */
   min_delay: number;
}

export interface TDeployReadyCriterion {
   ready_threshold: TDeployReadyCriterion_TReadyThreshold | undefined;
}

/**
 *  type - enum which determines threshold.
 *  type values and condition which corresponds to this value:
 */
export interface TDeployReadyCriterion_TReadyThreshold {
   type: string;
   min_ready_pods_percent: TDeployReadyCriterion_TReadyThreshold_TMinReadyPodsPercent | undefined;
   max_not_ready_pods: TDeployReadyCriterion_TReadyThreshold_TMaxNotReadyPods | undefined;
}

export interface TDeployReadyCriterion_TReadyThreshold_TMinReadyPodsPercent {
   value: number;
}

export interface TDeployReadyCriterion_TReadyThreshold_TMaxNotReadyPods {
   value: number;
}

export interface TControllerAttempt {
   succeeded: TCondition | undefined;
}

export interface TControllerStatus {
   last_attempt: TControllerAttempt | undefined;
}

export interface TDeployStatusDetails {
   total_progress: TDeployProgress | undefined;
   current_revision_progress: TDeployProgress | undefined;
   controller_status: TControllerStatus | undefined;
   /**
    *  Legacy attribute, use mapped_revisions instead.
    */
   revisions: { [key: number]: TDeployProgress };
   mapped_revisions: { [key: string]: TDeployProgress };
}

export interface TDeployStatusDetails_RevisionsEntry {
   key: number;
   value: TDeployProgress | undefined;
}

export interface TDeployStatusDetails_MappedRevisionsEntry {
   key: string;
   value: TDeployProgress | undefined;
}

export interface TClusterDeployStatus {
   details: TDeployStatusDetails | undefined;
   pod_set_id: string;
}

export interface TPodTemplateSpec {
   spec: TPodSpec | undefined;
   labels: TAttributeDictionary | undefined;
   annotations: TAttributeDictionary | undefined;
}

/**
 *  Identity is value-based - two descriptions are same if all their fields are equal.
 */
export interface TDockerImageDescription {
   /**
    *  Docker registry host name, defaults to "registry.yandex.net".
    */
   registry_host: string;
   /**
    *  Image name, for example, "search/ubuntu".
    */
   name: string;
   /**
    *  Image tag, for example, "1.189".
    */
   tag: string;
   /**
    *  Image digest, for example, "sha256:cbbf2f9a99b47fc460d422812b6a5adff7dfee951d8fa2e4a98caa0382cfbdbf".
    */
   digest: string;
}
