/* eslint-disable */
import { TCondition } from '../../../../../yp_proto/yp/client/api/proto/conditions';

/**
 * DPAT_NONE -  NONE action. Nothing actions are performed.
 *
 * DPAT_COMMIT -  Commit patch. No actions can be performed after commit.
 *
 * DPAT_SKIP -  Skip patch. Patch will no be applied.
 *  No actions can be performed after skip.
 *
 * DPAT_ON_HOLD -  Put patch on hold.
 *
 * DPAT_WAIT -  Wait for other patches to apply.
 *
 */
export enum EDeployPatchActionType {
   DPAT_NONE = 'none',
   DPAT_COMMIT = 'commit',
   DPAT_SKIP = 'skip',
   DPAT_ON_HOLD = 'on_hold',
   DPAT_WAIT = 'wait',
}

export interface TStaticResourceRef {
   /**
    *  Deploy unit where to patch static resource.
    */
   deploy_unit_id: string;
   static_resource_ref: string | undefined;
   layer_ref: string | undefined;
}

export interface TDynamicResourceRef {
   /**
    *  Dynamic resource spec where to patch url.
    */
   dynamic_resource_id: string;
   /**
    *  Deploy group in dynamic resource spec where to patch url.
    *  All urls in the first deploy group with equal mark will be replaced to
    *  url from release.
    */
   deploy_group_mark: string;
}

export interface TDockerImageRef {
   deploy_unit_id: string;
   /**
    *  Box id from deploy unit where to patch docker image.
    */
   box_id: string;
}

export interface TSandboxResourceDeployPatch {
   /**
    *  sandbox_resource_type and attributes are used to address resource from Sandbox release
    *  with which patch will be applied.
    */
   sandbox_resource_type: string;
   attributes: { [key: string]: string };
   /**
    *  static_resource_ref is used to address static resource in stage spec to patch.
    */
   static: TStaticResourceRef | undefined;
   /**
    *  dynamic_resource_ref is used to address url in dynamic resource spec to patch.
    */
   dynamic: TDynamicResourceRef | undefined;
}

export interface TSandboxResourceDeployPatch_AttributesEntry {
   key: string;
   value: string;
}

/**
 *  Message for filtering resources of one release and
 *  obtain subset of its resources
 */
export interface TSandboxResourceSelector {
   /**
    *  Will match only resources of one of the given types
    */
   sandbox_resource_types: string[];
   /**
    *  Selector that will match sandbox resource only if
    *  each key-value pair is presented in resource attributes
    */
   attributes: { [key: string]: string };
}

export interface TSandboxResourceSelector_AttributesEntry {
   key: string;
   value: string;
}

/**
 *  Message for filtering resources of one stage and
 *  obtain subset of its resources
 */
export interface TStaticResourceSelector {
   /**
    *  Will match only resources of given sandbox task type
    */
   task_type: string;
   /**
    *  Will match only resources of one of the given types
    */
   sandbox_resource_types: string[];
}

/**
 *  Used to address subset of resources to be patched
 */
export interface TStaticResourceBundleRef {
   deploy_unit_id: string;
   box_id: string;
   /**
    *  Where to mount resources inside box.
    *  E.g. if directory = "/data" and resource name is "chunk",
    *  this resource will be mounted to "/data/chunk"
    */
   directory: string;
   /**
    *  All sandbox resources matched by resource_selector
    *  will be replaced by new resources set
    */
   resource_selector: TStaticResourceSelector | undefined;
}

/**
 *  This patch will be applied to resource list of non-fixed size
 */
export interface TSandboxResourceBundleDeployPatch {
   resource_selector: TSandboxResourceSelector | undefined;
   /**
    *  Used to address static resources subset in stage spec to patch.
    */
   static: TStaticResourceBundleRef | undefined;
}

export interface TDockerImageDeployPatch {
   /**
    *  docker_image_ref is used to address boxes in stage spec
    *  where to patch docker image.
    */
   docker_image_ref: TDockerImageRef | undefined;
   /**
    *  Image name addresses image from Docker release
    *  with wich patch will be applied.
    */
   image_name: string;
}

export interface TDeployPatchSpec {
   sandbox: TSandboxResourceDeployPatch | undefined;
   docker: TDockerImageDeployPatch | undefined;
   resource_bundle: TSandboxResourceBundleDeployPatch | undefined;
}

export interface TDeployPatchProgress {
   /**
    *  Patch is not applied.
    */
   pending: TCondition | undefined;
   /**
    *  Patch was applied and deploy is in progress.
    */
   in_progress: TCondition | undefined;
   /**
    *  Patch was applied and deploy finished successfully.
    */
   success: TCondition | undefined;
   /**
    *  Patch was applied and deploy failed.
    */
   failed: TCondition | undefined;
   /**
    *  Patch was applied but deploy didn't finish (because of interrupt for example).
    */
   cancelled: TCondition | undefined;
   closed: TCondition | undefined;
   start_time: Date | { nanos: number; seconds: number } | undefined;
   end_time: Date | { nanos: number; seconds: number } | undefined;
   last_transition_time: Date | { nanos: number; seconds: number } | undefined;
}

export interface TDeployPatchAction {
   type: EDeployPatchActionType;
   /**
    *  One word (e.g. WAIT_FOR_OTHER_PATCH) for computers and short summary.
    */
   reason: string;
   /**
    *  Some human readable message.
    */
   message: string;
}

export interface TDeployPatchStatus {
   /**
    *  Patch progress. After applying patch this status will be setted
    *  by status of patched entity.
    */
   progress: TDeployPatchProgress | undefined;
   /**
    *  Any action on patch is performed by settings action.
    *  Examples:
    *  * setting action to COMMIT triggers committing (applying) patch to patched entity (DU or dynresource);
    *  * setting action to SKIP forbids any other actions on this patch.
    */
   action: TDeployPatchAction | undefined;
   /**
    *  Spec timestamp of stage when patch was committed.
    */
   stage_spec_timestamp: number;
}
