/* eslint-disable */
import {
   TDeployPatchSpec,
   TDeployPatchAction,
   TDeployPatchStatus,
} from '../../../../../yp_proto/yp/client/api/proto/deploy_patch';
import { TCondition } from '../../../../../yp_proto/yp/client/api/proto/conditions';
import {
   TAddDeployChild,
   TRemoveDeployChild,
   TAddSecretDelegation,
   TRemoveSecretDelegation,
} from '../../../../../yp_proto/yp/client/api/proto/deploy_control';

/**
 * DTPST_NONE -  None selector type.
 *
 * DTPST_FULL -  Full patch selector type.
 *
 * DTPST_PARTIAL -  Partial patch selector type. Need list of patches for action.
 *
 */
export enum EDeployTicketPatchSelectorType {
   DTPST_NONE = 'none',
   DTPST_FULL = 'full',
   DTPST_PARTIAL = 'partial',
}

/**
 *  for field descriptions see NYP.NClient.NApi.NProto.TDeployTicketMeta
 */
export interface TDeployTicketMetaBase {
   /**
    *  Id of parent stage.
    */
   stage_id: string;
}

export interface TDeployTicketSpec {
   /**
    *  Describes the way that ticket was created:
    *  * if ticket was created by release integration then fields
    *    stage_draft_id and stage_draft_revision are ignored;
    *  * if ticket was created by stage_draft then fields
    *    patches, release_id and release_rule_id are ignored.
    */
   source_type: TDeployTicketSpec_EDeployTicketSourceType;
   /**
    *  Patches describe how to patch stage spec or dynamic resource spec
    *  with release data. Copied from release rule.
    *  <patch id> -> <patch spec>.
    */
   patches: { [key: string]: TDeployPatchSpec };
   /**
    *  Ticket title. Used for displaying in tickets list.
    */
   title: string;
   /**
    *  Ticket description. Used for displaying on ticket page.
    */
   description: string;
   /**
    *  Users who recieve notifications on ticket status change.
    */
   responsibles: string[];
   /**
    *  Release by which ticket was created.
    */
   release_id: string;
   /**
    *  Release rule which was matched with release to create ticket.
    */
   release_rule_id: string;
   /**
    *  Recipe which will be applied to commit ticket. Copied from release rule.
    */
   recipe_id: string;
   /**
    *  Pair (stage_draft_id, stage_draft_revision) refers to particular draft revision.
    */
   stage_draft_id: string;
   stage_draft_revision: number;
}

export enum TDeployTicketSpec_EDeployTicketSourceType {
   RELEASE_INTEGRATION = 'release_integration',
   STAGE_DRAFT = 'stage_draft',
}

export interface TDeployTicketSpec_PatchesEntry {
   key: string;
   value: TDeployPatchSpec | undefined;
}

export interface TDeployTicketProgress {
   /**
    *  It is true only if all patch statuses are pending.
    */
   pending: TCondition | undefined;
   /**
    *  It is true only if at least one patch status is in_progress.
    */
   in_progress: TCondition | undefined;
   /**
    *  It is true only if all patch statuses are success, failed or cancelled.
    */
   closed: TCondition | undefined;
   start_time: Date | { nanos: number; seconds: number } | undefined;
   end_time: Date | { nanos: number; seconds: number } | undefined;
   last_transition_time: Date | { nanos: number; seconds: number } | undefined;
}

export interface TApproval {
   status: TApproval_EApprovalStatus;
   /**
    *  Users who approved this ticket.
    */
   user_approvals: TApproval_TUserApproval[];
}

export enum TApproval_EApprovalStatus {
   NONE = 'none',
   NOT_APPROVED = 'not_approved',
   APPROVED = 'approved',
}

export interface TApproval_TUserApproval {
   login: string;
   status: TApproval_TUserApproval_EUserApprovalStatus;
   comment: string;
   approval_time: Date | { nanos: number; seconds: number } | undefined;
}

export enum TApproval_TUserApproval_EUserApprovalStatus {
   NONE = 'none',
   DISAPPROVED = 'disapproved',
   APPROVED = 'approved',
}

export interface TDeployTicketStatus {
   /**
    *  Ticket deploy status.
    */
   progress: TDeployTicketProgress | undefined;
   /**
    *  This action will be propagated to every patch status that has NONE action.
    */
   action: TDeployPatchAction | undefined;
   /**
    *  <patch id> -> <patch status>.
    *  Patches are ignored for tickets with draft source.
    */
   patches: { [key: string]: TDeployPatchStatus };
   approval: TApproval | undefined;
   /**
    *  Opaque value showing if the ticket can be commited. Must be requested explicitly, otherwise not shown.
    */
   can_commit: boolean;
}

export interface TDeployTicketStatus_PatchesEntry {
   key: string;
   value: TDeployPatchStatus | undefined;
}

export interface TDeployTicketControl {
   /**
    *  TODO(deep): extract nested messages and convert to ControlBase
    */
   add_deploy_child: TAddDeployChild | undefined;
   remove_deploy_child: TRemoveDeployChild | undefined;
   add_secret_delegation: TAddSecretDelegation | undefined;
   remove_secret_delegation: TRemoveSecretDelegation | undefined;
   skip: TDeployTicketControl_TSkipAction | undefined;
   commit: TDeployTicketControl_TCommitAction | undefined;
   approve: TDeployTicketControl_TApproveAction | undefined;
   disapprove: TDeployTicketControl_TDisapproveAction | undefined;
}

export interface TDeployTicketControl_TPatchSelector {
   type: EDeployTicketPatchSelectorType;
   patch_ids: string[];
}

export interface TDeployTicketControl_TActionOptions {
   patch_selector: TDeployTicketControl_TPatchSelector | undefined;
   message: string;
   reason: string;
}

export interface TDeployTicketControl_TApproveOptions {
   message: string;
}

export interface TDeployTicketControl_TDisapproveOptions {
   message: string;
}

export interface TDeployTicketControl_TSkipAction {
   options: TDeployTicketControl_TActionOptions | undefined;
}

export interface TDeployTicketControl_TCommitAction {
   options: TDeployTicketControl_TActionOptions | undefined;
   recipe_id: string;
}

export interface TDeployTicketControl_TApproveAction {
   options: TDeployTicketControl_TApproveOptions | undefined;
}

export interface TDeployTicketControl_TDisapproveAction {
   options: TDeployTicketControl_TDisapproveOptions | undefined;
}
