/* eslint-disable */

export interface TReqGetMasters {}

export interface TRspGetMasters {
   /**
    *  All known masters (both dead and alive).
    */
   master_infos: TRspGetMasters_TMasterInfo[];
   /**
    *  Globally-unique cluster tag.
    */
   cluster_tag: number;
}

export interface TRspGetMasters_TMasterInfo {
   /**
    *  FQDN without port.
    */
   fqdn: string;
   /**
    *  Resolved from FQDN.
    */
   ip6_address: string;
   /**
    *  FQDN + GRPC port.
    *  Can be passed to GRPC client to open a channel.
    */
   grpc_address: string;
   /**
    *  IP6 + GRPC port.
    */
   grpc_ip6_address: string;
   /**
    *  FQDN + HTTP port.
    *  Can be passed to HTTP client to open a channel.
    *  Note that HTTP transport is not available for agents.
    */
   http_address: string;
   /**
    *  IP6 + HTTP port.
    */
   http_ip6_address: string;
   /**
    *  Address of the collocated RPC proxy if configured.
    */
   rpc_proxy_address: string;
   rpc_proxy_ip6_address: string;
   /**
    *  Per-cluster unique master instance tag.
    */
   instance_tag: number;
   /**
    *  Is this master considered alive?
    *  If true the master is ready to serve the requests (both reads and writes).
    *  If false the master is not usable in any way.
    */
   alive: boolean;
   /**
    *  Is this master leading?
    *  Exactly one master is leading most of time.
    */
   leading: boolean;
}

export interface DiscoveryService {
   /**
    *  Retrieves the list of all master servers.
    */
   GetMasters(request: TReqGetMasters): Promise<TRspGetMasters>;
}
