/* eslint-disable */

export interface TDnsZoneSpec {
   /**
    *  Base DNS zones config is stored in *config* field. But any service can override
    *  some subset of fields of base config in the way they want via *overrides*.
    */
   config: TDnsZoneSpec_TDnsZoneConfig | undefined;
   overrides: { [key: string]: TDnsZoneSpec_TDnsZoneConfig };
}

/**
 *  Mostly copied from NYpDns.TZoneConfig:
 *  https://a.yandex-team.ru/arc/trunk/arcadia/infra/libs/yp_dns/zone/protos/config.proto
 */
export interface TDnsZoneSpec_TDnsZoneConfig {
   /**
    *  Default ttl for all records in zone.
    */
   default_records_ttl: number;
   /**
    *  DNS servers use SOA and NS records from dns_record_set object. But if there are
    *  no such records in record sets they use default SOA and NS records from here.
    */
   default_soa_record: TDnsZoneSpec_TDnsZoneConfig_TRecord | undefined;
   default_ns_records: TDnsZoneSpec_TDnsZoneConfig_TRecord[];
   /**
    *  Describes the way the dns_record_sets belonging to this zone are stored in YP clusters.
    */
   store_config: TDnsZoneSpec_TDnsZoneConfig_TStoreConfig | undefined;
   response_policy: TDnsZoneSpec_TDnsZoneConfig_TResponsePolicy | undefined;
   backend_store_policy: TDnsZoneSpec_TDnsZoneConfig_TBackendStoreRecordsPolicy | undefined;
   transfer_config: TDnsZoneSpec_TDnsZoneConfig_TTransferConfig | undefined;
   serial_generate_mode: TDnsZoneSpec_TDnsZoneConfig_ESerialNumberGenerateMode;
}

/**
 * ORIGINAL -  Use serial number that is stored in record.
 *
 * YP_TIMESTAMP_BASED -  Generate serial number based on YP clusters timestamps. Default in DNS.
 *
 */
export enum TDnsZoneSpec_TDnsZoneConfig_ESerialNumberGenerateMode {
   NONE = 'none',
   ORIGINAL = 'original',
   YP_TIMESTAMP_BASED = 'yp_timestamp_based',
}

export interface TDnsZoneSpec_TDnsZoneConfig_TRecord {
   ttl: number;
   class: string;
   SOA: TDnsZoneSpec_TDnsZoneConfig_TRecord_TSOAContent | undefined;
   NS: TDnsZoneSpec_TDnsZoneConfig_TRecord_TNSContent | undefined;
}

export interface TDnsZoneSpec_TDnsZoneConfig_TRecord_TSOAContent {
   primary_nameserver: string;
   email: string;
   serial: number;
   refresh: number;
   retry: number;
   expire: number;
   negative_ttl: number;
}

export interface TDnsZoneSpec_TDnsZoneConfig_TRecord_TNSContent {
   nameserver: string;
}

export interface TDnsZoneSpec_TDnsZoneConfig_TStoreConfig {
   clusters: string[];
   algorithm: string;
}

export interface TDnsZoneSpec_TDnsZoneConfig_TResponsePolicy {
   /**
    *  Default policy options for all record types.
    */
   default: TDnsZoneSpec_TDnsZoneConfig_TResponsePolicy_TOptions | undefined;
   /**
    *  Policy options below specify response policies for corresponding record types.
    */
   A: TDnsZoneSpec_TDnsZoneConfig_TResponsePolicy_TOptions | undefined;
   NS: TDnsZoneSpec_TDnsZoneConfig_TResponsePolicy_TOptions | undefined;
   CNAME: TDnsZoneSpec_TDnsZoneConfig_TResponsePolicy_TOptions | undefined;
   /**
    *  For SOA max_records_number can not be larger than 1.
    *  In DNS default for SOA is {order: SEQUENTIAL, max_records_number: 1}
    */
   SOA: TDnsZoneSpec_TDnsZoneConfig_TResponsePolicy_TOptions | undefined;
   PTR: TDnsZoneSpec_TDnsZoneConfig_TResponsePolicy_TOptions | undefined;
   TXT: TDnsZoneSpec_TDnsZoneConfig_TResponsePolicy_TOptions | undefined;
   AAAA: TDnsZoneSpec_TDnsZoneConfig_TResponsePolicy_TOptions | undefined;
   SRV: TDnsZoneSpec_TDnsZoneConfig_TResponsePolicy_TOptions | undefined;
}

export interface TDnsZoneSpec_TDnsZoneConfig_TResponsePolicy_TOptions {
   order: TDnsZoneSpec_TDnsZoneConfig_TResponsePolicy_TOptions_EOrder;
   /**
    *  Unlimited if not given
    */
   max_records_number: number;
}

/**
 * SEQUENTIAL -  Arranges records in response in the same order in which they are stored.
 *
 * RANDOM -  Randomly shuffles records in response.
 *
 */
export enum TDnsZoneSpec_TDnsZoneConfig_TResponsePolicy_TOptions_EOrder {
   NONE = 'none',
   SEQUENTIAL = 'sequential',
   RANDOM = 'random',
}

export interface TDnsZoneSpec_TDnsZoneConfig_TBackendStoreRecordsPolicy {
   /**
    *  Default policy options for all record types.
    */
   default: TDnsZoneSpec_TDnsZoneConfig_TBackendStoreRecordsPolicy_TOptions | undefined;
   /**
    *  Policy options below specify store policies for corresponding record types.
    */
   A: TDnsZoneSpec_TDnsZoneConfig_TBackendStoreRecordsPolicy_TOptions | undefined;
   NS: TDnsZoneSpec_TDnsZoneConfig_TBackendStoreRecordsPolicy_TOptions | undefined;
   CNAME: TDnsZoneSpec_TDnsZoneConfig_TBackendStoreRecordsPolicy_TOptions | undefined;
   SOA: TDnsZoneSpec_TDnsZoneConfig_TBackendStoreRecordsPolicy_TOptions | undefined;
   PTR: TDnsZoneSpec_TDnsZoneConfig_TBackendStoreRecordsPolicy_TOptions | undefined;
   TXT: TDnsZoneSpec_TDnsZoneConfig_TBackendStoreRecordsPolicy_TOptions | undefined;
   AAAA: TDnsZoneSpec_TDnsZoneConfig_TBackendStoreRecordsPolicy_TOptions | undefined;
   SRV: TDnsZoneSpec_TDnsZoneConfig_TBackendStoreRecordsPolicy_TOptions | undefined;
}

export interface TDnsZoneSpec_TDnsZoneConfig_TBackendStoreRecordsPolicy_TOptions {
   order: TDnsZoneSpec_TDnsZoneConfig_TBackendStoreRecordsPolicy_TOptions_EOrder;
   /**
    *  Unlimited if not given
    */
   max_records_number: number;
}

/**
 * ORIGINAL -  Stores records in the order in which they are stored in YP.
 *
 * RANDOM -  Randomly shuffles records.
 *
 */
export enum TDnsZoneSpec_TDnsZoneConfig_TBackendStoreRecordsPolicy_TOptions_EOrder {
   NONE = 'none',
   ORIGINAL = 'original',
   RANDOM = 'random',
}

export interface TDnsZoneSpec_TDnsZoneConfig_TTransferConfig {
   enabled: boolean;
   axfr_allow_list: string[];
   notify_addresses: string[];
}

export interface TDnsZoneSpec_OverridesEntry {
   key: string;
   value: TDnsZoneSpec_TDnsZoneConfig | undefined;
}

export interface TDnsZoneStatus {}
