/* eslint-disable */
import { TAttributeDictionary } from '../../../../../yt_proto/yt/core/ytree/proto/attributes';
import { TPodDynamicResourceSpec_TStorageOptions } from '../../../../../yp_proto/yp/client/api/proto/data_model';
import { TAggregatedCondition } from '../../../../../yp_proto/yp/client/api/proto/conditions';

/**
 *  For field descriptions see NYP.NClient.NApi.NProto.TSchemaMeta.
 */
export interface TDynamicResourceMetaBase {
   /**
    *  Id of pod_set where to deploy the resource.
    */
   pod_set_id: string;
}

export interface TDynamicResourceSpec {
   /**
    *  Resource revision, server-side incremented sequence, monotonic.
    */
   revision: number;
   deploy_groups: TDynamicResourceSpec_DeployGroup[];
   /**
    *  Size of the update window in pods.
    */
   update_window: number;
}

/**
 *  Specification group, describing resource deploy rules for a part
 *  of pod_set filtered by a set of labels.
 */
export interface TDynamicResourceSpec_DeployGroup {
   /**
    *  Short label to describe the deploy group.
    */
   mark: string;
   /**
    *  Conjunction of labels required for this deploy group to be applied.
    *  Note, that if one pod matches more than one deploy groups, neither
    *  one will be applied, since such configuration appears to be ambigous
    *  and invalid.
    *  Empty map matches every single pod in pod_set.
    */
   required_labels: TAttributeDictionary | undefined;
   /**
    *  Urls where to download the resource from
    *  supported protocols: http, https, rbtorrent, raw
    *  (for raw resources use "raw:data").
    *  Urls are tried in order until successful download.
    */
   urls: string[];
   /**
    *  Options how to handle resource inside the box.
    */
   storage_options: TPodDynamicResourceSpec_TStorageOptions | undefined;
}

export interface TDynamicResourceStatus {
   revisions: TDynamicResourceStatus_TRevisionStatus[];
}

export interface TDynamicResourceStatus_TRevisionStatus {
   /**
    *  Revision id
    */
   revision: number;
   /**
    *  Short label describing deploy group.
    */
   mark: string;
   /**
    *  Amount of pods where this revision is active.
    */
   ready: TAggregatedCondition | undefined;
   /**
    *  Amount of pods where this revision is currently updating.
    */
   in_progress: TAggregatedCondition | undefined;
   /**
    *  Amount of pods where resource update failed on installing this revision.
    */
   error: TAggregatedCondition | undefined;
}
