/* eslint-disable */
import { Duration } from '../../../../../google/protobuf/duration';
import { TCondition } from '../../../../../yp_proto/yp/client/api/proto/conditions';

export interface THorizontalPodAutoscalerMetaBase {
   replica_set_id: string | undefined;
}

/**
 *  Autoscaler will use pod average cpu usage (currently - for last 5 min) as a metric
 *  yasm signal: havg(portoinst-cpu_usage_slot_hgram)
 */
export interface TCPUMetricSpec {
   /**
    *  Target interval of cpu usage.
    *  Autoscaler will skip scaling if:
    *  current_metric ∈ [lower_bound, upper_bound]
    *  Scale: cores - same as signal havg(portoinst-cpu_usage_slot_hgram)
    *  Validation: lower_bound <= upper_bound
    */
   lower_bound: number;
   upper_bound: number;
}

/**
 *  Autoscaler will use pod average cpu usage (currently - for last 5 min) as a metric
 *  yasm signal: havg(portoinst-cpu_limit_usage_perc_hgram)
 */
export interface TCPUUtilizationMetricSpec {
   /**
    *  Target interval of cpu usage in percent.
    *  Autoscaler will skip scaling if:
    *  current_metric ∈ [lower_bound_percent, upper_bound_percent]
    *  Scale: cores in percent - same as signal havg(portoinst-cpu_limit_usage_perc_hgram)
    *  Validation: lower_bound_percent <= upper_bound_percent and lower_bound_percent, upper_bound_percent ∈ [0, 100]
    */
   lower_bound_percent: number;
   upper_bound_percent: number;
   /**
    *  Validation: period ∈ {5s, 5m, 1h, 3h, 6h, 12h, 1d}
    *  Default: 5 min (may change)
    */
   period: Duration | undefined;
}

/**
 *  yasm signal: golovan_signal.signal
 */
export interface TCustomMetricSpec {
   golovan_signal: TCustomMetricSpec_TGolovanSignal | undefined;
   solomon_signal: TCustomMetricSpec_TSolomonSignal | undefined;
   /**
    *  Target interval of metric.
    *  Autoscaler will skip scaling if:
    *  current_metric ∈ [lower_bound, upper_bound]
    *  Validation: lower_bound <= upper_bound
    */
   lower_bound: number;
   upper_bound: number;
}

export interface TCustomMetricSpec_TGolovanSignal {
   signal: string;
   tags: { [key: string]: string };
   period: TCustomMetricSpec_TGolovanSignal_EGolovanPeriod;
   /**
    *  if true then Golovan request will contain 'geo=<YP_CLUSTER>' tag
    */
   set_local_geo_tag: boolean;
   host: string;
}

/**
 * GP_DEFAULT -  Used five_min as default
 *
 */
export enum TCustomMetricSpec_TGolovanSignal_EGolovanPeriod {
   GP_DEFAULT = 'default',
   GP_FIVE_SEC = 'five_sec',
   GP_FIVE_MIN = 'five_min',
   GP_ONE_HOUR = 'one_hour',
   GP_THREE_HOURS = 'three_hours',
   GP_SIX_HOURS = 'six_hours',
   GP_TWELVE_HOURS = 'twelve_hours',
   GP_ONE_DAY = 'one_day',
}

export interface TCustomMetricSpec_TGolovanSignal_TagsEntry {
   key: string;
   value: string;
}

export interface TCustomMetricSpec_TSolomonSignal {
   project: string;
   cluster: string;
   service: string;
   host: string;
   sensor: string | undefined;
   path: string | undefined;
   /**
    *  Default: 5 min (may change)
    */
   period: Duration | undefined;
   aggregation: TCustomMetricSpec_TSolomonSignal_EAggregationType;
   advanced_attributes: { [key: string]: string };
}

export enum TCustomMetricSpec_TSolomonSignal_EAggregationType {
   AT_UNKNOWN = 'unknown',
   AT_AVG = 'avg',
   AT_MAX = 'max',
   AT_MIN = 'min',
   AT_SUM = 'sum',
   AT_LAST = 'last',
}

export interface TCustomMetricSpec_TSolomonSignal_AdvancedAttributesEntry {
   key: string;
   value: string;
}

/**
 *  Note that autoscaler does not change replica_set.deployment_strategy (max_unavailable pod count).
 */
export interface TReplicaSetScaleSpec {
   /**
    *  Lower limit for the number of replicas to which the autoscaler can scale down.
    *  Validation: zero value is accepted only if max_replicas is zero
    */
   min_replicas: number;
   /**
    *  Upper limit for the number of replicas to which the autoscaler can scale up.
    *  Validation - it cannot be less that min_replicas.
    */
   max_replicas: number;
   /**
    *  deprecated in favor of cpu_utilization
    */
   cpu: TCPUMetricSpec | undefined;
   cpu_utilization: TCPUUtilizationMetricSpec | undefined;
   custom: TCustomMetricSpec | undefined;
   /**
    *  The period since last upscale, before another upscale can be performed in horizontal pod autoscaler.
    *  Metric upscale reaction time should be less than specified delay.
    *  Otherwise autoscaler would perform several consecutive upscales which may lead to quota shortage.
    *  Validation: not less that 5 min
    *  Default: 30 min (may change)
    */
   upscale_delay: Duration | undefined;
   /**
    *  The period since last downscale, before another downscale can be performed in horizontal pod autoscaler.
    *  Metric downscale reaction time should be less than specified delay.
    *  Otherwise autoscaler would perform several consecutive downscales which may lead to service degradation.
    *  Validation: not less that 5 min
    *  Default: 60 min (may change)
    */
   downscale_delay: Duration | undefined;
}

export interface THorizontalPodAutoscalerSpec {
   replica_set: TReplicaSetScaleSpec | undefined;
}

export interface TReplicaSetScaleStatus {
   /**
    *  Current number of replicas of pods managed by this autoscaler, as last seen by the autoscaler.
    */
   current_replicas: number;
   /**
    *  The desired number of replicas of pods managed by this autoscaler, as last calculated by the autoscaler.
    */
   desired_replicas: number;
   /**
    *  The last read state of the metric used by this autoscaler.
    */
   metric_value: number;
   /**
    *  The last times autoscaler scaled the number of pods.
    *  Used by the autoscaler to control how often the number of pods is changed.
    */
   last_upscale_time: Date | { nanos: number; seconds: number } | undefined;
   last_downscale_time: Date | { nanos: number; seconds: number } | undefined;
}

export interface THorizontalPodAutoscalerStatus {
   /**
    *  Set of confiditons according to https://wiki.yandex-team.ru/deploy/for-deploy-developers/errorLogging/#conditions
    *  current_replicas is equal to desired_replicas and replica_set is ready.
    */
   ready: TCondition | undefined;
   /**
    *  Changing replicas count is in progress.
    */
   in_progress: TCondition | undefined;
   /**
    *  Some failure happened during evaluating metric or pushing new replica count.
    */
   failed: TCondition | undefined;
   replica_set: TReplicaSetScaleStatus | undefined;
   /**
    *  YP timestamp of THorizontalPodAutoscalerSpec, as last seen by the autoscaler.
    */
   spec_timestamp: number;
}
