/* eslint-disable */

/**
 *  User workload with unistat endpoint.
 */
export interface TMonitoringUnistatEndpoint {
   port: number;
   /**
    *  Relative HTTP path to unistat handle.
    */
   path: string;
   /**
    *  Prefix for signal names, default is unistat.
    */
   prefix: string;
   /**
    *  Tags for this endpoint.
    *  If a value in TMonitoringInfo.labels with same key exists, it will be overridden.
    */
   labels: { [key: string]: string };
   /**
    *  Workload in pod which provides this endpoint.
    */
   workload_id: string;
   /**
    *  Allow to collect porto metrics for workload
    */
   allow_porto_metrics: boolean;
   output_format: TMonitoringUnistatEndpoint_EOutputFormat;
   inherit_missed_labels: boolean;
}

export enum TMonitoringUnistatEndpoint_EOutputFormat {
   OF_UNKNOWN = 'unknown',
   OF_YASM_JSON = 'yasm_json',
   OF_YASM_PROTO = 'yasm_proto',
   OF_SOLOMON = 'solomon',
}

export interface TMonitoringUnistatEndpoint_LabelsEntry {
   key: string;
   value: string;
}

export interface TMonitoringWorkloadEndpoint {
   /**
    *  Workload-wide yasm tags for signals.
    *  User-defined tags for deploy unit are stored here and then
    *  Deploy system tags are added by parts of Deploy stack
    *  until they arrive on node agent as part of pod spec.
    *  See https://wiki.yandex-team.ru/deploy/docs/stage/nastrojjka-postavki-metrik-v-yasm/#system-tags
    *  for list of Deploy tags.
    */
   labels: { [key: string]: string };
   workload_id: string;
   inherit_missed_labels: boolean;
}

export interface TMonitoringWorkloadEndpoint_LabelsEntry {
   key: string;
   value: string;
}

/**
 *  Subagent inside pod.
 *  https://wiki.yandex-team.ru/golovan/yasmagent/subagent/
 */
export interface TMonitoringSubagentEndpoint {
   port: number;
   path: string;
}

export interface TPodAgentMonitoringSpec {
   /**
    *  Pod-wide yasm tags for signals.
    *  User-defined tags for deploy unit are stored here and then
    *  Deploy system tags are added by parts of Deploy stack
    *  until they arrive on node agent as part of pod spec.
    *  See https://wiki.yandex-team.ru/deploy/docs/stage/nastrojjka-postavki-metrik-v-yasm/#system-tags
    *  for list of Deploy tags.
    */
   labels: { [key: string]: string };
   add_pod_agent_user_signals: boolean;
}

export interface TPodAgentMonitoringSpec_LabelsEntry {
   key: string;
   value: string;
}

export interface TMonitoringInfo {
   unistats: TMonitoringUnistatEndpoint[];
   yasm_subagents: TMonitoringSubagentEndpoint[];
   juggler_subagents: TMonitoringSubagentEndpoint[];
   /**
    *  Pod-wide yasm tags for signals.
    *  User-defined tags for deploy unit are stored here and then
    *  Deploy system tags are added by parts of Deploy stack
    *  until they arrive on node agent as part of pod spec.
    *  See https://wiki.yandex-team.ru/deploy/docs/stage/nastrojjka-postavki-metrik-v-yasm/#system-tags
    *  for list of Deploy tags.
    */
   labels: { [key: string]: string };
   pod_agent: TPodAgentMonitoringSpec | undefined;
   workloads: TMonitoringWorkloadEndpoint[];
}

export interface TMonitoringInfo_LabelsEntry {
   key: string;
   value: string;
}

export interface THostInfraInfo {
   monitoring: TMonitoringInfo | undefined;
}
