/* eslint-disable */
import {
   TPodTemplateSpec,
   TDeploySpeed,
   TDeployReadyCriterion,
   TDeployStatusDetails,
   TClusterDeployStatus,
   TDeployProgress,
} from '../../../../../yp_proto/yp/client/api/proto/deploy';
import { TAntiaffinityConstraint } from '../../../../../yp_proto/yp/client/api/proto/data_model';
import { TCondition } from '../../../../../yp_proto/yp/client/api/proto/conditions';

export interface TMultiClusterReplicaSetSpec {
   revision: number;
   account_id: string;
   pod_template_spec: TPodTemplateSpec | undefined;
   deployment_strategy: TMultiClusterReplicaSetSpec_TDeploymentStrategy | undefined;
   clusters: TMultiClusterReplicaSetSpec_TClusterReplicaSetSpecPreferences[];
   node_segment_id: string;
}

export interface TMultiClusterReplicaSetSpec_TConstraints {
   antiaffinity_constraints: TAntiaffinityConstraint[];
}

export interface TMultiClusterReplicaSetSpec_TDeploymentStrategy {
   max_unavailable: number;
   /**
    *  Minimum number of seconds after pod creation to be considered available.
    */
   min_created_seconds: number;
   /**
    *  Max allowed hardware maintenance duration in seconds during which pods may be unavailable
    */
   max_tolerable_downtime_seconds: number;
   /**
    *  max_unavailable analogue, but only for eviction/maintenance-related unavailability
    */
   max_tolerable_downtime_pods: number;
   /**
    *  Describes how many pods to update at a time and min delay between updates.
    */
   deploy_speed: TDeploySpeed | undefined;
   /**
    *  Conditions which determine if replica set is ready.
    */
   ready_criterion: TDeployReadyCriterion | undefined;
}

export interface TMultiClusterReplicaSetSpec_TReplicaSetSpecPreferences {
   replica_count: number;
   constraints: TMultiClusterReplicaSetSpec_TConstraints | undefined;
}

export interface TMultiClusterReplicaSetSpec_TClusterReplicaSetSpecPreferences {
   cluster: string;
   spec: TMultiClusterReplicaSetSpec_TReplicaSetSpecPreferences | undefined;
}

export interface TMultiClusterDeployStatus {
   details: TDeployStatusDetails | undefined;
   pods_unavailable: number;
}

export interface TMultiClusterReplicaSetStatus {
   total_summary: TMultiClusterReplicaSetStatus_TPodsSummary | undefined;
   current_revision_summary: TMultiClusterReplicaSetStatus_TPodsSummary | undefined;
   revisions: { [key: number]: TMultiClusterReplicaSetStatus_TPodsSummary };
   controller_status: TMultiClusterReplicaSetStatus_TControllerStatus | undefined;
   pods_unavailable: number;
   revision: number;
   in_progress: TCondition | undefined;
   ready: TCondition | undefined;
   failed: TCondition | undefined;
   multi_cluster_deploy_status: TMultiClusterDeployStatus | undefined;
   /**
    *  Legacy attribute, use mapped_cluster_deploy_statuses instead.
    */
   cluster_deploy_statuses: { [key: string]: TClusterDeployStatus };
   mapped_cluster_deploy_statuses: { [key: string]: TClusterDeployStatus };
}

export interface TMultiClusterReplicaSetStatus_TControllerAttempt {
   clusters_succeeded: { [key: string]: TCondition };
   multi_cluster_succeeded: TCondition | undefined;
}

export interface TMultiClusterReplicaSetStatus_TControllerAttempt_ClustersSucceededEntry {
   key: string;
   value: TCondition | undefined;
}

export interface TMultiClusterReplicaSetStatus_TControllerStatus {
   last_attempt: TMultiClusterReplicaSetStatus_TControllerAttempt | undefined;
}

export interface TMultiClusterReplicaSetStatus_TPodsSummary {
   multi_cluster_progress: TDeployProgress | undefined;
   clusters_progress: { [key: string]: TDeployProgress };
}

export interface TMultiClusterReplicaSetStatus_TPodsSummary_ClustersProgressEntry {
   key: string;
   value: TDeployProgress | undefined;
}

export interface TMultiClusterReplicaSetStatus_RevisionsEntry {
   key: number;
   value: TMultiClusterReplicaSetStatus_TPodsSummary | undefined;
}

export interface TMultiClusterReplicaSetStatus_ClusterDeployStatusesEntry {
   key: string;
   value: TClusterDeployStatus | undefined;
}

export interface TMultiClusterReplicaSetStatus_MappedClusterDeployStatusesEntry {
   key: string;
   value: TClusterDeployStatus | undefined;
}
