/* eslint-disable */

export interface TNotificationPolicyMetaBase {
   /**
    *  Id of parent stage. Must be equal to id of the object.
    */
   stage_id: string;
}

export interface TNotificationPolicySpec {
   /**
    *  Actions to perform for any stage deploy actions.
    */
   stage_actions: TNotificationPolicySpec_TRule | undefined;
   /**
    *  Actions to perform for deploy units.
    */
   deploy_unit_actions: { [key: string]: TNotificationPolicySpec_TRule };
   /**
    *  Actions to perform for dynamic resources.
    */
   dynamic_resource_actions: { [key: string]: TNotificationPolicySpec_TRule };
   /**
    *  Optional binding to infra.yandex-team.ru.
    *  If specified, all deploy actions will result in minor maintenance event created
    *  in the infra environment specified.
    */
   infra_settings: TNotificationPolicySpec_TInfraSettings | undefined;
}

export interface TNotificationPolicySpec_TAction {
   http_action: TNotificationPolicySpec_TAction_THttpAction | undefined;
   jns_message: TNotificationPolicySpec_TAction_TJNSMessage | undefined;
}

export interface TNotificationPolicySpec_TAction_THttpAction {
   /**
    *  Url to POST.
    */
   url: string;
   /**
    *  Maximum number of attempts to POST the url.
    *  Successful attempt is the one that returns HTTP code: 200 <= code < 300
    *  By default equals to 3. Cannot be greater than 3.
    */
   attempts: number;
}

export interface TNotificationPolicySpec_TAction_TJNSMessage {
   /**
    *  Project ID in jns.yandex-team.ru
    */
   project: string;
   /**
    *  Channel ID in jns.yandex-team.ru
    */
   channel: string;
}

export interface TNotificationPolicySpec_TRule {
   /**
    *  Action to perform when deploy started.
    */
   start_actions: TNotificationPolicySpec_TAction[];
   /**
    *  Action to perform when deploy finished.
    */
   finish_actions: TNotificationPolicySpec_TAction[];
}

export interface TNotificationPolicySpec_TInfraSettings {
   /**
    *  Service ID in infra.yandex-team.ru
    */
   infra_service: number;
   /**
    *  Environment ID in infra.yandex-team.ru
    */
   infra_environment: number;
}

export interface TNotificationPolicySpec_DeployUnitActionsEntry {
   key: string;
   value: TNotificationPolicySpec_TRule | undefined;
}

export interface TNotificationPolicySpec_DynamicResourceActionsEntry {
   key: string;
   value: TNotificationPolicySpec_TRule | undefined;
}

export interface TNotificationPolicyStatus {}
