/* eslint-disable */
import { EObjectType } from '../../../../../yp_proto/yp/client/api/proto/autogen';
import {
   EAccessControlPermission,
   EAccessControlAction,
} from '../../../../../yp_proto/yp/client/api/proto/access_control';
import { Duration } from '../../../../../google/protobuf/duration';

/**
 *  Describes the desired format of TPayload.
 * PF_NONE -  Indicates a legacy client that is not aware of formats.
 *
 */
export enum EPayloadFormat {
   PF_NONE = 0,
   PF_YSON = 1,
   PF_PROTOBUF = 2,
}

export enum EEventType {
   ET_OBJECT_NONE = 'none',
   ET_OBJECT_CREATED = 'object_created',
   ET_OBJECT_REMOVED = 'object_removed',
   ET_OBJECT_UPDATED = 'object_updated',
}

/**
 *  Description: https://yt.yandex-team.ru/docs/api/commands#lock_rows.
 */
export enum ELockType {
   LT_NONE = 'none',
   LT_SHARED_WEAK = 'shared_weak',
   LT_SHARED_STRONG = 'shared_strong',
   LT_EXCLUSIVE = 'exclusive',
}

export enum ESelectObjectHistoryIndexMode {
   HIM_DEFAULT = 'default',
   HIM_ENABLED = 'enabled',
   HIM_DISABLED = 'disabled',
}

/**
 *  Represents a polymorphic payload.
 */
export interface TPayload {
   null: boolean | undefined;
   yson: Uint8Array | undefined;
   protobuf: Uint8Array | undefined;
}

export interface TTransactionContext {
   items: TTransactionContext_TItem[];
}

export interface TTransactionContext_TItem {
   key: string;
   value: string;
}

export interface TEvent {
   /**
    *  The timestamp of the event.
    */
   timestamp: number;
   /**
    *  Event type.
    */
   event_type: EEventType;
   /**
    *  Object id (serialized object key, actually).
    *  Deprecated, switch to using meta in a format of your choice.
    */
   object_id: string;
   /**
    *  Metadata of the object, if requested.
    */
   meta: TPayload | undefined;
   /**
    *  Transaction context (see TReqCommitTransaction).
    */
   transaction_context: TTransactionContext | undefined;
   /**
    *  Each character of the summary corresponds to one attribute.
    *  Values: 'u' (unknown), 't' (true), 'f' (false).
    *  True means the attribute was definitely affected.
    *  False means it was definitely not affected.
    *  Unknown means there is no information either way.
    */
   changed_attributes_summary: string;
}

export interface TCommonRequestOptions {
   /**
    *  If true then method call returns performance statistics.
    */
   fetch_performance_statistics: boolean;
   /**
    *  Overrides default ORM option and allows underlying storage to perform full scan.
    */
   allow_full_scan: boolean;
}

export interface TPerformanceStatistics {
   /**
    *  Number of DB read phases during the execution.
    *  Each phase consists of a number of read requests executed simultaneously.
    */
   read_phase_count: number;
}

export interface TAttributeSelector {
   /**
    *  YPaths of requested attributes.
    */
   paths: string[];
}

export interface TAttributeList {
   /**
    *  COMPAT(babenko): deprecated; use value_payloads instead.
    *  Values are in YSON; nulls are encoded as empty strings.
    *  Value order coincides with that of TAttributeSelector.paths.
    */
   values: Uint8Array[];
   /**
    *  Contains single element if TGetObjectOptions.fetch_root_object is true.
    *  Otherwise contains one element per every TAttributeSelector.path in the same order if fetch_values is true.
    *  Otherwise contains no element.
    */
   value_payloads: TPayload[];
   /**
    *  Timestamp order coincides with that of TAttributeSelector.paths.
    *  Empty if TGetObjectOptions.fetch_timestamps is false.
    */
   timestamps: number[];
}

export interface TObjectFilter {
   /**
    *  Textual query string (YP dialect).
    */
   query: string;
}

export interface TSelectLimit {
   /**
    *  Maximum number of results to fetch.
    */
   value: number;
}

export interface TSelectOffset {
   /**
    *  Number of leading results to skip.
    */
   value: number;
}

export interface TSetUpdate {
   /**
    *  YPath pointing to the attribute to set.
    */
   path: string;
   /**
    *  COMPAT(babenko): deprecated; use value_payload instead.
    *  Attribute value; in YSON.
    */
   value: Uint8Array;
   /**
    *  Attribute value.
    */
   value_payload: TPayload | undefined;
   /**
    *  If true then missing intermediate nodes along the #path do not cause an error.
    */
   recursive: boolean;
}

export interface TSetRootUpdate {
   /**
    *  List of YPath pointing to the attributes to set.
    */
   paths: string[];
   /**
    *  Attribute value.
    */
   value_payload: TPayload | undefined;
   /**
    *  If true then missing intermediate nodes along the #path do not cause an error.
    */
   recursive: boolean;
}

export interface TRemoveUpdate {
   /**
    *  YPath pointing to the attribute to remove.
    */
   path: string;
   /**
    *  If true then missing intermediate nodes along the #path do not cause an error.
    */
   force: boolean;
}

export interface TLockUpdate {
   /**
    *  YPath pointing to the attribute to lock.
    */
   path: string;
   /**
    *  Lock type to use.
    */
   lock_type: ELockType;
}

export interface TAttributeTimestampPrerequisite {
   /**
    *  YPath pointing to the attribute to check.
    */
   path: string;
   /**
    *  For the prerequisite to succeed, the actual timestamp must not exceed this one.
    */
   timestamp: number;
}

export interface TReqGenerateTimestamp {}

export interface TRspGenerateTimestamp {
   /**
    *  A new (unique) timestamp.
    */
   timestamp: number;
}

export interface TReqStartTransaction {
   /**
    *  Provides snapshot isolation.
    *  If omitted then reads the latest state.
    */
   start_timestamp: number;
   /**
    *  If missing, master will start and manage its own underlying transaction.
    *
    *  Otherwise specifies id of an underlying transaction started via some RPC proxy,
    *  which can be collocated with master.
    *  Master will not own such transaction: in particular, upon CommitTransaction
    *  request master will just flush modifications into the transaction and will not commit the transaction,
    *  so the separate CommitTransaction request must be sent to the underlying transaction owner.
    *
    *  Useful for atomically applying changes to ORM and other underlying tables.
    */
   underlying_transaction_id: string;
   /**
    *  Network address of an underlying transaction owner.
    *  ORM master attaches to the transaction by the given address.
    *  If missing, master will try to attach to the collocated RPC proxy.
    */
   underlying_transaction_address: string;
   /**
    *  Common request options.
    */
   common_options: TCommonRequestOptions | undefined;
}

export interface TRspStartTransaction {
   /**
    *  Transaction id.
    */
   transaction_id: string;
   /**
    *  Start timestamp of the transaction.
    */
   start_timestamp: number;
   /**
    *  Start time of the transaction.
    *  Useful for indexing history by time (see history_time DB option).
    */
   start_time: Date | { nanos: number; seconds: number } | undefined;
}

/**
 *  NB! Underlying transaction will be committed only if it is owned by the master
 *      (TReqStartTransaction.underlying_transaction_id was empty).
 */
export interface TReqCommitTransaction {
   /**
    *  Transaction id.
    *  The request must be sent to the master owning the transacion.
    */
   transaction_id: string;
   /**
    *  Arbitrary context, which is written to watch logs and history.
    *  Useful for storing committer properties, e.g.: User-Agent header, IP address, user login.
    */
   transaction_context: TTransactionContext | undefined;
}

export interface TRspCommitTransaction {
   /**
    *  Commit timestamp of the transaction.
    *  Zero if the underlying transaction was not committed.
    */
   commit_timestamp: number;
   /**
    *  Start time of the commit.
    *  Useful for indexing history by time (see history_time DB option).
    */
   start_time: Date | { nanos: number; seconds: number } | undefined;
   /**
    *  End time of the commit.
    */
   finish_time: Date | { nanos: number; seconds: number } | undefined;
}

export interface TReqAbortTransaction {
   /**
    *  Transaction id.
    *  The request must be sent to the master owning the transacion.
    */
   transaction_id: string;
}

export interface TRspAbortTransaction {}

/**
 *  Parameters for updating an existing object in the context of a |Create| request ("Upsert").
 *  Contents are similar to the corresponding fields in |Update|.
 *  A message with empty contents simply prevents an exception in |Create|.
 */
export interface TUpdateIfExisting {
   /**
    *  Update these paths in the existing object.
    *  Values are taken from the corresponding paths in |attributes|, unless supplied directly in
    *  |set_updates| (for the case of setting a different value when creating vs. updating).
    */
   set_updates: TSetUpdate[];
   /**
    *  Same as |set_updates|, except |value_payload|, if present for the case of different values
    *  when creating vs. updating, is a partially-filled tree with the same root as |attributes|,
    *  instead of individual values. If a path is missing from |value_payload|, it will be picked
    *  up from |attributes|.
    */
   set_root_updates: TSetRootUpdate[];
   /**
    *  Remove these paths in the existing object.
    */
   remove_updates: TRemoveUpdate[];
   /**
    *  Lock these paths in the existing object.
    */
   lock_updates: TLockUpdate[];
}

export interface TReqCreateObject {
   /**
    *  Transaction id.
    *  If missing, just creates the object w/o any transaction.
    *  The request must be sent to the master owning the transacion.
    */
   transaction_id: string;
   /**
    *  Type of the object to create.
    */
   object_type: EObjectType;
   /**
    *  COMPAT(babenko): deprecated; use attributes_payload instead.
    *  Object attributes; in YSON.
    */
   attributes: Uint8Array;
   /**
    *  Object attributes.
    */
   attributes_payload: TPayload | undefined;
   /**
    *  Format to use in response. None will respond with object_id and fqid. Yson or proto will
    *  leave these empty and fill meta with /meta of the newly created object.
    */
   format: EPayloadFormat;
   /**
    *  If a matching object already exists (key fields must be supplied in attributes),
    *  update the existing object instead of failing.
    */
   update_if_existing: TUpdateIfExisting | undefined;
   /**
    *  Common request options.
    */
   common_options: TCommonRequestOptions | undefined;
}

export interface TRspCreateObject {
   /**
    *  Object id (filled if requested format is NONE and the object has a single string key).
    *  Deprecated, switch to using meta in a format of your choice.
    */
   object_id: string;
   /**
    *  Commit timestamp in case the request was issued outside of an explicit transaction.
    */
   commit_timestamp: number;
   /**
    *  Fqid of the newly created object (filled if requested format is NONE).
    *  Deprecated, switch to using meta in a format of your choice.
    */
   fqid: string;
   /**
    *  Metadata of the newly created object, if requested instead of separate fields.
    */
   meta: TPayload | undefined;
   /**
    *  Performance statistics for transparency if requested.
    */
   performance_statistics: TPerformanceStatistics | undefined;
}

export interface TReqCreateObjects {
   /**
    *  Transaction id.
    *  If missing, just creates the objects w/o any transaction.
    *  The request must be sent to the master owning the transacion.
    */
   transaction_id: string;
   /**
    *  Subrequests to serve.
    */
   subrequests: TReqCreateObjects_TSubrequest[];
   /**
    *  Format to use in response. None will respond with object_id and fqid. Yson or proto will
    *  leave these empty and fill meta with /meta of the newly created object.
    */
   format: EPayloadFormat;
   /**
    *  Common request options.
    */
   common_options: TCommonRequestOptions | undefined;
}

export interface TReqCreateObjects_TSubrequest {
   /**
    *  Type of the object to create.
    */
   object_type: EObjectType;
   /**
    *  COMPAT(babenko): deprecated; use attributes_payload instead.
    *  Object attributes; in YSON.
    */
   attributes: Uint8Array;
   /**
    *  Object attributes.
    */
   attributes_payload: TPayload | undefined;
   /**
    *  If a matching object already exists (key fields must be supplied in attributes),
    *  update the existing object instead of failing.
    */
   update_if_existing: TUpdateIfExisting | undefined;
}

export interface TRspCreateObjects {
   /**
    *  The i-th subresponse here contains the result for the i-th subrequest.
    */
   subresponses: TRspCreateObjects_TSubresponse[];
   /**
    *  Commit timestamp in case the request was issued outside of an explicit transaction.
    */
   commit_timestamp: number;
   /**
    *  Performance statistics for transparency if requested.
    */
   performance_statistics: TPerformanceStatistics | undefined;
}

export interface TRspCreateObjects_TSubresponse {
   /**
    *  Object id (filled if requested format is NONE and the object has a single string key).
    *  Deprecated, switch to using meta in a format of your choice.
    */
   object_id: string;
   /**
    *  Fqid of the newly created object (filled if requested format is NONE).
    *  Deprecated, switch to using meta in a format of your choice.
    */
   fqid: string;
   /**
    *  Metadata of the newly created object, if requested instead of separate fields.
    */
   meta: TPayload | undefined;
}

export interface TReqRemoveObject {
   /**
    *  Transaction id.
    *  If missing, just removes the object w/o any transaction.
    *  The request must be sent to the master owning the transacion.
    */
   transaction_id: string;
   /**
    *  Use exactly one of the two following fields.
    *  Id of the object to remove, if the type has a single string id field.
    */
   object_id: string;
   /**
    *  A subset of the object's /meta identifying the object to remove.
    */
   meta: TPayload | undefined;
   /**
    *  Type of the object to remove.
    */
   object_type: EObjectType;
   /**
    *  If false, fails with an error on nonexistent object.
    *  If true, ignores nonexistent object.
    */
   ignore_nonexistent: boolean;
   /**
    *  Common request options.
    */
   common_options: TCommonRequestOptions | undefined;
}

export interface TRspRemoveObject {
   /**
    *  Commit timestamp in case the request was issued outside of an explicit transaction.
    */
   commit_timestamp: number;
   /**
    *  Performance statistics for transparency if requested.
    */
   performance_statistics: TPerformanceStatistics | undefined;
}

/**
 *  Objects are removed concurrently for better performance, so side-effects of different removals can be interleaved.
 *
 *  For example, in the hierarchy of TService -> TPodSet -> TPod
 *  removal of [pod set, service, pod] can be executed in order [remove pod, remove pod set, remove service] or
 *  alternatively can fail due to attempt to remove pod twice:
 *      [remove pod as a child of pod set during pod set removal,
 *       remove pod as a third input argument,
 *       ...].
 *  Also duplicate object`s identifiers in request can cause fail too due to attempt to remove object twice.
 */
export interface TReqRemoveObjects {
   /**
    *  Transaction id.
    *  If missing, just removes the objects w/o any transaction.
    *  The request must be sent to the master owning the transacion.
    */
   transaction_id: string;
   /**
    *  Subrequests to serve.
    */
   subrequests: TReqRemoveObjects_TSubrequest[];
   /**
    *  If false, fails with an error on nonexistent object(s).
    *  If true, ignores nonexistent object(s).
    */
   ignore_nonexistent: boolean;
   /**
    *  Common request options.
    */
   common_options: TCommonRequestOptions | undefined;
}

export interface TReqRemoveObjects_TSubrequest {
   /**
    *  Type of the object to remove.
    */
   object_type: EObjectType;
   /**
    *  Use exactly one of the two following fields.
    *  Id of the object to remove, if the type has a single string id field.
    */
   object_id: string;
   /**
    *  A subset of the object's /meta identifying the object to remove.
    */
   meta: TPayload | undefined;
}

export interface TRspRemoveObjects {
   /**
    *  Commit timestamp in case the request was issued outside of an explicit transaction.
    */
   commit_timestamp: number;
   /**
    *  Performance statistics for transparency if requested.
    */
   performance_statistics: TPerformanceStatistics | undefined;
}

/**
 *  Note that some update handlers (in particular, validators) are postponed until the transaction commit.
 */
export interface TReqUpdateObject {
   /**
    *  Transaction id.
    *  If missing, just updates the object w/o any transaction.
    *  The request must be sent to the master owning the transacion.
    */
   transaction_id: string;
   /**
    *  Use exactly one of the two following fields.
    *  Id of the object to update, if the type has a single string id field.
    */
   object_id: string;
   /**
    *  A subset of the object's /meta identifying the object to update.
    */
   meta: TPayload | undefined;
   /**
    *  Type of the object to update.
    */
   object_type: EObjectType;
   /**
    *  Describes set-like updates.
    */
   set_updates: TSetUpdate[];
   /**
    *  Describes set-like updates with root corresponding to the object type.
    */
   set_root_updates: TSetRootUpdate[];
   /**
    *  Describes remove-like updates.
    */
   remove_updates: TRemoveUpdate[];
   /**
    *  Describes lock-like updates.
    */
   lock_updates: TLockUpdate[];
   /**
    *  Prerequisites to check.
    */
   attribute_timestamp_prerequisites: TAttributeTimestampPrerequisite[];
   /**
    *  Creates object with default attributes if non-existent
    *  (does not allow to set fields in meta for created object except key fields).
    */
   create_nonexistent: boolean;
   /**
    *  If false, fails with an error on nonexistent object.
    *  If true, ignores nonexistent object.
    */
   ignore_nonexistent: boolean;
   /**
    *  Common request options.
    */
   common_options: TCommonRequestOptions | undefined;
}

export interface TRspUpdateObject {
   /**
    *  Commit timestamp in case the request was issued outside of an explicit transaction.
    */
   commit_timestamp: number;
   /**
    *  Performance statistics for transparency if requested.
    */
   performance_statistics: TPerformanceStatistics | undefined;
}

/**
 *  Note that the execution order of the individual subrequests is not guaranteed, and so
 *  it is recommended to use the method with independent (in terms of side-effects too) subrequests.
 *  In particular, subrequest finalizers can be postponed till the end of the request
 *  for the sake of effectiveness (one preload instead of many) or model requirements (to allow
 *  invalid intermediate states).
 */
export interface TReqUpdateObjects {
   /**
    *  Transaction id.
    *  If missing, just updates the objects w/o any transaction.
    *  The request must be sent to the master owning the transacion.
    */
   transaction_id: string;
   /**
    *  Subrequests to serve.
    */
   subrequests: TReqUpdateObjects_TSubrequest[];
   /**
    *  Creates object with default attributes if non-existent
    *  (does not allow to set fields in meta for created object except key fields).
    */
   create_nonexistent: boolean;
   /**
    *  If false, fails with an error on nonexistent object.
    *  If true, ignores nonexistent object.
    */
   ignore_nonexistent: boolean;
   /**
    *  Common request options.
    */
   common_options: TCommonRequestOptions | undefined;
}

export interface TReqUpdateObjects_TSubrequest {
   /**
    *  Type of the object to update.
    */
   object_type: EObjectType;
   /**
    *  Use exactly one of the two following fields.
    *  Id of the object to update, if the type has a single string id field.
    */
   object_id: string;
   /**
    *  A subset of the object's /meta identifying the object to update.
    */
   meta: TPayload | undefined;
   /**
    *  Describes set-like updates.
    */
   set_updates: TSetUpdate[];
   /**
    *  Describes set-like updates with root corresponding to the object type.
    */
   set_root_updates: TSetRootUpdate[];
   /**
    *  Describes remove-like updates.
    */
   remove_updates: TRemoveUpdate[];
   /**
    *  Describes lock-like updates.
    */
   lock_updates: TLockUpdate[];
   /**
    *  Prerequisities to check.
    */
   attribute_timestamp_prerequisites: TAttributeTimestampPrerequisite[];
}

export interface TRspUpdateObjects {
   /**
    *  Commit timestamp in case the request was issued outside of an explicit transaction.
    */
   commit_timestamp: number;
   /**
    *  Performance statistics for transparency if requested.
    */
   performance_statistics: TPerformanceStatistics | undefined;
}

export interface TGetObjectOptions {
   /**
    *  If false, GetObject(s) fails with an error on nonexistent object(s).
    *  If true, silently returns null TAttributeList for nonexistent objects.
    */
   ignore_nonexistent: boolean;
   /**
    *  If true, silently excludes nonexistent objects, the order of existent objects is preserved.
    */
   skip_nonexistent: boolean;
   /**
    *  If true then TAttributeList.value_payloads are filled.
    */
   fetch_values: boolean;
   /**
    *  If true then TAttributeList.timestamps are filled.
    */
   fetch_timestamps: boolean;
   /**
    *  If true then all requested attributes will be merged into
    *  root object corresponding to the object type.
    */
   fetch_root_object: boolean;
}

export interface TReqGetObject {
   /**
    *  Provides snapshot isolation.
    *  If omitted then reads the latest state.
    */
   timestamp: number;
   /**
    *  Use exactly one of the two following fields.
    *  Id of the object to get, if the type has a single string id field.
    */
   object_id: string;
   /**
    *  A subset of the object's /meta identifying the object to get.
    */
   meta: TPayload | undefined;
   /**
    *  Type of the object to get.
    */
   object_type: EObjectType;
   /**
    *  Describes which attributes are to fetched.
    *  TRspGetObject.result.attributes will contain exactly this number of attributes.
    */
   selector: TAttributeSelector | undefined;
   /**
    *  Format to use in response.
    */
   format: EPayloadFormat;
   /**
    *  Specific request options.
    */
   options: TGetObjectOptions | undefined;
   /**
    *  Common request options.
    */
   common_options: TCommonRequestOptions | undefined;
   /**
    *  Transaction id to determine start timestamp.
    *  Used when timestamp is not defined.
    *  The request must be sent to the master owning the transacion.
    */
   timestamp_by_transaction_id: string;
}

export interface TRspGetObject {
   /**
    *  The requested attributes.
    */
   result: TAttributeList | undefined;
   /**
    *  If TReqGetObject.timestamp is missing, then this contains the actual timestamp
    *  used for reading the DB; otherwise this is just the copy of TRspGetObject.timestamp.
    */
   timestamp: number;
   /**
    *  Performance statistics for transparency if requested.
    */
   performance_statistics: TPerformanceStatistics | undefined;
}

export interface TReqGetObjects {
   /**
    *  Provides snapshot isolation.
    *  If omitted then reads the latest state.
    */
   timestamp: number;
   /**
    *  Type of objects to get.
    */
   object_type: EObjectType;
   /**
    *  Subrequests to serve.
    */
   subrequests: TReqGetObjects_TSubrequest[];
   /**
    *  Describes which attributes to fetch.
    *  TRspGetObjects.results.attributes will contain exactly this number of attributes.
    */
   selector: TAttributeSelector | undefined;
   /**
    *  Format to use in response.
    */
   format: EPayloadFormat;
   /**
    *  Request options.
    */
   options: TGetObjectOptions | undefined;
   /**
    *  Transaction id to determine start timestamp.
    *  Used when timestamp is not defined.
    *  The request must be sent to the master owning the transacion.
    */
   timestamp_by_transaction_id: string;
   /**
    *  Common request options.
    */
   common_options: TCommonRequestOptions | undefined;
}

export interface TReqGetObjects_TSubrequest {
   /**
    *  Use exactly one of the two following fields.
    *  Id of the object to get, if the type has a single string id field.
    */
   object_id: string;
   /**
    *  A subset of the object's /meta identifying the object to get.
    */
   meta: TPayload | undefined;
}

export interface TRspGetObjects {
   /**
    *  The i-th subresponse here contains the result for the i-th subrequest.
    */
   subresponses: TRspGetObjects_TSubresponse[];
   /**
    *  If TReqGetObject.timestamp is missing, then this contains the actual timestamp
    *  used for reading the DB; otherwise this is just the copy of TRspGetObjects.timestamp.
    */
   timestamp: number;
   /**
    *  Performance statistics for transparency if requested.
    */
   performance_statistics: TPerformanceStatistics | undefined;
}

export interface TRspGetObjects_TSubresponse {
   /**
    *  The requested attributes.
    */
   result: TAttributeList | undefined;
}

export interface TSelectObjectsOptions {
   /**
    *  If true then TAttributeList.value_payloads are filled.
    */
   fetch_values: boolean;
   /**
    *  If true then TAttributeList.timestamps are filled.
    */
   fetch_timestamps: boolean;
   /**
    *  Number of leading results to skip.
    */
   offset: number;
   /**
    *  Maximum number of results to fetch.
    */
   limit: number;
   /**
    *  Continuation token indicates the next record to be fetched. Opaque for the client.
    */
   continuation_token: string;
   /**
    *  If true then all requested attributes will be merged into
    *  root object corresponding to the object type.
    */
   fetch_root_object: boolean;
}

export interface TObjectOrderByExpression {
   expression: string;
   descending: boolean;
}

export interface TObjectOrderBy {
   /**
    *  List of expressions for ordering objects in response.
    */
   expressions: TObjectOrderByExpression[];
}

export interface TIndex {
   /**
    *  Index identity.
    */
   name: string;
}

export interface TReqSelectObjects {
   /**
    *  Provides snapshot isolation.
    *  If omitted then reads the latest state.
    */
   timestamp: number;
   /**
    *  Type of objects to select.
    */
   object_type: EObjectType;
   /**
    *  Provides means for filtering certain objects.
    */
   filter: TObjectFilter | undefined;
   /**
    *  Describes which attributes to fetch.
    *  TRspSelectObjects.results.attributes will contain exactly this number of attributes.
    */
   selector: TAttributeSelector | undefined;
   /**
    *  Enables limiting the number of results.
    *  COMPAT(babenko): deprecated; use options instead.
    */
   limit: TSelectLimit | undefined;
   /**
    *  Enables skipping a number of leading results.
    *  COMPAT(babenko): deprecated; use options instead.
    */
   offset: TSelectOffset | undefined;
   /**
    *  Format to use in response.
    */
   format: EPayloadFormat;
   /**
    *  Request options.
    */
   options: TSelectObjectsOptions | undefined;
   order_by: TObjectOrderBy | undefined;
   /**
    *  If present joins object table with the given index table
    *  for better performance in case of high query selectivity.
    */
   index: TIndex | undefined;
   /**
    *  Common request options.
    */
   common_options: TCommonRequestOptions | undefined;
   /**
    *  Transaction id to determine start timestamp.
    *  Used when timestamp is not defined.
    *  The request must be sent to the master owning the transacion.
    */
   timestamp_by_transaction_id: string;
}

export interface TRspSelectObjects {
   /**
    *  The result set: each element of this list corresponds to a single
    *  matching object.
    */
   results: TAttributeList[];
   /**
    *  If TReqSelectObjects.timestamp is missing, then this contains the actual timestamp
    *  used for reading the DB; otherwise this is just the copy of TReqSelectObjects.timestamp.
    */
   timestamp: number;
   /**
    *  Continuation token should be sent in subsequent requests to fetch the next batch
    *  of objects. Opaque for the client.
    */
   continuation_token: string;
   /**
    *  Performance statistics for transparency if requested.
    */
   performance_statistics: TPerformanceStatistics | undefined;
}

export interface TAggregateExpressions {
   expressions: string[];
}

export interface TGroupByExpressions {
   expressions: string[];
}

export interface TReqAggregateObjects {
   /**
    *  Provides snapshot isolation.
    *  If omitted then reads the latest state.
    */
   timestamp: number;
   /**
    *  Type of objects to select.
    */
   object_type: EObjectType;
   /**
    *  Provides means for filtering certain objects.
    */
   filter: TObjectFilter | undefined;
   /**
    *  Group by expression.
    */
   group_by_expressions: TGroupByExpressions | undefined;
   /**
    *  Aggregate expressions.
    */
   aggregate_expressions: TAggregateExpressions | undefined;
   /**
    *  Transaction id to determine start timestamp.
    *  Used when timestamp is not defined.
    *  The request must be sent to the master owning the transacion.
    */
   timestamp_by_transaction_id: string;
   /**
    *  Common request options.
    */
   common_options: TCommonRequestOptions | undefined;
}

export interface TRspAggregateObjects {
   /**
    *  The result set: each element of this list corresponds to a single group of objects and its aggregation.
    *  List is ordered as follows:
    *      1) group-by keys ordered according to group_by_expressions;
    *      2) aggregated values ordered according to aggregate_expressions.
    */
   results: TAttributeList[];
   /**
    *  If TReqAggregateObjects.timestamp is missing, then this contains the actual timestamp
    *  used for reading the DB; otherwise this is just the copy of TReqAggregateObjects.timestamp.
    */
   timestamp: number;
   /**
    *  Performance statistics for transparency if requested.
    */
   performance_statistics: TPerformanceStatistics | undefined;
}

export interface TReqCheckObjectPermissions {
   /**
    *  Subrequests to serve.
    */
   subrequests: TReqCheckObjectPermissions_TSubrequest[];
   /**
    *  Provides snapshot isolation.
    *  If omitted then reads the latest state.
    */
   timestamp: number;
   /**
    *  Common request options.
    */
   common_options: TCommonRequestOptions | undefined;
   /**
    *  Transaction id to determine start timestamp.
    *  Used when timestamp is not defined.
    *  The request must be sent to the master owning the transacion.
    */
   timestamp_by_transaction_id: string;
}

export interface TReqCheckObjectPermissions_TSubrequest {
   /**
    *  Use exactly one of the two following fields.
    *  Id of the object to check, if the type has a single string id field.
    */
   object_id: string;
   /**
    *  A subset of the object's /meta identifying the object to check.
    */
   meta: TPayload | undefined;
   /**
    *  Type of the object to check.
    */
   object_type: EObjectType;
   /**
    *  Id of subject accessing the object (either user or group).
    */
   subject_id: string;
   /**
    *  Permission to check.
    */
   permission: EAccessControlPermission;
   /**
    *  Attribute path to check.
    */
   attribute_path: string;
}

export interface TRspCheckObjectPermissions {
   /**
    *  The i-th subresponse here contains the result for the i-th subrequest.
    */
   subresponses: TRspCheckObjectPermissions_TSubresponse[];
   /**
    *  If TReqCheckObjectPermissions.timestamp is missing, then this contains the actual timestamp
    *  used for reading the DB; otherwise this is just the copy of TReqCheckObjectPermissions.timestamp.
    */
   timestamp: number;
   /**
    *  Performance statistics for transparency if requested.
    */
   performance_statistics: TPerformanceStatistics | undefined;
}

export interface TRspCheckObjectPermissions_TSubresponse {
   /**
    *  Was request allowed or declined?
    */
   action: EAccessControlAction;
   /**
    *  The object whose ACL contains the matching ACE. Can be null.
    */
   object_id: string;
   /**
    *  The type of object referred by object_id. Can be null.
    */
   object_type: EObjectType;
   /**
    * ! Subject to which the decision applies. Can be null.
    */
   subject_id: string;
}

export interface TReqGetObjectAccessAllowedFor {
   /**
    *  Subrequests to serve.
    */
   subrequests: TReqGetObjectAccessAllowedFor_TSubrequest[];
   /**
    *  Provides snapshot isolation for a transactional data.
    *  If omitted then reads the latest state.
    *
    *  Note that the method operates not only with a transactional data,
    *  but with a cached data too, e.g. users/groups and their relations are cached for now.
    *  Cached data is not affected by the timestamp in any way.
    */
   timestamp: number;
   /**
    *  Transaction id to determine start timestamp.
    *  Used when timestamp is not defined.
    *  The request must be sent to the master owning the transacion.
    */
   timestamp_by_transaction_id: string;
   /**
    *  Common request options.
    */
   common_options: TCommonRequestOptions | undefined;
}

export interface TReqGetObjectAccessAllowedFor_TSubrequest {
   /**
    *  Use exactly one of the two following fields.
    *  Id of the object to check, if the type has a single string id field.
    */
   object_id: string;
   /**
    *  A subset of the object's /meta identifying the object to check.
    */
   meta: TPayload | undefined;
   /**
    *  Type of the object to check.
    */
   object_type: EObjectType;
   /**
    *  Permission to check.
    */
   permission: EAccessControlPermission;
   /**
    *  Attribute path to check.
    */
   attribute_path: string;
}

export interface TRspGetObjectAccessAllowedFor {
   /**
    *  The i-th subresponse here contains the result for the i-th subrequest.
    */
   subresponses: TRspGetObjectAccessAllowedFor_TSubresponse[];
   /**
    *  If TReqGetObjectAccessAllowedFor.timestamp is missing, then this contains the actual timestamp
    *  used for reading the DB; otherwise this is just the copy of TReqGetObjectAccessAllowedFor.timestamp.
    */
   timestamp: number;
   /**
    *  Performance statistics for transparency if requested.
    */
   performance_statistics: TPerformanceStatistics | undefined;
}

export interface TRspGetObjectAccessAllowedFor_TSubresponse {
   /**
    *  Ids of users that are granted access.
    */
   user_ids: string[];
}

export interface TReqGetUserAccessAllowedTo {
   /**
    *  Subrequests to serve.
    */
   subrequests: TReqGetUserAccessAllowedTo_TSubrequest[];
}

export interface TReqGetUserAccessAllowedTo_TSubrequest {
   /**
    *  Id of the user to check.
    */
   user_id: string;
   /**
    *  Type of the object to check.
    */
   object_type: EObjectType;
   /**
    *  Permission to check.
    */
   permission: EAccessControlPermission;
   /**
    *  Attribute path to check.
    */
   attribute_path: string;
   /**
    *  Provides means for filtering certain objects.
    */
   filter: TObjectFilter | undefined;
   /**
    *  Continuation token indicates the next record to be fetched. Opaque for the client.
    */
   continuation_token: string;
   /**
    *  Maximum number of results to fetch.
    */
   limit: number;
}

export interface TRspGetUserAccessAllowedTo {
   /**
    *  The i-th subresponse here contains the result for the i-th subrequest.
    */
   subresponses: TRspGetUserAccessAllowedTo_TSubresponse[];
}

export interface TRspGetUserAccessAllowedTo_TSubresponse {
   /**
    *  Ids of objects to which user is granted permission.
    */
   object_ids: string[];
   /**
    *  Continuation token should be sent in subsequent requests to fetch the next batch
    *  of objects. Opaque for the client.
    */
   continuation_token: string;
}

export interface TReqWatchObjects {
   /**
    *  Only fetches events with timestamp <= given timestamp.
    */
   timestamp: number;
   /**
    *  Only fetches events with timestamp > start_timestamp.
    */
   start_timestamp: number;
   /**
    *  Fetches events from the earliest offset available.
    *  NB! This option does not provide consistent snapshot of all events that happened during the first timestamp read.
    */
   start_from_earliest_offset: boolean;
   /**
    *  Token to continue object selection. Fetches events after previous replied events.
    *  Either start_timestamp or continuation_token should be specified in request.
    */
   continuation_token: string;
   /**
    *  Type of objects to watch.
    */
   object_type: EObjectType;
   /**
    *  Enables limiting the number of results.
    */
   event_count_limit: number;
   /**
    *  If some events are already available, WatchObjects call just returns them.
    *  Otherwise it waits up to time_limit if given.
    *  NB! Only works in pair with `timestamp` option.
    */
   time_limit: Duration | undefined;
   /**
    *  Provides means for filtering certain events based on the object attributes
    *  at the moment of the event generation.
    *
    *  Enabled for certain object types specified in the master configuration.
    *  Returns an error for a disabled type.
    */
   filter: TObjectFilter | undefined;
   /**
    *  Events of the type "object_updated" in the response "should" contain at least one
    *  changed attribute from the selector.
    *
    *  Note, that the attribute change is not guaranteed: some events can be spurious in the sense that
    *  their underlying attribute data was not changed at the event time.
    *  Examples of attributes without changes-tracking and so with potentially high rate of spurious events:
    *    - Evaluated attributes: /<object>/control;
    *    - Attributes of unspecified size: /node/status/pod_ids; /<object>/annotations.
    *
    *  Enabled for certain object types and certain attribute paths specified in the master configuration.
    *  Returns an error for a disabled type or attribute path.
    */
   selector: TAttributeSelector | undefined;
   /**
    *  Read events from the given tablets specified as indexes within the range [0..tablet count).
    *  If the list is empty, read events from all tablets.
    *  Returns an error for tablet index that out of range.
    */
   tablets: number[];
   /**
    *  Format to use in response. None will respond with serialized key in object_id. Yson or proto
    *  will leave it empty and fill meta with /meta of the object.
    */
   format: EPayloadFormat;
   /**
    *  Specifies watch log to read from.
    *  May be useful for testing and debugging purposes.
    */
   watch_log: string;
   /**
    *  Allows to skip trimmed rows (if any) and continue watching from the first non-trimmed one.
    *  If continuation token became obsolete, this option allows to still read using it.
    */
   skip_trimmed: boolean;
   /**
    *  Common request options.
    */
   common_options: TCommonRequestOptions | undefined;
   /**
    *  Fetch information about which attributes were changed by the event.
    */
   fetch_changed_attributes: boolean;
}

export interface TRspWatchObjects {
   /**
    *  Events read so far.
    */
   events: TEvent[];
   /**
    *  If TReqWatchObjects.timestamp is missing, then this contains the actual timestamp.
    *  Used for reading the DB; otherwise this is just the copy of TReqWatchObjects.timestamp.
    */
   timestamp: number;
   /**
    *  Token to continue object selection.
    *  Continuation is finished, if the response event count is smaller than the requested event count limit.
    */
   continuation_token: string;
   /**
    *  Returns the number of skipped rows.
    *  Can be positive only if skipping is allowed, e.g. TReqWatchObjects.skip_trimmed = true.
    */
   skipped_row_count: number;
   /**
    *  Performance statistics for transparency if requested.
    */
   performance_statistics: TPerformanceStatistics | undefined;
   /**
    *  Mapping for decoding changed_attributes_summary layout.
    *  Each entry corresponds to the character in the summary with the same index.
    */
   changed_attributes_index: TRspWatchObjects_TChangedAttributeEntry[];
}

export interface TRspWatchObjects_TChangedAttributeEntry {
   attribute_path: string;
}

/**
 *  Time selector of form "begin <= time < end".
 *  If some of the fields are not set the corresponding inequality is vacuous.
 */
export interface TTimeInterval {
   /**
    *  Left endpoint of the time interval. Endpoint is included.
    */
   begin: Date | { nanos: number; seconds: number } | undefined;
   /**
    *  Right endpoint of the time interval. Endpoint is not included.
    */
   end: Date | { nanos: number; seconds: number } | undefined;
}

export interface TSelectObjectHistoryOptions {
   /**
    *  Uuid of the object. If present, history will be selected for
    *  object with given object_key and given uuid. Deprecated; fill request.meta instead.
    */
   uuid: string;
   /**
    *  Maximum number of results to fetch.
    */
   limit: number;
   /**
    *  Continuation token - should be sent in subsequent requests to fetch the next batch
    *  of history events. Opaque for the client.
    */
   continuation_token: string;
   /**
    *  Time interval to select.
    */
   interval: TTimeInterval | undefined;
   /**
    *  If true, then order history by descending time.
    */
   descending_time_order: boolean;
   /**
    *  If true, then skips consecutive events equal in data fields (event type, results, history
    *  enabled attributes, etc).
    */
   distinct: boolean;
   /**
    *  If true then all requested attributes will be merged into
    *  root object corresponding to the object type.
    */
   fetch_root_object: boolean;
   /**
    *  By default, best-effortly tries to use index based on configuration.
    *  If enabled, then uses index even if it is in building mode.
    *  If disabled, then uses plain history algorithm.
    *
    *  Still requires index to fit the query.
    *  May be useful for testing and debugging purposes.
    */
   index_mode: ESelectObjectHistoryIndexMode;
}

export interface TReqSelectObjectHistory {
   /**
    *  Type of the object to fetch the history for.
    */
   object_type: EObjectType;
   /**
    *  Use exactly one of the two following fields.
    *  Id of the object to fetch the history for, if the type has a single string id field.
    */
   object_id: string;
   /**
    *  A subset of the object's /meta identifying the object to fetch history for.
    */
   meta: TPayload | undefined;
   /**
    *  Describes which attributes are to be fetched.
    *  TRspSelectObjectHistory.events.results will contain exactly this number of attributes.
    */
   selector: TAttributeSelector | undefined;
   /**
    *  Format to use in response.
    *  Format must be supported in the moment of the query.
    */
   format: EPayloadFormat;
   /**
    *  Object history selection query options.
    */
   options: TSelectObjectHistoryOptions | undefined;
   /**
    *  Common request options.
    */
   common_options: TCommonRequestOptions | undefined;
}

export interface TRspSelectObjectHistory {
   /**
    *  Selected events.
    */
   events: TRspSelectObjectHistory_TEvent[];
   /**
    *  Continuation token.
    */
   continuation_token: string;
   /**
    *  Performance statistics for transparency if requested.
    */
   performance_statistics: TPerformanceStatistics | undefined;
}

export interface TRspSelectObjectHistory_TEvent {
   /**
    *  Time of the event.
    */
   time: Date | { nanos: number; seconds: number } | undefined;
   /**
    *  Type of the event.
    */
   event_type: EEventType;
   /**
    *  User that has performed the change.
    */
   user: string;
   /**
    *  Event attributes (cf. TReqSelectObjectHistory.selector).
    */
   results: TAttributeList | undefined;
   /**
    *  List of attributes that were stored for this event.
    */
   history_enabled_attributes: string[];
   /**
    *  Transaction context (see TReqCommitTransaction).
    */
   transaction_context: TTransactionContext | undefined;
}

export interface ObjectService {
   /**
    *  Generates a fresh monotoically increasing timestamp.
    */
   GenerateTimestamp(request: TReqGenerateTimestamp): Promise<TRspGenerateTimestamp>;

   /**
    *  Starts a new transaction.
    *  Transaction ids are opaque strings.
    *  Transaction changes are transient (until commit); transactions are maintained by individual masters.
    *  Clients must be choosing masters in a sticky way; cf. GetMasters.
    */
   StartTransaction(request: TReqStartTransaction): Promise<TRspStartTransaction>;

   /**
    *  Commits an existing transaction.
    */
   CommitTransaction(request: TReqCommitTransaction): Promise<TRspCommitTransaction>;

   /**
    *  Aborts an existing transaction.
    */
   AbortTransaction(request: TReqAbortTransaction): Promise<TRspAbortTransaction>;

   /**
    *  Creates a new object.
    */
   CreateObject(request: TReqCreateObject): Promise<TRspCreateObject>;

   /**
    *  Creates new objects.
    */
   CreateObjects(request: TReqCreateObjects): Promise<TRspCreateObjects>;

   /**
    *  Removes an existing object.
    */
   RemoveObject(request: TReqRemoveObject): Promise<TRspRemoveObject>;

   /**
    *  Removes existing objects.
    */
   RemoveObjects(request: TReqRemoveObjects): Promise<TRspRemoveObjects>;

   /**
    *  Updates an existing object.
    */
   UpdateObject(request: TReqUpdateObject): Promise<TRspUpdateObject>;

   /**
    *  Updates existing objects.
    */
   UpdateObjects(request: TReqUpdateObjects): Promise<TRspUpdateObjects>;

   /**
    *  Fetches object attributes by object id.
    */
   GetObject(request: TReqGetObject): Promise<TRspGetObject>;

   /**
    *  Fetches objects attributes by object ids.
    */
   GetObjects(request: TReqGetObjects): Promise<TRspGetObjects>;

   /**
    *  Executes a query and fetches attributes for relevant objects.
    */
   SelectObjects(request: TReqSelectObjects): Promise<TRspSelectObjects>;

   /**
    *  Executes a group-by query and aggregates attributes for relevant objects.
    */
   AggregateObjects(request: TReqAggregateObjects): Promise<TRspAggregateObjects>;

   /**
    *  Runs permission checks for given objects, permissions, and users.
    */
   CheckObjectPermissions(request: TReqCheckObjectPermissions): Promise<TRspCheckObjectPermissions>;

   /**
    *  Given objects and permissions, computes the set of users that are granted the specified permission.
    */
   GetObjectAccessAllowedFor(request: TReqGetObjectAccessAllowedFor): Promise<TRspGetObjectAccessAllowedFor>;

   /**
    *  Computes the set of objects of a given type to which given users are granted given permissions.
    */
   GetUserAccessAllowedTo(request: TReqGetUserAccessAllowedTo): Promise<TRspGetUserAccessAllowedTo>;

   /**
    *  Reads updates from event queue.
    */
   WatchObjects(request: TReqWatchObjects): Promise<TRspWatchObjects>;

   /**
    *  Executes a query and fetches attributes for relevant objects.
    */
   SelectObjectHistory(request: TReqSelectObjectHistory): Promise<TRspSelectObjectHistory>;
}
