/* eslint-disable */
import { EPersistentDiskKind } from '../../../../../yp_proto/yp/client/api/proto/enums';

export interface TPersistentDiskMetaBase {
   kind: EPersistentDiskKind;
}

export interface TPersistentDiskSpec {
   /**
    *  For informative use only.
    */
   storage_class: string;
   managed_policy: TPersistentDiskSpec_TManagedPolicy | undefined;
   rbind_policy: TPersistentDiskSpec_TRbindPolicy | undefined;
}

/**
 *  Cf. TResourceSpec.TDiskSpec.
 */
export interface TPersistentDiskSpec_TManagedPolicy {
   /**
    *  In bytes.
    */
   total_capacity: number;
   /**
    *  Each volume occupies a virtual "slot".
    *  This prevents assigning too many volumes to a single physical disk.
    */
   total_volume_slots: number;
   /**
    *  Total provided bandwidth in bytes per second.
    */
   total_bandwidth: number;
   /**
    *  Total provided read bandwidth is estimated
    *  using total_bandwidth and the following factor.
    */
   read_bandwidth_factor: number;
   /**
    *  Total provided write bandwidth is estimated
    *  using total_bandwidth and the following factor.
    */
   write_bandwidth_factor: number;
   /**
    *  Total provided read operations per second is estimated
    *  using total_bandwidth and the following divisor.
    */
   read_operation_rate_divisor: number;
   /**
    *  Total provided write operations per second is estimated
    *  using total_bandwidth and the following divisor.
    */
   write_operation_rate_divisor: number;
}

export interface TPersistentDiskSpec_TRbindPolicy {}

export interface TPersistentDiskStatus {
   /**
    *  The id of the node this disk is currently attached to, if any.
    */
   attached_to_node_id: string;
   /**
    *  The id of the node last reported the presence of this disk.
    */
   last_seen_node_id: string;
   /**
    *  The time this disk was last reported by the node.
    */
   last_seen_time: Date | { nanos: number; seconds: number } | undefined;
}
