/* eslint-disable */
import { EPersistentVolumeState } from '../../../../../yp_proto/yp/client/api/proto/enums';
import { TError } from '../../../../../yt_proto/yt/core/misc/proto/error';

export interface TPersistentVolumeMetaBase {
   disk_id: string;
}

export interface TPersistentVolumeSpec {
   managed_policy: TPersistentVolumeSpec_TManagedPolicy | undefined;
   rbind_policy: TPersistentVolumeSpec_TRbindPolicy | undefined;
}

export interface TPersistentVolumeSpec_TManagedPolicy {
   capacity: number;
   bandwidth_guarantee: number;
   bandwidth_limit: number;
   operation_rate_guarantee: number;
   operation_rate_limit: number;
}

export interface TPersistentVolumeSpec_TRbindPolicy {
   mount_path: string;
}

export interface TPersistentVolumeStatus {
   /**
    *  Current volume state, as reported by agent.
    */
   state: EPersistentVolumeState;
   /**
    *  Spec timestamp, as reported by agent.
    */
   agent_spec_timestamp: number;
   /**
    *  If given, contains the error occurred during volume lifecycle at agent.
    */
   execution_error: TError | undefined;
   /**
    *  List of validation errors for latest volume spec.
    */
   validation_failures: string[];
   /**
    *  The id of the claim bound to this volume, if any.
    */
   bound_claim_id: string;
   /**
    *  The id of the pod this volume is currently mounted to, if any.
    */
   mounted_to_pod_id: string;
}
