/* eslint-disable */

export interface TPersistentVolumeClaimSpec {
   quota_policy: TPersistentVolumeClaimSpec_TQuotaPolicy | undefined;
   exclusive_policy: TPersistentVolumeClaimSpec_TExclusivePolicy | undefined;
   existing_volume_policy: TPersistentVolumeClaimSpec_TExistingVolumePolicy | undefined;
}

/**
 *  Claims a part of the disk drive.
 */
export interface TPersistentVolumeClaimSpec_TQuotaPolicy {
   /**
    *  E.g. ssd, hdd.
    */
   storage_class: string;
   /**
    *  Guaranteed volume capacity.
    */
   capacity: number;
   /**
    *  Guaranteed volume bandwidth in bytes per second.
    */
   bandwidth_guarantee: number;
   /**
    *  Volume bandwidth limit in bytes per second.
    */
   bandwidth_limit: number;
}

/**
 *  Claims the whole disk drive.
 */
export interface TPersistentVolumeClaimSpec_TExclusivePolicy {
   /**
    *  E.g. ssd, hdd.
    */
   storage_class: string;
   /**
    *  Minimum capacity the disk must have.
    *  The client, however, will be charged for the whole disk capacity.
    */
   min_capacity: number;
   /**
    *  Minimum bandwidth in bytes per second the disk must provide.
    *  The client, however, will be charged for the whole disk bandwidth.
    */
   min_bandwidth: number;
}

/**
 *  Claims an existing persistent volume.
 */
export interface TPersistentVolumeClaimSpec_TExistingVolumePolicy {
   /**
    *  The id of the existing volume to use.
    *  XXX(babenko): ref?
    */
   volume_id: string;
}

export interface TPersistentVolumeClaimStatus {
   /**
    *  The id of the persistent volume bound to this claim, if any.
    */
   bound_volume_id: string;
}
