/* eslint-disable */
import { TDockerImageDescription } from '../../../../../yp_proto/yp/client/api/proto/deploy';
import { TCondition } from '../../../../../yp_proto/yp/client/api/proto/conditions';

/**
 *  for field descriptions see NYP.NClient.NApi.NProto.TReleaseMeta
 */
export interface TReleaseMetaBase {
   /**
    *  Id of release author.
    */
   author_id: string;
}

/**
 *  TSandboxResource fields correspond to result of get_release_info sandbox-method.
 */
export interface TSandboxResource {
   resource_id: string;
   type: string;
   description: string;
   skynet_id: string;
   http_url: string;
   arch: string;
   file_md5: string;
   releasers: string[];
   /**
    *  Resource bundle specific field. Resource will be mounted to
    *  path "<directory>/<filename>" where <directory> is resource bundle directory
    */
   filename: string;
   /**
    *  Attributes of sandbox resource, e.g.
    *    "backup_task": "577303390",
    *    "released": "testing",
    *    "ttl": "inf",
    *    "version": "1.200"
    */
   attributes: { [key: string]: string };
}

export interface TSandboxResource_AttributesEntry {
   key: string;
   value: string;
}

export interface TSandboxRelease {
   /**
    *  Sandbox task type.
    */
   task_type: string;
   /**
    *  Sandbox task id.
    */
   task_id: string;
   /**
    *  User who released sandbox task (created release).
    */
   release_author: string;
   /**
    *  User who created sandbox task.
    */
   task_author: string;
   title: string;
   description: string;
   /**
    *  Release type (stable, testing, etc).
    */
   release_type: string;
   resources: TSandboxResource[];
   task_creation_time: Date | { nanos: number; seconds: number } | undefined;
}

export interface TDockerRelease {
   /**
    *  Deprecated fields begin. They will be removed in favor of images field.
    */
   image_name: string;
   image_tag: string;
   image_hash: string;
   /**
    *  For now it is registry.yandex.net always.
    */
   registry: string;
   /**
    *  Release type (stable, testing, etc).
    */
   release_type: string;
   /**
    *  User who created release.
    */
   release_author: string;
   /**
    *  Images this release contains.
    */
   images: TDockerImageDescription[];
}

export interface TReleaseSpec {
   title: string;
   description: string;
   sandbox: TSandboxRelease | undefined;
   docker: TDockerRelease | undefined;
}

export interface TReleaseProgress {
   /**
    *  It is true only if all tickets statuses are pending.
    */
   pending: TCondition | undefined;
   /**
    *  It is true only if at least one ticket status is in_progress.
    */
   in_progress: TCondition | undefined;
   /**
    *  It is true only if all tickets statuses are success, failed or cancelled.
    */
   closed: TCondition | undefined;
   start_time: Date | { nanos: number; seconds: number } | undefined;
   end_time: Date | { nanos: number; seconds: number } | undefined;
   last_transition_time: Date | { nanos: number; seconds: number } | undefined;
}

export interface TReleaseProcessing {
   /**
    *  Describes how release matches. It is true if release was matched
    *  with release rules and corresponding tickets were created.
    */
   finished: TCondition | undefined;
}

export interface TReleaseStatus {
   progress: TReleaseProgress | undefined;
   processing: TReleaseProcessing | undefined;
}
