/* eslint-disable */
import { TDockerImageDescription } from '../../../../../yp_proto/yp/client/api/proto/deploy';
import { TDeployPatchSpec } from '../../../../../yp_proto/yp/client/api/proto/deploy_patch';

/**
 *  for field descriptions see NYP.NClient.NApi.NProto.TReleaseRuleMeta
 */
export interface TReleaseRuleMetaBase {
   /**
    *  Id of parent stage.
    */
   stage_id: string;
}

export interface TSandboxSelector {
   /**
    *  Task type of Sandbox release to be matched with release rule.
    */
   task_type: string;
   /**
    *  Resource types of Sandbox release to be matched with release rule.
    */
   resource_types: string[];
   /**
    *  Release types (stable, testing, etc) of Sandbox release to be matched
    *  with release rule.
    */
   release_types: string[];
   task_authors: string[];
   /**
    *  Selector that will match sandbox resource only if
    *  each key-value pair is presented in resource attributes
    */
   attributes: { [key: string]: string };
}

export interface TSandboxSelector_AttributesEntry {
   key: string;
   value: string;
}

export interface TDockerSelector {
   /**
    *  Image name of Docker release to be matched with release rule.
    *  This field is deprecated. It will be removed in favor of image_names.
    */
   image_name: string;
   /**
    *  Release types (stable, testing, etc) of Docker release to be matched
    *  with release rule.
    */
   release_types: string[];
   /**
    *  Release will be matched only if all following images are given.
    */
   images: TDockerImageDescription[];
}

export interface TAutoCommitPolicy {
   type: TAutoCommitPolicy_EType;
   /**
    *  Options regulating behaviour for MAINTAIN_ACTIVE_TRUNK rules.
    */
   maintain_active_trunk_options: TAutoCommitPolicy_TMaintainActiveTrunkOptions | undefined;
}

/**
 * NONE -  Do not auto commit ticket, only manual commit is allowed.
 *
 * MAINTAIN_ACTIVE_TRUNK -  Auto commit last created ticket for this release rule.
 *
 * SEQUENTIAL_COMMIT -  Auto commit first created ticket for this release rule.
 *
 */
export enum TAutoCommitPolicy_EType {
   NONE = 'none',
   MAINTAIN_ACTIVE_TRUNK = 'maintain_active_trunk',
   SEQUENTIAL_COMMIT = 'sequential_commit',
}

/**
 * WAIT_FOR_COMPLETION -  Wait for stage to finish current active deployments
 *  before committing ticket.
 *
 * TERMINATE -  Do not wait for anything, commit ticket immediately.
 *
 */
export enum TAutoCommitPolicy_EDeploymentTerminationPolicy {
   WAIT_FOR_COMPLETION = 'wait_for_completion',
   TERMINATE = 'terminate',
}

export interface TAutoCommitPolicy_TMaintainActiveTrunkOptions {
   /**
    *  Policy affecting autocommit when another deploy is active.
    */
   deployment_termination_policy: TAutoCommitPolicy_EDeploymentTerminationPolicy;
}

export interface TReleaseRuleSpec {
   sandbox: TSandboxSelector | undefined;
   docker: TDockerSelector | undefined;
   /**
    *  Patches describe how to patch stage spec or dynamic resource spec
    *  with release data.
    *  <patch id> -> <patch spec>.
    */
   patches: { [key: string]: TDeployPatchSpec };
   description: string;
   /**
    *  Users who recieve notifications on release commit.
    */
   responsibles: string[];
   /**
    *  Auto commit policy describes how to commit tickets created by
    *  release rule.
    */
   auto_commit_policy: TAutoCommitPolicy | undefined;
   /**
    *  Recipe which will be used for auto commit.
    */
   recipe_id: string;
   selector_source: TReleaseRuleSpec_ESelectorSource;
}

export enum TReleaseRuleSpec_ESelectorSource {
   NONE = 'none',
   STAGE = 'stage',
   CUSTOM = 'custom',
}

export interface TReleaseRuleSpec_PatchesEntry {
   key: string;
   value: TDeployPatchSpec | undefined;
}

export interface TReleaseRuleStatus {
   created_ticket_count: number;
}
