/* eslint-disable */
import {
   TPodTemplateSpec,
   TDeploySpeed,
   TDeployReadyCriterion,
   TClusterDeployStatus,
} from '../../../../../yp_proto/yp/client/api/proto/deploy';
import { TAntiaffinityConstraint } from '../../../../../yp_proto/yp/client/api/proto/data_model';
import { TCondition } from '../../../../../yp_proto/yp/client/api/proto/conditions';

export interface TReplicaSetSpec {
   revision_id: string;
   replica_count: number;
   pod_template_spec: TPodTemplateSpec | undefined;
   deployment_strategy: TReplicaSetSpec_TDeploymentStrategy | undefined;
   account_id: string;
   constraints: TReplicaSetSpec_TConstraints | undefined;
   node_segment_id: string;
}

export interface TReplicaSetSpec_TDeploymentStrategy {
   min_available: number;
   max_unavailable: number;
   max_surge: number;
   /**
    *  Minimum number of seconds after pod creation to be considered available.
    */
   min_created_seconds: number;
   /**
    *  Max allowed hardware maintenance duration in seconds during which pods may be unavailable
    */
   max_tolerable_downtime_seconds: number;
   /**
    *  max_unavailable analogue, but only for eviction/maintenance-related unavailability
    */
   max_tolerable_downtime_pods: number;
   /**
    *  Describes how many pods to update at a time and min delay between updates.
    */
   deploy_speed: TDeploySpeed | undefined;
   /**
    *  Conditions which determine if replica set is ready.
    */
   ready_criterion: TDeployReadyCriterion | undefined;
}

export interface TReplicaSetSpec_TConstraints {
   antiaffinity_constraints: TAntiaffinityConstraint[];
}

/**
 *  Deprecated fields start here. They will be removed after moving to
 *  new ReplicaSetStatus schema.
 */
export interface TReplicaSetStatus {
   in_progress: TReplicaSetStatus_TAggregatedCondition | undefined;
   ready: TReplicaSetStatus_TAggregatedCondition | undefined;
   revisions: { [key: string]: TReplicaSetStatus_TRevision };
   controller_status: TReplicaSetStatus_TControllerStatus | undefined;
   total_progress: TReplicaSetStatus_TDeployProgress | undefined;
   current_revision_progress: TReplicaSetStatus_TDeployProgress | undefined;
   revisions_progress: { [key: string]: TReplicaSetStatus_TDeployProgress };
   revision_id: string;
   in_progress_condition: TCondition | undefined;
   ready_condition: TCondition | undefined;
   failed_condition: TCondition | undefined;
   deploy_status: TClusterDeployStatus | undefined;
}

export interface TReplicaSetStatus_TCondition {
   status: string;
   reason: string;
   message: string;
   last_transition_time: Date | { nanos: number; seconds: number } | undefined;
}

export interface TReplicaSetStatus_TAggregatedCondition {
   pod_count: number;
   condition: TReplicaSetStatus_TCondition | undefined;
}

export interface TReplicaSetStatus_TRevision {
   revision_id: string;
   in_progress: TReplicaSetStatus_TAggregatedCondition | undefined;
   ready: TReplicaSetStatus_TAggregatedCondition | undefined;
   volumes: TReplicaSetStatus_TRevision_TAggregatedVolumeStatus[];
   resources: TReplicaSetStatus_TRevision_TAggregatedResourceStatus[];
   workloads: TReplicaSetStatus_TRevision_TAggregatedWorkloadStatus[];
   boxes: TReplicaSetStatus_TRevision_TAggregatedBoxStatus[];
}

export interface TReplicaSetStatus_TRevision_TAggregatedVolumeStatus {
   id: string;
   in_progress: TReplicaSetStatus_TAggregatedCondition | undefined;
   ready: TReplicaSetStatus_TAggregatedCondition | undefined;
}

export interface TReplicaSetStatus_TRevision_TAggregatedResourceStatus {
   id: string;
   in_progress: TReplicaSetStatus_TAggregatedCondition | undefined;
   ready: TReplicaSetStatus_TAggregatedCondition | undefined;
}

export interface TReplicaSetStatus_TRevision_TAggregatedWorkloadStatus {
   id: string;
   in_progress: TReplicaSetStatus_TAggregatedCondition | undefined;
   ready: TReplicaSetStatus_TAggregatedCondition | undefined;
}

export interface TReplicaSetStatus_TRevision_TAggregatedBoxStatus {
   id: string;
   in_progress: TReplicaSetStatus_TAggregatedCondition | undefined;
   ready: TReplicaSetStatus_TAggregatedCondition | undefined;
}

export interface TReplicaSetStatus_RevisionsEntry {
   key: string;
   value: TReplicaSetStatus_TRevision | undefined;
}

export interface TReplicaSetStatus_TDeployProgress {
   /**
    *  Number of pods synced to up-to-date spec.
    */
   pods_ready: number;
   /**
    *  Number of pods currently updating.
    */
   pods_in_progress: number;
   /**
    *  Total number of pods.
    */
   pods_total: number;
}

export interface TReplicaSetStatus_TControllerAttempt {
   succeeded: TReplicaSetStatus_TCondition | undefined;
   revision_id: string;
}

export interface TReplicaSetStatus_TControllerStatus {
   last_attempt: TReplicaSetStatus_TControllerAttempt | undefined;
}

export interface TReplicaSetStatus_RevisionsProgressEntry {
   key: string;
   value: TReplicaSetStatus_TDeployProgress | undefined;
}
