/* eslint-disable */
import { TLayer, TResource } from '../../../../../yp_proto/yp/client/api/proto/pod_agent';
import { TAggregatedCondition } from '../../../../../yp_proto/yp/client/api/proto/conditions';

export interface TResourceCacheMetaBase {
   pod_set_id: string;
}

export interface TResourceCacheSpec {
   revision: number;
   cached_resources: TResourceCacheSpec_TCachedResource[];
   /**
    *  Size of the update window in pods
    *  TODO(DEPLOY-2795) For backward compatibility, 0 will be interpreted as infinity
    *  This will be fixed after the release of the controller and yp schema
    */
   update_window: number;
}

/**
 *  Unique revisions for resource are revisions with different spec of this resource
 */
export interface TResourceCacheSpec_TResourceCacheBasicStrategy {
   /**
    *  Number of unique latest revisions to download
    */
   max_latest_revisions: number;
}

export interface TResourceCacheSpec_TCachedResource {
   id: string;
   layer: TLayer | undefined;
   static_resource: TResource | undefined;
   basic_strategy: TResourceCacheSpec_TResourceCacheBasicStrategy | undefined;
}

export interface TResourceCacheStatus {
   /**
    *  Latest revision
    */
   revision: number;
   /**
    *  Conditions for all revisions of all resources which will be downloaded to the pods
    */
   all_in_progress: TAggregatedCondition | undefined;
   all_ready: TAggregatedCondition | undefined;
   all_failed: TAggregatedCondition | undefined;
   /**
    *  Conditions for latest revision of all resources
    */
   latest_in_progress: TAggregatedCondition | undefined;
   latest_ready: TAggregatedCondition | undefined;
   latest_failed: TAggregatedCondition | undefined;
   /**
    *  Status for all cached resources in spec
    *  id -> revisions to download
    */
   cached_resource_status: TResourceCacheStatus_TCachedResourceStatus[];
}

export interface TResourceCacheStatus_TCachedResourceRevisionStatus {
   revision: number;
   in_progress: TAggregatedCondition | undefined;
   ready: TAggregatedCondition | undefined;
   failed: TAggregatedCondition | undefined;
   layer: TLayer | undefined;
   static_resource: TResource | undefined;
}

export interface TResourceCacheStatus_TCachedResourceStatus {
   id: string;
   /**
    *  All revisions to be downloaded to the pods
    */
   revisions: TResourceCacheStatus_TCachedResourceRevisionStatus[];
}
