/* eslint-disable */
import { TError } from '../../../../../yt_proto/yt/core/misc/proto/error';

export interface TSecretSpec {
   /**
    *  Map from delegate fqid (also used as vault signature) to vault secret delegation.
    */
   delegations: { [key: string]: TSecretSpec_TDelegation };
}

export interface TSecretSpec_TDelegation {
   delegation_token: string;
}

export interface TSecretSpec_DelegationsEntry {
   key: string;
   value: TSecretSpec_TDelegation | undefined;
}

export interface TSecretStatus {
   /**
    *  Map from delegate fqid to status of delegation.
    */
   delegations: { [key: string]: TSecretStatus_TDelegation };
}

export interface TSecretStatus_TDelegation {
   /**
    *  Vault recognizes the delegation.
    */
   valid: boolean;
   /**
    *  Description of observed problems.
    */
   error: TError | undefined;
}

export interface TSecretStatus_DelegationsEntry {
   key: string;
   value: TSecretStatus_TDelegation | undefined;
}
