/* eslint-disable */

export interface TSemaphoreMetaBase {
   /**
    *  Id of semaphore set containing this semaphore.
    */
   semaphore_set_id: string;
}

export interface TSemaphoreSpec {
   budget: number;
}

export interface TSemaphoreStatus {
   /**
    *  <lease uuid> -> <lease>. Leases can be expired.
    */
   leases: { [key: string]: TSemaphoreStatus_TLease };
}

export interface TSemaphoreStatus_TLease {
   /**
    *  Last ping/acquire time of lease, in milliseconds.
    */
   last_acquire_time: number;
   /**
    *  Timestamp, when lease expires, in milliseconds.
    */
   expiration_time: number;
   acquirer_endpoint_description: string;
   /**
    *  Quantity withdrawn from budget. Zero means nothing is withdrawn.
    */
   budget: number;
}

export interface TSemaphoreStatus_LeasesEntry {
   key: string;
   value: TSemaphoreStatus_TLease | undefined;
}

export interface TSemaphoreAcquire {
   lease_uuid: string;
   /**
    *  Duration of lease, in milliseconds.
    */
   duration: number;
   /**
    *  Quantity to withdraw from budget, 1 by default.
    */
   budget: number;
}

export interface TSemaphorePing {
   lease_uuid: string;
   /**
    *  Duration of lease, in milliseconds.
    */
   duration: number;
}

export interface TSemaphoreRelease {
   lease_uuid: string;
}

export interface TSemaphoreControlBase {
   acquire: TSemaphoreAcquire | undefined;
   ping: TSemaphorePing | undefined;
   release: TSemaphoreRelease | undefined;
}
