/* eslint-disable */

export interface TSemaphoreSetSpec {
   /**
    *  Default duration of lease, if not specified in acquire/ping control methods, in milliseconds.
    */
   default_duration: number;
}

export interface TSemaphoreSetStatus {}

export interface TSemaphoreSetAcquire {
   lease_uuid: string;
   /**
    *  Duration of lease, in milliseconds.
    */
   duration: number;
   /**
    *  Quantity to withdraw from budget, default is 1.
    */
   budget: number;
}

export interface TSemaphoreSetPing {
   lease_uuid: string;
   /**
    *  Duration of lease, in milliseconds.
    */
   duration: number;
}

export interface TSemaphoreSetRelease {
   lease_uuid: string;
}

export interface TSemaphoreSetControlBase {
   acquire: TSemaphoreSetAcquire | undefined;
   ping: TSemaphoreSetPing | undefined;
   release: TSemaphoreSetRelease | undefined;
}
