/* eslint-disable */
import {
   TDynamicResourceSpec,
   TDynamicResourceStatus_TRevisionStatus,
} from '../../../../../yp_proto/yp/client/api/proto/dynamic_resource';
import { TResourceCacheSpec } from '../../../../../yp_proto/yp/client/api/proto/resource_cache';
import { TCondition } from '../../../../../yp_proto/yp/client/api/proto/conditions';
import { TDockerImageDescription, TDeployProgress } from '../../../../../yp_proto/yp/client/api/proto/deploy';
import {
   TReplicaSetSpec,
   TReplicaSetSpec_TDeploymentStrategy,
   TReplicaSetStatus,
} from '../../../../../yp_proto/yp/client/api/proto/replica_set';
import { TReplicaSetScaleSpec } from '../../../../../yp_proto/yp/client/api/proto/horizontal_pod_autoscaler';
import { TMultiClusterReplicaSetSpec } from '../../../../../yp_proto/yp/client/api/proto/multi_cluster_replica_set';
import { TDownloadableResource } from '../../../../../yp_proto/yp/client/api/proto/downloadable_resources';
import {
   TAddDeployChild,
   TRemoveDeployChild,
   TAddSecretDelegation,
   TRemoveSecretDelegation,
} from '../../../../../yp_proto/yp/client/api/proto/deploy_control';
import { SecretSelector } from '../../../../../yp_proto/yp/client/api/proto/pod_agent';
import { TSidecarVolume } from '../../../../../yp_proto/yp/client/api/proto/sidecar_volume';
import { TPodSpec_TResourceRequests } from '../../../../../yp_proto/yp/client/api/proto/data_model';

/**
 *  for field descriptions see NYP.NClient.NApi.NProto.TStageMeta
 */
export interface TStageMetaBase {
   /**
    *  Id of parent project.
    */
   project_id: string;
}

export interface TStageSpec {
   /**
    *  Should be incremented on any update.
    */
   revision: number;
   /**
    *  <unit id> -> <unit spec>.
    */
   deploy_units: { [key: string]: TDeployUnitSpec };
   /**
    *  In form "abc:service:<int id>".
    */
   account_id: string;
   /**
    *  <dynamic resource id> -> <dynamic resource info>
    */
   dynamic_resources: { [key: string]: TStageSpec_TStageDynamicResourceSpec };
   /**
    *  Information about current revision of the spec.
    *  NOTE: see https://st.yandex-team.ru/YP-1270 for api support.
    */
   revision_info: TStageSpec_TRevisionInfo | undefined;
   sox_service: boolean;
   /**
    *  <resource cache id> -> <resource cache info>
    */
   resource_caches: { [key: string]: TStageSpec_TStageResourceCacheSpec };
   /**
    *  Environment variables applied to all stage boxes/workloads.
    *  Boxes/workloads are able to override those global variables.
    */
   env: { [key: string]: string };
   /**
    *  Disable automatic addition of secret delegations to the stage.
    */
   disable_automatic_secret_delegation: boolean;
   /**
    *  <deploy unit id> -> <settings>. This settings do not affect to deploy unit revision.
    */
   deploy_unit_settings: { [key: string]: TStageSpec_TDeployUnitSettings };
   /**
    *  Stage description for information purpose.
    */
   description: string;
}

export interface TStageSpec_DeployUnitsEntry {
   key: string;
   value: TDeployUnitSpec | undefined;
}

export interface TStageSpec_TStageDynamicResourceSpec {
   deploy_unit_ref: string;
   dynamic_resource: TDynamicResourceSpec | undefined;
}

export interface TStageSpec_DynamicResourcesEntry {
   key: string;
   value: TStageSpec_TStageDynamicResourceSpec | undefined;
}

export interface TStageSpec_TRevisionInfo {
   /**
    *  Human-readable description.
    */
   description: string;
}

export interface TStageSpec_TStageResourceCacheSpec {
   deploy_unit_ref: string;
   resource_cache: TResourceCacheSpec | undefined;
}

export interface TStageSpec_ResourceCachesEntry {
   key: string;
   value: TStageSpec_TStageResourceCacheSpec | undefined;
}

export interface TStageSpec_EnvEntry {
   key: string;
   value: string;
}

export interface TStageSpec_TDeployUnitSettings {
   alerting: TStageSpec_TDeployUnitSettings_TAlerting | undefined;
   environment: TStageSpec_TDeployUnitSettings_EDeployUnitEnvironment;
}

export enum TStageSpec_TDeployUnitSettings_EDeployUnitEnvironment {
   UNKNOWN = 'unknown',
   TESTING = 'testing',
   PRESTABLE = 'prestable',
   STABLE = 'production',
}

export interface TStageSpec_TDeployUnitSettings_TAlerting {
   state: TStageSpec_TDeployUnitSettings_TAlerting_EState;
   /**
    *  <alert status> - <notification_channel>. Distribute notifications to different channels depending on alert status.
    */
   notification_channels: { [key: string]: string };
}

export enum TStageSpec_TDeployUnitSettings_TAlerting_EState {
   UNKNOWN = 'unknown',
   ENABLED = 'enabled',
   IDLE = 'idle',
   REMOVED = 'removed',
}

export interface TStageSpec_TDeployUnitSettings_TAlerting_NotificationChannelsEntry {
   key: string;
   value: string;
}

export interface TStageSpec_DeployUnitSettingsEntry {
   key: string;
   value: TStageSpec_TDeployUnitSettings | undefined;
}

export interface TStageStatus {
   /**
    *  <unit id> -> <unit status>.
    */
   deploy_units: { [key: string]: TDeployUnitStatus };
   /**
    *  Revision of spec last treated by controller.
    *  Other stage-wide status fields refer to this revision.
    *  Unit specs may refer to other revisions, as specified inside them.
    */
   revision: number;
   /**
    *  Stage spec has been accepted by controller as valid.
    */
   validated: TCondition | undefined;
   /**
    *  YP timestamp of spec last treated by controller.
    */
   spec_timestamp: number;
   /**
    *  <resource id> -> <aggregated from clusters resource status>
    */
   dynamic_resources: { [key: string]: TStageStatus_TStageDynamicResourceStatus };
   /**
    *  <resource cache id> -> <aggregated from clusters resource status>
    */
   resource_caches: { [key: string]: TStageStatus_TStageResourceCacheStatus };
   runtime_deploy_controls: { [key: string]: TRuntimeDeployControls };
}

export interface TStageStatus_DeployUnitsEntry {
   key: string;
   value: TDeployUnitStatus | undefined;
}

export interface TStageStatus_TStageDynamicResourceStatus {
   status: TDynamicResourceStatus_TRevisionStatus | undefined;
   current_target: TStageSpec_TStageDynamicResourceSpec | undefined;
}

export interface TStageStatus_DynamicResourcesEntry {
   key: string;
   value: TStageStatus_TStageDynamicResourceStatus | undefined;
}

export interface TStageStatus_TStageResourceCacheStatus {
   current_target: TStageSpec_TStageResourceCacheSpec | undefined;
}

export interface TStageStatus_ResourceCachesEntry {
   key: string;
   value: TStageStatus_TStageResourceCacheStatus | undefined;
}

export interface TStageStatus_RuntimeDeployControlsEntry {
   key: string;
   value: TRuntimeDeployControls | undefined;
}

export interface TRuntimeDeployControls {
   deploy_unit_approval: TDeployUnitApproval | undefined;
   deploy_unit_overrides: TDeployUnitOverrides | undefined;
   deploy_unit_approvals: { [key: string]: TDeployUnitApproval };
}

export interface TRuntimeDeployControls_DeployUnitApprovalsEntry {
   key: string;
   value: TDeployUnitApproval | undefined;
}

/**
 *  Network settings for requests from infrastructure.
 */
export interface TNetworkDefaults {
   network_id: string;
   /**
    *  Override non empty pod_template ip6_address_requests with default network_id
    */
   override_ip6_address_requests: boolean;
   /**
    *  Override non empty pod_template ip6_subnet_requests with default network_id
    */
   override_ip6_subnet_requests: boolean;
   virtual_service_ids: string[];
   ip4_address_pool_id: string;
}

export interface TDeployUnitSpec {
   network_defaults: TNetworkDefaults | undefined;
   replica_set: TDeployUnitSpec_TReplicaSetDeploy | undefined;
   multi_cluster_replica_set: TDeployUnitSpec_TMultiClusterReplicaSetDeploy | undefined;
   tvm_config: TTvmConfig | undefined;
   /**
    *  <box id> -> <docker image description>.
    *  If box id is present in this map, layers from corresponding docker image will be added
    *  below layers specified in pod agent spec.
    *  NOTE: box id must be present in pod agent spec.
    */
   images_for_boxes: { [key: string]: TDockerImageDescription };
   endpoint_sets: TDeployUnitSpec_TEndpointSetTemplate[];
   /**
    *  <box id> -> <juggler config for box>.
    *  If box id is present in this map, a juggler workload will be added to it.
    *  NOTE: box id must be present in pod agent spec.
    */
   box_juggler_configs: { [key: string]: TBoxJugglerConfig };
   logbroker_config: TLogbrokerConfig | undefined;
   logrotate_configs: { [key: string]: TLogrotateConfig };
   revision: number;
   sox_service: boolean;
   coredump_config: { [key: string]: TCoredumpPolicy };
   tvm_sandbox_info: TSandboxResourceInfo | undefined;
   pod_agent_sandbox_info: TSandboxResourceInfo | undefined;
   pod_agent_layer_sandbox_info: TSandboxResourceInfo | undefined;
   logbroker_tools_sandbox_info: TSandboxResourceInfo | undefined;
   dynamic_resource_updater_sandbox_info: TSandboxResourceInfo | undefined;
   coredump_tools_sandbox_info: TSandboxResourceInfo | undefined;
   gdb_layer_sandbox_info: TSandboxResourceInfo | undefined;
   deploy_settings: TDeployUnitSpec_TDeploySettings | undefined;
   /**
    *  Spec patchers revision
    */
   patchers_revision: number;
   /**
    *  Bring dynamic resource updater sidecar to boxes
    */
   enable_dynamic_resource_updater: boolean;
   infra_components: TInfraComponents | undefined;
   /**
    *  Enable portoworkload metrics gathering for infra sidecars
    */
   collect_portometrics_from_sidecars: boolean;
}

export interface TDeployUnitSpec_TReplicaSetDeploy {
   replica_set_template: TReplicaSetSpec | undefined;
   per_cluster_settings: { [key: string]: TDeployUnitSpec_TReplicaSetDeploy_TPerClusterSettings };
}

export interface TDeployUnitSpec_TReplicaSetDeploy_TPerClusterSettings {
   pod_count: number | undefined;
   /**
    *  Will spawn horizontal pod autoscaler above replica set
    */
   autoscale: TReplicaSetScaleSpec | undefined;
   /**
    *  If present, override replica_set_template.deployment_strategy value.
    */
   deployment_strategy: TReplicaSetSpec_TDeploymentStrategy | undefined;
}

export interface TDeployUnitSpec_TReplicaSetDeploy_PerClusterSettingsEntry {
   key: string;
   value: TDeployUnitSpec_TReplicaSetDeploy_TPerClusterSettings | undefined;
}

export interface TDeployUnitSpec_TMultiClusterReplicaSetDeploy {
   replica_set: TMultiClusterReplicaSetSpec | undefined;
}

export interface TDeployUnitSpec_TEndpointSetTemplate {
   port: number;
   protocol: string;
   liveness_limit_ratio: number;
   id: string;
}

export interface TDeployUnitSpec_ImagesForBoxesEntry {
   key: string;
   value: TDockerImageDescription | undefined;
}

export interface TDeployUnitSpec_BoxJugglerConfigsEntry {
   key: string;
   value: TBoxJugglerConfig | undefined;
}

export interface TDeployUnitSpec_LogrotateConfigsEntry {
   key: string;
   value: TLogrotateConfig | undefined;
}

export interface TDeployUnitSpec_CoredumpConfigEntry {
   key: string;
   value: TCoredumpPolicy | undefined;
}

export interface TDeployUnitSpec_TClusterSettings {
   yp_cluster: string;
   need_approval: boolean;
}

export interface TDeployUnitSpec_TDeploySettings {
   cluster_sequence: TDeployUnitSpec_TClusterSettings[];
   deploy_strategy: TDeployUnitSpec_TDeploySettings_EDeployStrategy;
}

export enum TDeployUnitSpec_TDeploySettings_EDeployStrategy {
   SEQUENTIAL = 'sequential',
   PARALLEL = 'parallel',
}

export interface TBoxJugglerConfig {
   /**
    *  Tarballs with user's checks (may be compressed).
    */
   archived_checks: TDownloadableResource[];
   /**
    *  Juggler agent binary resource.
    *  Empty juggler_agent_binary will be replace by default
    */
   juggler_agent_binary: TDownloadableResource | undefined;
   /**
    *  juggler-client will listen on this port
    */
   port: number;
}

export interface TDeployUnitStatus {
   /**
    *  Spec that is currently being deployed. May be older than contents of TStageSpec.
    */
   current_target: TDeployUnitSpec | undefined;
   /**
    *  Deploy of current_target has started, but has not completed yet.
    */
   in_progress: TCondition | undefined;
   /**
    *  Deploy of current_target has been completed.
    *  May switch back to false if something breaks later.
    */
   ready: TCondition | undefined;
   /**
    *  Deploy of current_target has started, has not completed yet and had error during start.
    */
   failed: TCondition | undefined;
   /**
    *  Summary of deploy progress.
    */
   progress: TDeployProgress | undefined;
   /**
    *  Revision of stage from which 'current_target' was derived.
    */
   target_revision: number;
   /**
    *  YP timestamp of stage spec from which 'current_target' was derived.
    */
   target_spec_timestamp: number;
   /**
    *  User-specified itype if unit spec has one, controller-generated default otherwise.
    *  Current default is "deploy".
    */
   yasm_itype: string;
   /**
    *  Currently applied spec patchers revision
    */
   patchers_revision: number;
   replica_set: TDeployUnitStatus_TReplicaSetDeploy | undefined;
   multi_cluster_replica_set: TDeployUnitStatus_TMultiClusterReplicaSetDeploy | undefined;
   latest_deployed_revision: number;
   deploy_unit_timeline: TDeployUnitStatus_TDeployUnitTimeline | undefined;
}

export interface TDeployUnitStatus_TReplicaSetDeploy {
   /**
    *  <cluster id> -> <cluster status>.
    */
   cluster_statuses: { [key: string]: TDeployUnitStatus_TReplicaSetDeploy_TPerClusterStatus };
}

export interface TDeployUnitStatus_TReplicaSetDeploy_TPerClusterStatus {
   /**
    *  Created replica set id in this cluster.
    */
   replica_set_id: string;
   /**
    *  Deprecated.
    */
   endpoint_set_id: string;
   /**
    *  Created horizontal pod autoscaler id in this cluster.
    */
   horizontal_pod_autoscaler_id: string;
   /**
    *  Created endpoint sets in this cluster.
    */
   endpoint_set_ids: string[];
   /**
    *  Last known replica set status.
    */
   status: TReplicaSetStatus | undefined;
}

export interface TDeployUnitStatus_TReplicaSetDeploy_ClusterStatusesEntry {
   key: string;
   value: TDeployUnitStatus_TReplicaSetDeploy_TPerClusterStatus | undefined;
}

export interface TDeployUnitStatus_TMultiClusterReplicaSetDeploy {
   /**
    *  Created multi cluster replica set id.
    */
   replica_set_id: string;
   /**
    *  <cluster id> -> <cluster status>.
    */
   cluster_statuses: { [key: string]: TDeployUnitStatus_TMultiClusterReplicaSetDeploy_TPerClusterStatus };
}

export interface TDeployUnitStatus_TMultiClusterReplicaSetDeploy_TPerClusterStatus {
   /**
    *  Deprecated.
    */
   endpoint_set_id: string;
   /**
    *  Created endpoint sets in this cluster.
    */
   endpoint_set_ids: string[];
}

export interface TDeployUnitStatus_TMultiClusterReplicaSetDeploy_ClusterStatusesEntry {
   key: string;
   value: TDeployUnitStatus_TMultiClusterReplicaSetDeploy_TPerClusterStatus | undefined;
}

export interface TDeployUnitStatus_TDeployUnitTimeline {
   target_revision: number;
   /**
    *  start time of deploying in milliseconds
    */
   start_timestamp: number;
   /**
    *  finish time of deploying in milliseconds
    */
   finish_timestamp: number;
   status: TDeployUnitStatus_TDeployUnitTimeline_EStatus;
   /**
    *  same as ready
    */
   latest_ready_condition: TCondition | undefined;
   latest_deployed_revision: number;
}

export enum TDeployUnitStatus_TDeployUnitTimeline_EStatus {
   DEPLOYING = 'deploying',
   DEPLOYED = 'deployed',
}

export interface TDeployUnitOverrides {
   per_cluster_overrides: { [key: string]: TDeployUnitOverrides_TPerClusterOverrides };
   revision_to_override: number;
   deploy_settings_override: TDeployUnitOverrides_TDeploySettingsOverride | undefined;
}

export interface TDeployUnitOverrides_TPerClusterOverrides {
   max_unavailable: TDeployUnitOverrides_TPerClusterOverrides_TNumericOverride | undefined;
}

export interface TDeployUnitOverrides_TPerClusterOverrides_TNumericOverride {
   value: number;
   author: string;
}

export interface TDeployUnitOverrides_TDeploySettingsOverride {
   author: string;
   approval_time: Date | { nanos: number; seconds: number } | undefined;
   deploy_settings: TDeployUnitSpec_TDeploySettings | undefined;
}

export interface TDeployUnitOverrides_PerClusterOverridesEntry {
   key: string;
   value: TDeployUnitOverrides_TPerClusterOverrides | undefined;
}

export interface TDeployUnitApproval {
   user: TDeployUnitApproval_TUserApproval | undefined;
   payload: TDeployUnitApproval_TApprovalPayload | undefined;
}

export interface TDeployUnitApproval_TUserApproval {
   login: string;
   status: TDeployUnitApproval_TUserApproval_EUserApprovalStatus;
   approval_time: Date | { nanos: number; seconds: number } | undefined;
}

export enum TDeployUnitApproval_TUserApproval_EUserApprovalStatus {
   NONE = 'none',
   DISAPPROVED = 'disapproved',
   APPROVED = 'approved',
}

export interface TDeployUnitApproval_TApprovalPayload {
   revision: number;
   cluster: string;
   deploy_unit: string;
}

/**
 *  Control
 */
export interface TStageControl {
   /**
    *  TODO(deep): extract nested messages and convert to ControlBase
    */
   add_deploy_child: TAddDeployChild | undefined;
   remove_deploy_child: TRemoveDeployChild | undefined;
   add_secret_delegation: TAddSecretDelegation | undefined;
   remove_secret_delegation: TRemoveSecretDelegation | undefined;
   approve: TStageControl_TApproveAction | undefined;
   disapprove: TStageControl_TDisapproveAction | undefined;
   override_deployment_strategy: TStageControl_TOverrideDeploymentStrategy | undefined;
}

export interface TStageControl_TActionOptions {
   revision: number;
   cluster: string;
   deploy_unit: string;
}

export interface TStageControl_TApproveAction {
   options: TStageControl_TActionOptions | undefined;
}

export interface TStageControl_TDisapproveAction {
   options: TStageControl_TActionOptions | undefined;
}

export interface TStageControl_TOverrideDeploymentStrategy {
   max_unavailable: TStageControl_TOverrideDeploymentStrategy_TDeploymentStrategyValue | undefined;
   deploy_settings: TStageControl_TOverrideDeploymentStrategy_TOverrideDeploySettings | undefined;
}

export interface TStageControl_TOverrideDeploymentStrategy_TDeploymentStrategyValue {
   deploy_unit_id: string;
   clusters: string[];
   revision: number;
   value: number;
}

export interface TStageControl_TOverrideDeploymentStrategy_TDeploySettingValue {
   revision: number;
   settings: TDeployUnitSpec_TDeploySettings | undefined;
}

export interface TStageControl_TOverrideDeploymentStrategy_TOverrideDeploySettings {
   deploy_settings: { [key: string]: TStageControl_TOverrideDeploymentStrategy_TDeploySettingValue };
}

export interface TStageControl_TOverrideDeploymentStrategy_TOverrideDeploySettings_DeploySettingsEntry {
   key: string;
   value: TStageControl_TOverrideDeploymentStrategy_TDeploySettingValue | undefined;
}

/**
 *  https://wiki.yandex-team.ru/passport/tvm2/abc/
 */
export interface TTvmApp {
   app_id: number;
   alias: string;
   /**
    *  ABC service to which this app is assigned.
    *  Used only as metadata to be displayed in GUI/yaml.
    */
   abc_service_id: string;
}

export interface TTvmClient {
   /**
    *  secret_selector is used for generating secret env var with
    *  predefined name TVM_CLIENT_SECRET. TVM_CLIENT_SECRET env var is written
    *  to tvmtool's workload spec only and used for generating tvmtool config.
    *  Also secret_selector.alias is the key of secret in TPodSpec.secrets.
    */
   secret_selector: SecretSelector | undefined;
   source: TTvmApp | undefined;
   destinations: TTvmApp[];
   roles_for_idm_slug: string;
}

/**
 *  Config for tvmtool.
 *  See https://wiki.yandex-team.ru/deploy/docs/sidecars/tvmtool for details.
 */
export interface TTvmConfig {
   mode: TTvmConfig_EMode;
   /**
    *  Blackbox instances to check tickets.
    *  See https://wiki.yandex-team.ru/passport/tvm2/tvm-daemon/#opisanieformatakonfiganajsonschema for available values.
    */
   blackbox_environment: string;
   clients: TTvmClient[];
   /**
    *  Port number on which tvmtool listens. It binds to loopback interface only.
    *  If unset, port 2 will be used - https://wiki.yandex-team.ru/deploy/docs/#portyvpodezanjatyeinfrastrukturojj.
    */
   client_port: number;
   /**
    *  Custom tvmtool layer. For development purposes only.
    */
   tvmtool_layer: TDownloadableResource | undefined;
   /**
    *  Box CPU limit 1 = 0.001
    */
   cpu_limit: number;
   /**
    *  Box Memory limit mebibyte
    */
   memory_limit_mb: number;
   /**
    *  Solomon section
    */
   stage_tvm_id: number;
   solomon_tvm_id: number;
   monitoring_port: number;
   /**
    *  Disk volume settings for sidecar
    */
   sidecar_volume: TSidecarVolume | undefined;
   use_system_certs: boolean;
}

export enum TTvmConfig_EMode {
   UNKNOWN = 'unknown',
   DISABLED = 'disabled',
   ENABLED = 'enabled',
}

export interface TSandboxResourceInfo {
   revision: number;
   override: { [key: string]: string };
}

export interface TSandboxResourceInfo_OverrideEntry {
   key: string;
   value: string;
}

export interface TLogbrokerConfig {
   /**
    *  Custom push agent. For development purposes only.
    */
   push_agent_layer: TDownloadableResource | undefined;
   sidecar_bringup_mode: TLogbrokerConfig_ESidecarBringupMode;
   /**
    *  Disk volume settings for sidecar
    */
   sidecar_volume: TSidecarVolume | undefined;
   /**
    *  Disk volume id where portolog files should be stored
    */
   logs_virtual_disk_id_ref: string;
   destroy_policy: TLogbrokerConfig_TLogbrokerDestroyPolicy | undefined;
   communal_topic_request: TLogbrokerConfig_TLogbrokerCommunalTopicRequest | undefined;
   custom_topic_request: TLogbrokerConfig_TLogbrokerCustomTopicRequest | undefined;
   pod_additional_resources_request: TPodSpec_TResourceRequests | undefined;
}

/**
 * UNKNOWN -  empty
 *
 * DEFAULT -  bring up logbroker sidecar only if standart stdout/stderr logs transfer is enabled
 *
 * MANDATORY -  bring up logbroker sidecar always
 *
 */
export enum TLogbrokerConfig_ESidecarBringupMode {
   UNKNOWN = 'unknown',
   DEFAULT = 'default',
   MANDATORY = 'mandatory',
}

export interface TLogbrokerConfig_TLogbrokerDestroyPolicy {
   /**
    *  missing or equal to 0 would be interpreted as 3 (default value)
    */
   max_tries: number;
   /**
    *  minimal and default value is 10000 (10 sec). Value less than minimal - validation error
    */
   restart_period_ms: number;
}

export interface TLogbrokerConfig_TLogbrokerCommunalTopicRequest {}

export interface TLogbrokerConfig_TLogbrokerCustomTopicRequest {
   tvm_client_id: number;
   topic_name: string;
   secret_selector: SecretSelector | undefined;
}

/**
 * Config for rotates, compresses, and mails system logs (linux logrotate tool)
 */
export interface TLogrotateConfig {
   raw_config: string;
   run_period_millisecond: number;
}

/**
 *  Coredump config
 */
export interface TCoredumpAggregator {
   enabled: boolean;
   /**
    *  URL to aggregator, use https://coredumps.n.yandex-team.ru/submit_core by default
    */
   url: string;
   /**
    *   Specify service name tag for trace, use "deploy.stageId.workloadId" by default
    */
   service_name: string;
   /**
    *  Specify ctype tag for trace, empty by default
    */
   ctype: string;
}

export interface TCoredumpProcessor {
   /**
    *  Limit on coredumps stored count
    */
   count_limit: number;
   /**
    *  Limit on coredumps stored size in megabytes
    */
   total_size_limit_megabytes: number;
   /**
    *  Save core with specified probability
    */
   probability: number;
   aggregator: TCoredumpAggregator | undefined;
   /**
    *  We can remove old coredumps when writing new one if total size limit exceeded or count limit exceeded.
    *  But we want to avoid too frequent coredumps creation and disk pressure if user's process is indefinitely
    *  crashing immediately after start. So we will remove old coredump and free up space for the new one only
    *  if old coredump was created earlier than "current_time - cleanup_ttl_seconds"
    */
   cleanup_ttl_seconds: number;
   /**
    *  Specify custom path for storing coredumps
    */
   output: string | undefined;
   /**
    *  Specify volume id for storing coredumps, volume should be mounted to box where workload with enabled coredump
    */
   volume_id: string | undefined;
}

export interface TCoredumpPolicy {
   /**
    *  Instancectl coredump settings
    */
   coredump_processor: TCoredumpProcessor | undefined;
}

export interface TInfraComponents {
   update_policy: TInfraComponents_EUpdatePolicy;
   /**
    *  update components automatically on stagectl side if explicit_update_timestamp stale
    */
   allow_automatic_updates: boolean;
}

/**
 * UNKNOWN -  empty
 *
 * BETA -  for developers purpose only
 *
 * TESTING -  dogfooding
 *
 * PRESTABLE -  test stages including acceptance-xdc and sas-test
 *
 * STABLE -  user facing stages
 *
 */
export enum TInfraComponents_EUpdatePolicy {
   UNKNOWN = 'unknown',
   BETA = 'beta',
   TESTING = 'testing',
   PRESTABLE = 'prestable',
   STABLE = 'stable',
}
