/* eslint-disable */

export enum StoragePolicy {
   SPEC_HQ_STATUS_HQ = 0,
   SPEC_YP_STATUS_HQ = 1,
}

/**
 *  Labels are key value pairs that may be used to scope and select individual resources.  */
export interface Label {
   name: string;
   value: string;
}

/**
 *  Annotations are unstructured key value data stored with a resource that may be set by external tooling.  */
export interface Annotation {
   name: string;
   value: string;
}

/**
 *  Condition of some object  */
export interface Condition {
   /**
    *  True, False, Unknown
    */
   status: string;
   /**
    *  One word (e.g. ProcessCrash) for computers and short summary
    */
   reason: string;
   /**
    *  Some human readable message
    */
   message: string;
   last_transition_time: Date | { nanos: number; seconds: number } | undefined;
}

export interface KeychainSecret {
   keychain_id: string;
   secret_id: string;
   secret_revision_id: string;
}

export interface SecretVolume {
   /**
    *  [(field_schema.title) = "NannyVault secret name"];
    */
   secret_name: string;
   keychain_secret: KeychainSecret | undefined;
}

export interface VaultSecretVolume {
   /**
    *  [(field_schema.title) = "YaVault secret"];
    */
   vault_secret: VaultSecret | undefined;
}

export interface VaultSecret {
   secret_name: string;
   secret_id: string;
   secret_ver: string;
   delegation_token: string;
}

export interface VaultSecretEnvSelector {
   /**
    *  [(field_schema.title) = "Field to extract from YaVault secret"];
    */
   field: string;
   /**
    *  [(field_schema.title) = "YaVault secret"];
    */
   vault_secret: VaultSecret | undefined;
}

export interface Template {
   src_path: string;
   dst_path: string;
}

export interface TemplateVolume {
   template: Template[];
}

export interface ItsVolume {
   its_url: string;
   /**
    *  Poll period (in seconds)
    */
   period_seconds: number;
   /**
    *  Max retry period (in seconds)
    */
   max_retry_period_seconds: number;
   /**
    *  Symlink volume to /dev/shm
    */
   use_shared_memory: boolean;
}

export interface Volume {
   name: string;
   version: string;
   type: Volume_VolumeSourceType;
   secret_volume: SecretVolume | undefined;
   vault_secret_volume: VaultSecretVolume | undefined;
   template_volume: TemplateVolume | undefined;
   its_volume: ItsVolume | undefined;
}

export enum Volume_VolumeSourceType {
   SECRET = 0,
   TEMPLATE = 1,
   ITS = 2,
   VAULT_SECRET = 3,
}

export interface SecretEnvSelector {
   /**
    *     option (nanny.schema.description) = "Source to set process environment variable from Vault secret";
    */
   secret_name: string;
   /**
    *  [(field_schema.title) = "Field to extract from secret"];
    */
   field: string;
   keychain_secret: KeychainSecret | undefined;
}

export interface LiteralEnvSelector {
   /**
    *     option (message_schema.description) = "Set process environment variable equal to literal value";
    */
   value: string;
}

export interface EnvVarSource {
   /**
    *  [(field_schema.title) = "Source type (union trick)"];
    */
   type: EnvVarSource_SourceType;
   /**
    *  [(field_schema.title) = "Set variable from NannyVault secrets storage"];
    */
   secret_env: SecretEnvSelector | undefined;
   /**
    *  [(field_schema.title) = "Set variable from YaVault secrets storage"];
    */
   vault_secret_env: VaultSecretEnvSelector | undefined;
   /**
    *  [(field_schema.title) = "Set variable equal to literal value"];
    */
   literal_env: LiteralEnvSelector | undefined;
}

/**
 *     option (message_schema.description) = "Source from which to set process environment variable";
 */
export enum EnvVarSource_SourceType {
   SECRET_ENV = 0,
   VAULT_SECRET_ENV = 2,
   LITERAL_ENV = 1,
}

export interface EnvVar {
   /**
    *     option (message_schema.description) = "Environment variable for process";
    */
   name: string;
   /**
    *  [(field_schema.title) = "Take variable value from this"];
    */
   value_from: EnvVarSource | undefined;
}

export interface RestartPolicy {
   type: RestartPolicy_RestartPolicyType;
   /**
    *  Min period (in seconds)
    */
   min_period_seconds: number;
   /**
    *  Max period (in seconds)
    */
   max_period_seconds: number;
   /**
    *  Period backoff
    */
   period_backoff: number;
   /**
    *  Period jitter seconds
    */
   period_jitter_seconds: number;
}

export enum RestartPolicy_RestartPolicyType {
   ALWAYS = 0,
   ON_FAILURE = 1,
   NEVER = 2,
}

export interface Lifecycle {
   pre_stop: Handler | undefined;
   /**
    *  Time after pre_stop handler has been executed before sending TERM signal
    */
   stop_grace_period_seconds: number;
   /**
    *  Time after TERM signal sent before sending KILL signal
    */
   termination_grace_period_seconds: number;
   /**
    *  [(field_schema.title) = "How to process TERM singal barrier"];
    */
   term_barrier: Lifecycle_TermBarrier;
}

/**
 * IGNORE -  Don't sync TERM signals sending
 *
 * WAIT -  Wait for pre stop actions and stop grace periods of ALL the containers to expire
 *
 */
export enum Lifecycle_TermBarrier {
   IGNORE = 0,
   WAIT = 1,
}

export interface SecurityContext {
   capabilities: string[];
   run_as_user: string;
   porto_access_policy: string;
}

export interface CoredumpPolicy {
   type: CoredumpPolicy_Type;
   coredump_processor: CoredumpProcessor | undefined;
   custom_processor: CustomCommandCoredumpProcessor | undefined;
}

export enum CoredumpPolicy_Type {
   NONE = 0,
   COREDUMP = 1,
   CUSTOM_CORE_COMMAND = 2,
}

export interface CustomCommandCoredumpProcessor {
   command: string;
}

export interface CoredumpProcessor {
   path: string;
   count_limit: number;
   total_size_limit: number;
   probability: number;
   aggregator: CoredumpAggregator | undefined;
   cleanup_policy: CoredumpCleanupPolicy | undefined;
}

export interface CoredumpAggregator {
   type: CoredumpAggregator_Type;
   saas: SaasCoredumpAggregator | undefined;
}

export enum CoredumpAggregator_Type {
   DISABLED = 0,
   SAAS_AGGREGATOR = 1,
}

export interface SaasCoredumpAggregator {
   url: string;
   service_name: string;
   gdb: CoredumpAggregatorGdb | undefined;
}

export interface CoredumpAggregatorGdb {
   exec_path: string;
}

export interface CoredumpCleanupPolicy {
   type: CoredumpCleanupPolicy_Type;
   ttl: CoredumpCleanupPolicyTtl | undefined;
}

export enum CoredumpCleanupPolicy_Type {
   DISABLED = 0,
   TTL = 1,
}

export interface CoredumpCleanupPolicyTtl {
   seconds: number;
}

export interface CpuPolicy {
   type: CpuPolicy_Type;
}

export enum CpuPolicy_Type {
   normal = 0,
   high = 1,
   batch = 2,
   idle = 3,
   rt = 4,
}

export interface Container {
   /**
    *     option (message_schema.description) = "Container (section) description";
    */
   name: string;
   /**
    *  [(field_schema.title) = "Environment variables configuration"];
    */
   env: EnvVar[];
   /**
    *  [(field_schema.title) = "Command to run in container"];
    */
   command: string[];
   /**
    *  [(field_schema.title) = "How to check container readiness"];
    */
   readiness_probe: Probe | undefined;
   restart_policy: RestartPolicy | undefined;
   lifecycle: Lifecycle | undefined;
   resource_allocation: ResourceAllocation | undefined;
   security_context: SecurityContext | undefined;
   reopen_log_action: ReopenLogAction | undefined;
   coredump_policy: CoredumpPolicy | undefined;
   cpu_policy: CpuPolicy | undefined;
}

export interface ReopenLogAction {
   handler: Handler | undefined;
   resource_allocation: ResourceAllocation | undefined;
}

export interface Probe {
   handlers: Handler[];
   /**
    *  Length of time before health checking is activated. In seconds.
    */
   initial_delay_seconds: number;
   /**
    *  Min period (in seconds)
    */
   min_period_seconds: number;
   /**
    *  Max period (in seconds)
    */
   max_period_seconds: number;
   /**
    *  Period backoff
    */
   period_backoff: number;
   /**
    *  Minimum consecutive successes for the probe to be considered successful after having failed.
    *  Must be 1 for liveness.
    */
   success_threshold: number;
   /**
    *  Minimum consecutive failures for the probe to be considered failed after having succeeded.
    */
   failure_threshold: number;
}

/**
 *  HTTPHeader describes a custom header to be used in HTTP probes
 */
export interface HTTPHeader {
   /**
    *  The header field name
    */
   name: string;
   /**
    *  The header field value
    */
   value: string;
}

export interface HTTPGetAction {
   /**
    *  Path to access on the HTTP server.
    */
   path: string;
   /**
    *  Name or number of the port to access on the container.
    */
   port: string;
   /**
    *  Host name to connect to, defaults to the container IP. You
    *  probably want to set "Host" in httpHeaders instead.
    */
   host: string;
   /**
    *  Scheme to use for connecting to the host, defaults to HTTP.
    */
   uri_scheme: string;
   /**
    *  Custom headers to set in the request. HTTP allows repeated headers.
    */
   http_headers: HTTPHeader[];
}

export interface TCPSocketAction {
   /**
    *  Port to connect to.
    */
   port: string;
   /**
    *  Host name to connect to, defaults to the container IP.
    */
   host: string;
}

export interface ExecAction {
   command: string[];
}

/**
 *  Handler defines a specific action that should be taken
 */
export interface Handler {
   type: Handler_HandlerType;
   /**
    *  Exec specifies the action to take.
    */
   exec_action: ExecAction | undefined;
   /**
    *  HTTPGet specifies the http request to perform.
    */
   http_get: HTTPGetAction | undefined;
   /**
    *  TCPSocket specifies an action involving a TCP port.
    */
   tcp_socket: TCPSocketAction | undefined;
}

export enum Handler_HandlerType {
   NONE = 0,
   EXEC = 1,
   TCP_SOCKET = 2,
   HTTP_GET = 3,
}

/**
 *  Process exit status detailed information, see "man 2 wait" for details  */
export interface ExitStatus {
   if_exited: boolean;
   exit_status: number;
   if_signaled: boolean;
   term_signal: number;
   coredumped: boolean;
}

/**
 *  Information about last container termination  */
export interface LastTerminationStatus {
   exit_status: ExitStatus | undefined;
   /**
    *  Last bytes of container stderr
    */
   stderr_tail: Uint8Array;
   /**
    *  Last bytes of container stdout
    */
   stdout_tail: Uint8Array;
   start_time: Date | { nanos: number; seconds: number } | undefined;
   termination_time: Date | { nanos: number; seconds: number } | undefined;
}

/**
 *  Observed container status  */
export interface ContainerStatus {
   /**
    *  Section name from instancectl.conf
    */
   name: string;
   ready: Condition | undefined;
   installed: Condition | undefined;
   restart_count: number;
   last_termination_status: LastTerminationStatus | undefined;
}

export interface InstanceMeta {
   id: string;
   service_id: string;
   version: string;
   generation: number;
   labels: Label[];
   annotations: Annotation[];
   storage_policy: StoragePolicy;
}

/**
 *  Network port request for instance  */
export interface PortRequirement {
   name: string;
   protocol: string;
}

/**
 *  Allocated port used by instance  */
export interface Port {
   /**
    *  Port name, e.g. "rpc" or "web".
    */
   name: string;
   /**
    *  Port value
    */
   port: number;
   /**
    *  Port protocol, one of: "TCP" or "UDP".
    */
   protocol: string;
}

/**
 *  Scalar resource value  */
export interface Scalar {
   value: number;
}

/**
 *  Compute resource description  */
export interface ComputeResource {
   /**
    *  Resource name, e.g. "cpu", "ram"...
    */
   name: string;
   type: ComputeResource_Type;
   /**
    *  Value of resource
    */
   scalar: Scalar | undefined;
}

export enum ComputeResource_Type {
   SCALAR = 0,
}

/**
 *  Instance resource requirements (in future could be used per container.)  */
export interface ResourceRequest {
   /**
    *  Maximum allowed resource consumption
    */
   limit: ComputeResource[];
   /**
    *  Minimum guaranteed resources
    */
   request: ComputeResource[];
   /**
    *  Port request
    */
   port: PortRequirement[];
}

/**
 *  Instance resource allocation received from resource requirement for particular instance on a node  */
export interface ResourceAllocation {
   /**
    *  Maximum allowed resource consumption
    */
   limit: ComputeResource[];
   /**
    *  Minimum guaranteed resources
    */
   request: ComputeResource[];
   /**
    *  Allocated ports for instance
    */
   port: Port[];
}

/**
 *  Status in which revision should be present on a node in a cluster  */
export interface RevisionTargetStatus {
   /**
    *  One of: "Active", "Prepared"
    */
   status: string;
   last_modification_time: Date | { nanos: number; seconds: number } | undefined;
}

export interface NotifyAction {
   handlers: Handler[];
   resource_allocation: ResourceAllocation | undefined;
}

/**
 *  Container hostname may change and we have to check if we are trying to overwrite new version with old version  */
export interface HostnameVersion {
   /**
    *  For gencfg release stable-102-r304 version will be: major=102, minor=304
    */
   major: number;
   /**
    *  gencfg revision (0 for gencfg trunk)
    */
   minor: number;
}

/**
 *  Describes instance revision  */
export interface InstanceRevision {
   /**
    *  Unique identifier
    */
   id: string;
   /**
    *  Target state
    */
   target: RevisionTargetStatus | undefined;
   /**
    *  Containers definitions
    */
   container: Container[];
   /**
    *  Volumes definitions
    */
   volume: Volume[];
   /**
    *  Oldstyle gencfg instance tags
    */
   tags: string[];
   /**
    *  Shard name from gencfg (see JUGGLER-2402 for details)
    */
   shard_name: string;
   /**
    *  [(field_schema.title) = "Instance init containers (will be run before instance start)"];
    */
   init_containers: Container[];
   type: InstanceRevision_InstanceType;
   work_dir: string;
   notify_action: NotifyAction | undefined;
   hostname: string;
}

export enum InstanceRevision_InstanceType {
   NO_SUBCONTAINERS = 0,
   APP_CONTAINER = 1,
   OS_CONTAINER = 2,
}

/**
 *  Instance specification  */
export interface InstanceSpec {
   /**
    *  Resources requested by this instance (used in scheduler)
    */
   resource_request: ResourceRequest | undefined;
   /**
    *  Allocated resources (set by scheduler)
    */
   allocation: ResourceAllocation | undefined;
   /**
    *  Host on which instances will be started (set by scheduler)
    *  We use term "node" to specify that it is physical machine name (opposed to host, if we use IP per instance)
    */
   node_name: string;
   /**
    *  Revisions present on host
    */
   revision: InstanceRevision[];
   /**
    *  Specifies the host name of instance (if we use network isolation)
    */
   hostname: string;
   hostname_version: HostnameVersion | undefined;
}

/**
 *  Observed status of particular instance revision  */
export interface RevisionStatus {
   /**
    *  Revision identifier
    */
   id: string;
   /**
    *  True if revision is installed
    */
   installed: Condition | undefined;
   /**
    *  True if revision is ready
    */
   ready: Condition | undefined;
   container: ContainerStatus[];
}

/**
 *  Observed instance status  */
export interface InstanceStatus {
   last_heartbeat_time: Date | { nanos: number; seconds: number } | undefined;
   /**
    *  Condition is "True" if any revision is ready
    */
   ready: Condition | undefined;
   revision: RevisionStatus[];
}

/**
 *  A group of containers prepared/run as one  */
export interface Instance {
   meta: InstanceMeta | undefined;
   spec: InstanceSpec | undefined;
   status: InstanceStatus | undefined;
}
