/* eslint-disable */

export enum EHistoryTime {
   HT_TRANSACTION_COMMIT_START = 0,
   HT_TRANSACTION_START = 1,
}

export enum EHistoryStatus {
   HS_UNKNOWN = 0,
   HS_ENABLE = 1,
   HS_DISABLE = 2,
}

/**
 * GP_MANUAL -  Default. The field value is only manually assigned. Note: other policies still allow
 *  a manual override; they apply only when an explicit value is not provided.
 *
 * GP_RANDOM -  The field value will be randomly generated.
 *
 * GP_TIMESTAMP -  The field value will be assigned from a current YT timestamp.
 *  Monotonic, noncontiguous, with a small performance hit.
 *
 * GP_BUFFERED_TIMESTAMP -  The field value will be assigned from a buffered YT timestamp.
 *  Nonmonotonic within 1 second, noncontiguous, very fast.
 *  Turn on transaction_manager/timestamp_buffer_enabled in master config before use.
 *
 * GP_INDEXED_INCREMENT -  The field value will be assigned by looking up the largest value and incrementing it by 1.
 *  The field must be indexed or be the primary key.
 *  Monotonic, contiguous, slow, contentious. Simultaneous writes will have only one winner;
 *  retry the loser.
 *
 */
export enum EGenerationPolicy {
   GP_UNDEFINED = 0,
   GP_MANUAL = 1,
   GP_RANDOM = 2,
   GP_TIMESTAMP = 3,
   GP_BUFFERED_TIMESTAMP = 4,
   GP_INDEXED_INCREMENT = 5,
}

export interface TWatchLogOption {
   snake_case_name: string;
   filter: string;
   selectors: string[];
}

export interface TObjectTypeOption {
   /**
    *  Snake case names of fields in /meta comprising the primary key, in order.
    */
   primary_key: string[];
   camel_case_name: string;
   snake_case_name: string;
   type_value: number;
   human_readable_name: string;
   parent: string;
   hash_expression: string;
   watch_logs: TWatchLogOption[];
   meta_base_message_type_name: string;
   control_base_message_type_name: string;
   spec_message_type_name: string;
   status_message_type_name: string;
   /**
    *  Allows to work with /meta/name, which is used for better error formatting
    *  and can be used in other contexts as an object name as well.
    */
   name_supported: boolean;
   history_indexed_attributes: string[];
}

export interface TIndexOption {
   object_type_snake_case_name: string;
   camel_case_name: string;
   snake_case_name: string;
   key: string[];
   hash_expression: string;
   mode: TIndexOption_EIndexMode;
   unique: boolean;
}

export enum TIndexOption_EIndexMode {
   IM_DISABLED = 0,
   IM_BUILDING = 1,
   IM_ENABLED = 2,
}
