import { isEmpty } from '@yandex-infracloud-ui/libs';
import { useEffect } from 'react';
import { useDispatch, useSelector } from 'react-redux';

import { fetchAbcService, getAbcService } from '../../old-code/store/reducers/abc';
import type { RootState } from '../store';

export interface AbcService {
   id: number;
   _id: number;
   name: string;
   slug: string;
}

/**
 * Пытается взять уже загруженный abc сервис из хранилища redux
 *
 * Если его там нет - инициирует его загрузку в него при необходимости
 *
 * @param abcId ID сервиса // 3494 - Я.Деплой
 */
export function useAbcService(abcId: string | null, readonly = false): AbcService | null {
   const abcService = useSelector(s => {
      if (abcId === null) {
         return null;
      }
      const service = getAbcService(s as RootState, abcId) as AbcService | undefined;

      return isEmpty(service) ? null : service;
   });

   const dispatch = useDispatch();

   useEffect(() => {
      // Загрузка сервиса по его ID (если его еще нет в redux-store)
      if (abcId !== null && !abcService && !readonly) {
         dispatch(fetchAbcService({ params: { serviceId: abcId } }));
      }
   }, [dispatch, abcService, abcId, readonly]);

   return abcService;
}
