import { isEqual } from '@yandex-infracloud-ui/libs';
import { useEffect, useRef } from 'react';
import { shallowEqual, useSelector } from 'react-redux';
import type { RootState } from '../store';

export function useDeepEqualSelector<T>(selector: (s: RootState) => T): T {
   const value = useSelector(selector, shallowEqual);
   const valueRef = useRef(value);

   useEffect(() => {
      if (!isEqual(value, valueRef.current)) {
         valueRef.current = value;
      }
   }, [value]);

   return valueRef.current;
}
