import { DeployTicketConverter } from '../../models/ui';
import { useApprovalPermissions } from './useApprovalPermissions';
import { useApprovalPolicy } from './useApprovalPolicy';
import { useDeployTicket } from './useDeployTicket';

export function useDeployTicketData(ticketId: string) {
   const { deployTicket } = useDeployTicket(ticketId);

   const stageId = deployTicket?.stageId ?? '';

   const approvalPermissions = useApprovalPermissions({
      stageIds: [stageId],
      logins: deployTicket ? [...DeployTicketConverter.getApproveLogins([deployTicket])] : [],
   });

   const { approvalPolicySpec } = useApprovalPolicy(stageId);

   return { approvalPermissions, approvalPolicySpec };
}
