import { useMemo } from 'react';
import { DeployUnit } from '../../models/ui';
import { DeployUnitStatus, DuStatusLabel } from '../../models/ui/stage/DeployUnit/DeployUnitStatusConverter';
import { useStage } from './useStage';

interface UseDeployUnitResult {
   deployUnit: DeployUnit | null;
   deployUnitStatus: DeployUnitStatus | null;
   deployUnitStatusLabel: DuStatusLabel | null;
}

export function useDeployUnit(stageId: string, duId: string): UseDeployUnitResult {
   const { stage, stageStatus, stageStatusLabel } = useStage(stageId);

   const deployUnit = useMemo(() => stage?.deployUnits.find(du => du.id === duId) ?? null, [duId, stage?.deployUnits]);
   const deployUnitStatus = useMemo(() => stageStatus?.deployUnits.get(duId) ?? null, [duId, stageStatus?.deployUnits]);
   const deployUnitStatusLabel = useMemo(() => stageStatusLabel?.deployUnitLabels.get(duId) ?? null, [
      duId,
      stageStatusLabel?.deployUnitLabels,
   ]);

   return {
      deployUnit,
      deployUnitStatus,
      deployUnitStatusLabel,
   };
}
