import { isEmpty } from '@yandex-infracloud-ui/libs';
import { useCallback, useEffect, useMemo } from 'react';
import { useDispatch, useSelector } from 'react-redux';

import { TStageDraft } from '../../proto-typings';
import { loadDraft, selectDraft } from '../slices/yp/slices/drafts';
import type { RootState } from '../store';

/**
 * Пытается взять уже загруженный драфт из хранилища redux
 *
 * Если его там нет - инициирует его загрузку в него
 *
 * @param draftId ID драфта
 */
export function useDraft(draftId: string): { rawDraft: TStageDraft | null } {
   const draftSelector = useCallback(
      s => {
         const draftData = selectDraft(s as RootState, draftId);

         return isEmpty(draftData) ? null : draftData;
      },
      [draftId],
   );

   const rawDraft = useSelector(draftSelector);

   const dispatch = useDispatch();

   useEffect(() => {
      // Загрузка драфта по его ID из роута (если его еще нет в redux-store)
      if (!rawDraft && draftId) {
         dispatch(loadDraft({ draftId }));
      }
   }, [dispatch, rawDraft, draftId]);

   return useMemo(() => ({ rawDraft: draftId ? rawDraft : null }), [rawDraft, draftId]);
}
