import { useCallback, useEffect, useRef, useState } from 'react';
import { useSelector, useDispatch } from 'react-redux';
import { TStage } from '../../proto-typings';
import { selectStageFormData } from '../slices';
import type { RootState } from '../store';
import { useStage } from './useStage';
import { formDataSlice } from '../slices/formData/formData';

// TODO: переименовать тут все 'form' в 'cache', т.к. это не только про форму
export function useFormStage(formId: string, stageId: string): { rawStage: TStage | null } {
   const { rawStage: realTimeRawStage } = useStage(stageId, true);
   const isLoadStage = realTimeRawStage !== null;
   const loading = useRef(false);
   const [loaded, setLoaded] = useState(false);

   const dispatch = useDispatch();
   useEffect(() => {
      if (isLoadStage && realTimeRawStage) {
         // устанавливаем первоначальное значение
         dispatch(formDataSlice.actions.updateStageFormData({ formId, rawStage: realTimeRawStage }));

         loading.current = true;
      }

      // только при первой загрузке сохраняем стейдж
      // eslint-disable-next-line react-hooks/exhaustive-deps
   }, [dispatch, formId, isLoadStage]);

   const stageFormDataSelector = useCallback((state: RootState) => selectStageFormData(state, formId), [formId]);
   const formData = useSelector(stageFormDataSelector);

   useEffect(() => {
      if (loading.current && formData) {
         setLoaded(true);
      }
   }, [formData]);

   const { rawStage = null } = formData ?? {};

   return {
      rawStage: loaded && rawStage?.meta?.id === stageId ? rawStage : null,
   };
}
