import { useCallback } from 'react';
import { useSelector } from 'react-redux';
import { useArrayMemo } from '../../utils';
import { selectNetworkErrorsByKeys } from '../slices';
import { NetworkItem } from '../slices/network/model';
import type { RootState } from '../store';

export function useNetworkErrors(requestKeys: string[]): Record<string, Partial<NetworkItem> | null> {
   const memoRequestKeys = useArrayMemo(requestKeys);
   const errorSelector = useCallback((s: RootState) => selectNetworkErrorsByKeys(s, memoRequestKeys), [
      memoRequestKeys,
   ]);
   const errors: Record<string, Partial<NetworkItem> | null> = useSelector(errorSelector);

   return errors;
}
