import { useCallback } from 'react';
import { useSelector } from 'react-redux';
import { selectNetworkRequestsByKeys } from '../slices';
import { NetworkRequest } from '../slices/network/model';
import type { RootState } from '../store';
import { useArrayMemo } from '../../utils';

export function useNetworkRequests(requestKeys: string[]): Record<string, Partial<NetworkRequest> | null> {
   const memoRequestKeys = useArrayMemo(requestKeys);
   const requestsSelector = useCallback((s: RootState) => selectNetworkRequestsByKeys(s, memoRequestKeys), [
      memoRequestKeys,
   ]);
   const requests: Record<string, Partial<NetworkRequest> | null> = useSelector(requestsSelector);

   return requests;
}
