// до того, как команда stagectl предоставит метод апи, значения задаются как константы

// обновляемая таблица в документации https://deploy.yandex-team.ru/docs/concepts/pod/sidecars/sidecars#quotas

import { BYTES } from '@yandex-infracloud-ui/libs';
import { SidecarName } from '../../models/ui';

const SidecarResources = {
   [SidecarName.PodAgent]: {
      1: {
         cpu: 0,
         mem: 0,
         disk: 1 * BYTES.GB,
      },
      // в https://st.yandex-team.ru/DEPLOY-4532 будет добавлены ресурсы по ядрам и памяти
      // ?: {
      //    cpu: 100,
      //    mem: 200 * BYTES.MB,
      //    disk: 1 * BYTES.GB,
      // },
   },
   [SidecarName.Juggler]: {
      1: {
         cpu: 130,
         mem: 256 * BYTES.MB,
         disk: 0,
      },
      2: {
         cpu: 130,
         mem: 256 * BYTES.MB,
         disk: 512 * BYTES.MB,
      },
   },
   [SidecarName.TVM]: {
      // вариативно
      // TODO: учесть возможные кастомные значения
      1: {
         cpu: 100,
         mem: 30 * BYTES.MB,
         disk: 950 * BYTES.MB,
      },
   },
   [SidecarName.DynamicResource]: {
      1: {
         cpu: 0,
         mem: 0,
         disk: 0,
      },
      3: {
         cpu: 100,
         mem: 128 * BYTES.MB,
         disk: 0,
      },
   },
   [SidecarName.Logbroker]: {
      1: {
         cpu: 400,
         mem: 512 * BYTES.MB,
         disk: 3 * BYTES.GB,
      },
   },
   [SidecarName.Coredump]: {
      1: {
         cpu: 0,
         mem: 0,
         disk: 0,
      },
   },
   [SidecarName.LogRotate]: {
      1: {
         cpu: 0,
         mem: 0,
         disk: 0,
      },
   },
};

export function useSidecarsQuota() {
   return SidecarResources;
}
