import { isEmpty } from '@yandex-infracloud-ui/libs';
import { useEffect, useMemo } from 'react';
import { useDispatch, useSelector } from 'react-redux';

import { StartrekTicket } from '../../models/ui';
import { fetchTicketSummary, selectTicket } from '../slices/startrek/startrek';
import type { RootState } from '../store';

/**
 * Пытается взять уже загруженный тикет из хранилища redux
 *
 * Если его там нет - инициирует его загрузку в него
 *
 * @param ticketId ID тикета // DEPLOY-3333
 * @param readonly
 */
export function useStartrekTicket(ticketId: string, readonly = false): { ticket: StartrekTicket | null } {
   const rawTicket = useSelector(s => {
      const ticketData = selectTicket(s as RootState, ticketId);

      return isEmpty(ticketData) ? null : ticketData;
   });

   const dispatch = useDispatch();

   useEffect(() => {
      // Загрузка тикета по его ID (если его еще нет в redux-store)
      if (!rawTicket && !readonly) {
         dispatch(fetchTicketSummary({ id: ticketId }));
      }
   }, [dispatch, rawTicket, ticketId, readonly]);

   return useMemo(() => ({ ticket: rawTicket ?? null }), [rawTicket]);
}
