import { useMemo } from 'react';

import { useSelector } from 'react-redux';

import { getDefaultXrayStatusSummary } from '../../models/ui/stage/XRay';
import type { RootState } from '../store';
import { useStage } from './useStage';
import { selectXRayStatus } from '../slices/xray/xray';

/**
 * пробует взять XRay статус стейджа из хранилища, не умеет инициировать загрузку
 */
export function useXRayStatus(stageId: string) {
   const { stage, rawStage } = useStage(stageId);
   const { revision, id } = stage || {};
   const { uuid } = rawStage?.meta ?? {};

   const defaultStatus = useMemo(getDefaultXrayStatusSummary, []);

   const xRayStatus =
      useSelector((store: RootState) =>
         id && uuid && revision ? selectXRayStatus(store, { id, uuid, revision }) : undefined,
      ) ?? defaultStatus;

   return { xRayStatus };
}
