import { TIMES_IN_MS, UpdateTimerMode, useUpdateTimer } from '@yandex-infracloud-ui/libs';
import { useCallback, useEffect, useMemo } from 'react';
import { useDispatch, useSelector } from 'react-redux';
import { YpLocation } from '../../models/api';
import { TMultiClusterReplicaSet } from '../../proto-typings';
import { getMulticlusterReplicaSetQueryFromFilter } from '../../utils/yp';
import { getMulticlusterReplicaSet, getYPFilter, selectYpMulticlusterReplicaSet } from '../slices';
import type { RootState } from '../store';

export function useYpMulticlusterReplicaSet(
   replicaSetId: string,
   requestKey: string,
): {
   hasLoaded: boolean;
   replicaSet: TMultiClusterReplicaSet | undefined;
} {
   const dispatch = useDispatch();

   const requestReplicaSet = useCallback(() => {
      dispatch(getMulticlusterReplicaSet.withRequestKey(requestKey).withMeta({ reset: true })(replicaSetId));
   }, [dispatch, replicaSetId, requestKey]);

   useEffect(() => {
      requestReplicaSet();
   }, []); //eslint-disable-line

   useUpdateTimer({
      callback: requestReplicaSet,
      fast: TIMES_IN_MS.Second * 10,
      slow: TIMES_IN_MS.Minute,
      mode: UpdateTimerMode.Fast,
   });

   const filterExpression = useMemo(() => getMulticlusterReplicaSetQueryFromFilter({ replicaSetId }), [replicaSetId]);
   const filterSelector = useCallback(
      (state: RootState) => getYPFilter(state, YpLocation.XDC, 'multiclusterReplicaSets', filterExpression),
      [filterExpression],
   );
   const filter = useSelector(filterSelector);
   const replicaSetSelector = useCallback((state: RootState) => selectYpMulticlusterReplicaSet(state, replicaSetId), [
      replicaSetId,
   ]);
   const replicaSet = useSelector(replicaSetSelector);

   return { hasLoaded: Boolean(filter?.hasLoaded), replicaSet };
}
