import { useCallback } from 'react';
import { useDispatch, useSelector } from 'react-redux';
import { ReplicaSetFiltersParams } from '../../models/ui/yp/models';
import { getMulticlusterReplicaSetQueryFromFilter } from '../../utils/yp';
import { getMulticlusterReplicaSets, selectContinuationTokens } from '../slices';
import { RequestState } from '../slices/network/model';
import { defaultYPLimits } from '../slices/yp/model';
import { useNetworkRequests } from './useNetworkRequests';

export function useYpMulticlusterReplicaSets(
   requestKey: string,
): {
   requestReplicaSets(filters: ReplicaSetFiltersParams, reset?: boolean): void;
   isFetching: boolean;
} {
   const dispatch = useDispatch();
   const requests = useNetworkRequests([requestKey]);
   const replicaSetsRequest = requests[requestKey];
   const status = replicaSetsRequest?.state;

   const isFetching = status === RequestState.PENDING;

   const {
      ypCluster: { multiclusterReplicaSets: replicaSetsContinuationToken },
   } = useSelector(selectContinuationTokens);

   const requestReplicaSets = useCallback(
      (filters: ReplicaSetFiltersParams, reset = false) => {
         dispatch(
            getMulticlusterReplicaSets.withRequestKey(requestKey).withMeta({ reset })(
               getMulticlusterReplicaSetQueryFromFilter(filters),
               reset ? undefined : replicaSetsContinuationToken,
               defaultYPLimits.replicaSets,
            ),
         );
      },
      [dispatch, requestKey, replicaSetsContinuationToken],
   );

   return { requestReplicaSets, isFetching };
}
