import { useEffect } from 'react';
import { useDispatch, useSelector } from 'react-redux';

import { YpLocation } from '../../models/api';
import { TNode } from '../../proto-typings';
import { getNodeInfo, selectNode } from '../slices';

export function useYpNode(nodeId: string | undefined, cluster: YpLocation, requestKey: string): TNode {
   const dispatch = useDispatch();

   const node = useSelector(selectNode);

   useEffect(() => {
      if (nodeId) {
         dispatch(getNodeInfo.withRequestKey(requestKey)(nodeId, cluster));
      }
   }, [nodeId, cluster, dispatch, requestKey]);

   return node;
}
