import { useEffect } from 'react';
import { useDispatch, useSelector } from 'react-redux';
import { YpLocation } from '../../models/api';
import { TPod } from '../../proto-typings';
import { selectNodePods, getNodePods } from '../slices';

export function useYpNodePods(nodeId: string, cluster: YpLocation, requestKey: string): TPod[] {
   const dispatch = useDispatch();

   const pods = useSelector(selectNodePods);

   useEffect(() => {
      dispatch(getNodePods.withRequestKey(requestKey)(nodeId, cluster));
   }, [nodeId, cluster, dispatch, requestKey]);

   return pods;
}
