import { useEffect } from 'react';
import { useDispatch, useSelector } from 'react-redux';
import { YpLocation } from '../../models/api';
import { TResource } from '../../proto-typings';
import { selectNodeResources, getNodeResources } from '../slices';

export function useYpNodeResources(nodeId: string, cluster: YpLocation, requestKey: string): TResource[] {
   const dispatch = useDispatch();

   const resources = useSelector(selectNodeResources);

   useEffect(() => {
      dispatch(getNodeResources.withRequestKey(requestKey)(nodeId, cluster));
   }, [nodeId, cluster, dispatch, requestKey]);

   return resources;
}
