import { useCallback } from 'react';
import { useDispatch, useSelector } from 'react-redux';

import { YpLocation } from '../../models/api';
import { NodeFiltersParams } from '../../models/ui/yp/view';
import { TNode } from '../../proto-typings';
import { getNodes, selectContinuationTokens, selectNodes } from '../slices';
import { RequestState } from '../slices/network/model';
import { useNetworkRequests } from './useNetworkRequests';

export function useYpNodes(
   cluster: YpLocation,
   requestKey: string,
): {
   nodes: TNode[];
   requestNodes: (filters: NodeFiltersParams, reset: boolean) => void;
   isFetching: boolean;
   canFetch: boolean;
} {
   const dispatch = useDispatch();
   const requests = useNetworkRequests([requestKey]);
   const historyRequest = requests[requestKey];
   const status = historyRequest?.state;
   const isFetching = status === RequestState.PENDING;

   const nodes = useSelector(selectNodes) ?? [];
   const {
      ypCluster: { nodes: nodesContinuationToken },
   } = useSelector(selectContinuationTokens);

   const canFetch = Boolean(nodesContinuationToken);

   const requestNodes = useCallback(
      (filters: NodeFiltersParams, reset) => {
         dispatch(
            getNodes.withRequestKey(requestKey).withMeta({ reset })(
               cluster,
               filters,
               reset ? undefined : nodesContinuationToken,
            ),
         );
      },
      [cluster, dispatch, requestKey, nodesContinuationToken],
   );

   return { nodes, requestNodes, isFetching, canFetch };
}
