import { useEffect } from 'react';
import { useDispatch, useSelector } from 'react-redux';

import { YpLocation } from '../../models/api';
import { TNodeSegment } from '../../proto-typings';
import { getNodesSegments, selectNodesSegments } from '../slices';

export function useYpNodesSegments(cluster: YpLocation, requestKey: string): TNodeSegment[] {
   const dispatch = useDispatch();

   const segments = useSelector(selectNodesSegments);

   useEffect(() => {
      dispatch(getNodesSegments.withRequestKey(requestKey)(cluster));
   }, [cluster, dispatch, requestKey]);

   return segments;
}
