import { useEffect } from 'react';
import { useDispatch, useSelector } from 'react-redux';

import { YpLocation } from '../../models/api';

import { getPodInfo, selectPod, selectPodTimestamp } from '../slices';
import type { RootState } from '../store';

export function useYpPod(podId: string, cluster: YpLocation, requestKey: string) {
   const dispatch = useDispatch();

   const pod = useSelector((state: RootState) => selectPod(state, podId));
   const timestamp = useSelector((state: RootState) => selectPodTimestamp(state, podId));

   useEffect(() => {
      dispatch(getPodInfo.withRequestKey(requestKey)(podId, cluster));
   }, [podId, cluster, dispatch, requestKey]);

   return { pod, timestamp };
}
