import { useEffect } from 'react';
import { useDispatch, useSelector } from 'react-redux';
import { YpLocation } from '../../models/api';
import { getPodSetInfo, selectPodSet } from '../slices';

export function useYpPodSet(podSetId: string, cluster: YpLocation, requestKey: string) {
   const dispatch = useDispatch();

   const podSet = useSelector(selectPodSet);

   useEffect(() => {
      dispatch(getPodSetInfo.withRequestKey(requestKey)(podSetId, cluster));
   }, [podSetId, cluster, dispatch, requestKey]);

   return { podSet };
}
