import { TIMES_IN_MS, UpdateTimerMode, useUpdateTimer } from '@yandex-infracloud-ui/libs';
import { useCallback, useEffect, useMemo } from 'react';
import { useDispatch, useSelector } from 'react-redux';
import { YpLocation } from '../../models/api';
import { TReplicaSet } from '../../proto-typings';
import { getReplicaSetQueryFromFilter } from '../../utils/yp';
import { getClusterReplicaSet, getYPFilter, selectYpReplicaSet } from '../slices';
import type { RootState } from '../store';

export function useYpReplicaSet(
   replicaSetId: string,
   location: YpLocation,
   requestKey: string,
): {
   hasLoaded: boolean;
   replicaSet: TReplicaSet | undefined;
} {
   const dispatch = useDispatch();

   const requestReplicaSet = useCallback(() => {
      dispatch(getClusterReplicaSet.withRequestKey(requestKey).withMeta({ reset: true })(location, replicaSetId));
   }, [dispatch, location, replicaSetId, requestKey]);

   useEffect(() => {
      requestReplicaSet();
   }, []); //eslint-disable-line

   useUpdateTimer({
      callback: requestReplicaSet,
      fast: TIMES_IN_MS.Second * 10,
      slow: TIMES_IN_MS.Minute,
      mode: UpdateTimerMode.Fast,
   });

   const filterExpression = useMemo(() => getReplicaSetQueryFromFilter({ replicaSetId }), [replicaSetId]);
   const filterSelector = useCallback(
      (state: RootState) => getYPFilter(state, location, 'replicaSets', filterExpression),
      [location, filterExpression],
   );
   const filter = useSelector(filterSelector);
   const replicaSetSelector = useCallback((state: RootState) => selectYpReplicaSet(state, location, replicaSetId), [
      replicaSetId,
      location,
   ]);
   const replicaSet = useSelector(replicaSetSelector);

   return { hasLoaded: Boolean(filter?.hasLoaded), replicaSet };
}
