import { useCallback } from 'react';
import { useDispatch, useSelector } from 'react-redux';
import { YpLocation } from '../../models/api';
import { ReplicaSetFiltersParams } from '../../models/ui/yp/models';
import { getReplicaSetQueryFromFilter } from '../../utils/yp';
import { getClusterReplicaSets, selectContinuationTokens } from '../slices';
import { RequestState } from '../slices/network/model';
import { defaultYPLimits } from '../slices/yp/model';
import { useNetworkRequests } from './useNetworkRequests';

export function useYpReplicaSets(
   cluster: YpLocation,
   requestKey: string,
): {
   requestReplicaSets(filters: ReplicaSetFiltersParams, reset?: boolean): void;
   isFetching: boolean;
} {
   const dispatch = useDispatch();
   const requests = useNetworkRequests([requestKey]);
   const replicaSetsRequest = requests[requestKey];
   const status = replicaSetsRequest?.state;

   const isFetching = status === RequestState.PENDING;

   const {
      ypCluster: { replicaSets: replicaSetsContinuationToken },
   } = useSelector(selectContinuationTokens);

   const requestReplicaSets = useCallback(
      (filters: ReplicaSetFiltersParams, reset = false) => {
         dispatch(
            getClusterReplicaSets.withRequestKey(requestKey).withMeta({ reset })(
               cluster,
               getReplicaSetQueryFromFilter(filters),
               reset ? undefined : replicaSetsContinuationToken,
               defaultYPLimits.replicaSets,
            ),
         );
      },
      [dispatch, cluster, requestKey, replicaSetsContinuationToken],
   );

   return { requestReplicaSets, isFetching };
}
