import { listToEntityStore, SortDirection, sortItemsInStore } from './EntityStore';

describe('redux|models/EntityStore', () => {
   it('listToEntityStore', () => {
      const list = [
         { id: 'a', name: 'A' },
         { id: 'b', name: 'B' },
         { id: 'c', name: 'C' },
      ];

      expect(listToEntityStore(list)).toEqual({
         allIds: ['a', 'b', 'c'],
         byIds: {
            a: { id: 'a', name: 'A' },
            b: { id: 'b', name: 'B' },
            c: { id: 'c', name: 'C' },
         },
      });
   });

   it('sortItemsInStore', () => {
      const store = listToEntityStore([
         { id: 'a', name: 'A', weight: 1 },
         { id: 'b', name: 'B', weight: 3 },
         { id: 'c', name: 'C', weight: 2 },
      ]);

      expect(store.allIds).toEqual(['a', 'b', 'c']);

      sortItemsInStore(store, {
         getField: v => v.weight,
      });

      expect(store.allIds).toEqual(['a', 'c', 'b']);

      sortItemsInStore(store, {
         getField: v => v.weight,
         direction: SortDirection.Desc,
      });

      expect(store.allIds).toEqual(['b', 'c', 'a']);
   });
});
